// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    /// <summary> The GeocodingBatchResponseItem. </summary>
    public partial class GeocodingBatchResponseItem
    {
        /// <summary> Initializes a new instance of <see cref="GeocodingBatchResponseItem"/>. </summary>
        internal GeocodingBatchResponseItem()
        {
            Features = new ChangeTrackingList<FeaturesItem>();
        }

        /// <summary> Initializes a new instance of <see cref="GeocodingBatchResponseItem"/>. </summary>
        /// <param name="optionalId"> id of the batchItem which would be the same as the id in the request. </param>
        /// <param name="type"> The type of a FeatureCollection object must be FeatureCollection. </param>
        /// <param name="features"></param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        /// <param name="error"> The error detail. </param>
        internal GeocodingBatchResponseItem(string optionalId, FeatureCollectionEnum? type, IReadOnlyList<FeaturesItem> features, string nextLink, ErrorDetail error)
        {
            OptionalId = optionalId;
            Type = type;
            Features = features;
            NextLink = nextLink;
            Error = error;
        }

        /// <summary> id of the batchItem which would be the same as the id in the request. </summary>
        public string OptionalId { get; }
        /// <summary> The type of a FeatureCollection object must be FeatureCollection. </summary>
        public FeatureCollectionEnum? Type { get; }
        /// <summary> Gets the features. </summary>
        public IReadOnlyList<FeaturesItem> Features { get; }
        /// <summary> The is the link to the next page of the features returned. If it's the last page, no this field. </summary>
        public string NextLink { get; }
        /// <summary> The error detail. </summary>
        public ErrorDetail Error { get; }
    }
}
