// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    /// <summary> This object is returned from a successful Geocoding Batch service call. </summary>
    public partial class GeocodingBatchResponse
    {
        /// <summary> Initializes a new instance of <see cref="GeocodingBatchResponse"/>. </summary>
        internal GeocodingBatchResponse()
        {
            BatchItems = new ChangeTrackingList<GeocodingBatchResponseItem>();
        }

        /// <summary> Initializes a new instance of <see cref="GeocodingBatchResponse"/>. </summary>
        /// <param name="summary"> Summary for the batch request. </param>
        /// <param name="batchItems"> Array containing the batch results. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        internal GeocodingBatchResponse(GeocodingBatchResponseSummary summary, IReadOnlyList<GeocodingBatchResponseItem> batchItems, string nextLink)
        {
            Summary = summary;
            BatchItems = batchItems;
            NextLink = nextLink;
        }

        /// <summary> Summary for the batch request. </summary>
        public GeocodingBatchResponseSummary Summary { get; }
        /// <summary> Array containing the batch results. </summary>
        public IReadOnlyList<GeocodingBatchResponseItem> BatchItems { get; }
        /// <summary> The is the link to the next page of the features returned. If it's the last page, no this field. </summary>
        public string NextLink { get; }
    }
}
