// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    public partial class GeocodingBatchResponse
    {
        internal static GeocodingBatchResponse DeserializeGeocodingBatchResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            GeocodingBatchResponseSummary summary = default;
            IReadOnlyList<GeocodingBatchResponseItem> batchItems = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("summary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    summary = GeocodingBatchResponseSummary.DeserializeGeocodingBatchResponseSummary(property.Value);
                    continue;
                }
                if (property.NameEquals("batchItems"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<GeocodingBatchResponseItem> array = new List<GeocodingBatchResponseItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(GeocodingBatchResponseItem.DeserializeGeocodingBatchResponseItem(item));
                    }
                    batchItems = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new GeocodingBatchResponse(summary, batchItems ?? new ChangeTrackingList<GeocodingBatchResponseItem>(), nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static GeocodingBatchResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeGeocodingBatchResponse(document.RootElement);
        }
    }
}
