// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Core.GeoJson;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    /// <summary> Batch Query object. </summary>
    public partial class GeocodingBatchRequestItem
    {
        /// <summary> Initializes a new instance of <see cref="GeocodingBatchRequestItem"/>. </summary>
        public GeocodingBatchRequestItem()
        {
            _BoundingBox = new ChangeTrackingList<double>();
            _Coordinates = new ChangeTrackingList<double>();
        }

        /// <summary> id of the request which would show in corresponding batchItem. </summary>
        public string OptionalId { get; set; }
        /// <summary> Maximum number of responses that will be returned. Default: 5, minimum: 1 and maximum: 20. </summary>
        public int? Top { get; set; }
        /// <summary> A string that contains information about a location, such as an address or landmark name. </summary>
        public string Query { get; set; }
        /// <summary>
        /// The official street line of an address relative to the area, as specified by the locality, or postalCode, properties. Typical use of this element would be to provide a street address or any official address.
        ///
        /// **If query is given, should not use this parameter.**
        /// </summary>
        public string AddressLine { get; set; }
        /// <summary>
        /// Signal for the geocoding result to an [ISO 3166-1 Alpha-2 region/country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) that is specified e.g. FR./
        ///
        /// **If query is given, should not use this parameter.**
        /// </summary>
        public string CountryRegion { get; set; }
        /// <summary> A string that specifies an [ISO 3166-1 Alpha-2 region/country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). This will alter Geopolitical disputed borders and labels to align with the specified user region. </summary>
        public string View { get; set; }
        /// <summary>
        /// The country subdivision portion of an address, such as WA.
        ///
        /// **If query is given, should not use this parameter.**
        /// </summary>
        public string AdminDistrict { get; set; }
        /// <summary>
        /// The county for the structured address, such as King.
        ///
        /// **If query is given, should not use this parameter.**
        /// </summary>
        public string AdminDistrict2 { get; set; }
        /// <summary>
        /// The named area for the structured address.
        ///
        /// **If query is given, should not use this parameter.**
        /// </summary>
        public string AdminDistrict3 { get; set; }
        /// <summary>
        /// The locality portion of an address, such as Seattle.
        ///
        /// **If query is given, should not use this parameter.**
        /// </summary>
        public string Locality { get; set; }
        /// <summary>
        /// The postal code portion of an address.
        ///
        /// **If query is given, should not use this parameter.**
        /// </summary>
        public string PostalCode { get; set; }
    }
}
