// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    public partial class GeocodingBatchRequestItem : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Common.Optional.IsDefined(OptionalId))
            {
                writer.WritePropertyName("optionalId"u8);
                writer.WriteStringValue(OptionalId);
            }
            if (Common.Optional.IsDefined(Top))
            {
                writer.WritePropertyName("top"u8);
                writer.WriteNumberValue(Top.Value);
            }
            if (Common.Optional.IsDefined(Query))
            {
                writer.WritePropertyName("query"u8);
                writer.WriteStringValue(Query);
            }
            if (Common.Optional.IsDefined(AddressLine))
            {
                writer.WritePropertyName("addressLine"u8);
                writer.WriteStringValue(AddressLine);
            }
            if (Common.Optional.IsDefined(CountryRegion))
            {
                writer.WritePropertyName("countryRegion"u8);
                writer.WriteStringValue(CountryRegion);
            }
            if (Common.Optional.IsCollectionDefined(_BoundingBox))
            {
                writer.WritePropertyName("boundingBox"u8);
                writer.WriteStartArray();
                foreach (var item in _BoundingBox)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (Common.Optional.IsDefined(View))
            {
                writer.WritePropertyName("view"u8);
                writer.WriteStringValue(View);
            }
            if (Common.Optional.IsCollectionDefined(_Coordinates))
            {
                writer.WritePropertyName("coordinates"u8);
                writer.WriteStartArray();
                foreach (var item in _Coordinates)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (Common.Optional.IsDefined(AdminDistrict))
            {
                writer.WritePropertyName("adminDistrict"u8);
                writer.WriteStringValue(AdminDistrict);
            }
            if (Common.Optional.IsDefined(AdminDistrict2))
            {
                writer.WritePropertyName("adminDistrict2"u8);
                writer.WriteStringValue(AdminDistrict2);
            }
            if (Common.Optional.IsDefined(AdminDistrict3))
            {
                writer.WritePropertyName("adminDistrict3"u8);
                writer.WriteStringValue(AdminDistrict3);
            }
            if (Common.Optional.IsDefined(Locality))
            {
                writer.WritePropertyName("locality"u8);
                writer.WriteStringValue(Locality);
            }
            if (Common.Optional.IsDefined(PostalCode))
            {
                writer.WritePropertyName("postalCode"u8);
                writer.WriteStringValue(PostalCode);
            }
            if (Common.Optional.IsDefined(BoundingBox))
            {
                writer.WritePropertyName("boundingBox"u8);
                SerializeBoundingBoxValue(writer);
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
