// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    /// <summary> The GeoJsonFeatureCollectionData. </summary>
    internal partial class GeoJsonFeatureCollectionData
    {
        /// <summary> Initializes a new instance of <see cref="GeoJsonFeatureCollectionData"/>. </summary>
        /// <param name="features">
        /// Contains a list of valid `GeoJSON Feature` objects.
        /// Please note <see cref="GeoJsonFeature"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="BoundaryInternal"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="features"/> is null. </exception>
        internal GeoJsonFeatureCollectionData(IEnumerable<GeoJsonFeature> features)
        {
            Argument.AssertNotNull(features, nameof(features));

            Features = features.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="GeoJsonFeatureCollectionData"/>. </summary>
        /// <param name="features">
        /// Contains a list of valid `GeoJSON Feature` objects.
        /// Please note <see cref="GeoJsonFeature"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="BoundaryInternal"/>.
        /// </param>
        internal GeoJsonFeatureCollectionData(IReadOnlyList<GeoJsonFeature> features)
        {
            Features = features;
        }

        /// <summary>
        /// Contains a list of valid `GeoJSON Feature` objects.
        /// Please note <see cref="GeoJsonFeature"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="BoundaryInternal"/>.
        /// </summary>
        public IReadOnlyList<GeoJsonFeature> Features { get; }
    }
}
