// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    internal partial class GeoJsonFeature
    {
        internal static GeoJsonFeature DeserializeGeoJsonFeature(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("type", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "Boundary": return BoundaryInternal.DeserializeBoundaryInternal(element);
                }
            }
            GeoJsonGeometry geometry = default;
            object properties = default;
            string id = default;
            string featureType = default;
            GeoJsonObjectType type = "AutoRest.CSharp.Output.Models.Types.EnumTypeValue";
            IReadOnlyList<double> bbox = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("geometry"u8))
                {
                    geometry = GeoJsonGeometry.DeserializeGeoJsonGeometry(property.Value);
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    properties = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("featureType"u8))
                {
                    featureType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new GeoJsonObjectType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("bbox"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<double> array = new List<double>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetDouble());
                    }
                    bbox = array;
                    continue;
                }
            }
            return new GeoJsonFeature(
                type,
                bbox ?? new ChangeTrackingList<double>(),
                geometry,
                properties,
                id,
                featureType);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new GeoJsonFeature FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeGeoJsonFeature(document.RootElement);
        }
    }
}
