// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    public partial class FeaturesItemProperties
    {
        internal static FeaturesItemProperties DeserializeFeaturesItemProperties(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string type = default;
            ConfidenceEnum? confidence = default;
            IReadOnlyList<MatchCodesEnum> matchCodes = default;
            Address address = default;
            IReadOnlyList<GeocodePointsItem> geocodePoints = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    type = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("confidence"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    confidence = new ConfidenceEnum(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("matchCodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MatchCodesEnum> array = new List<MatchCodesEnum>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new MatchCodesEnum(item.GetString()));
                    }
                    matchCodes = array;
                    continue;
                }
                if (property.NameEquals("address"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    address = Address.DeserializeAddress(property.Value);
                    continue;
                }
                if (property.NameEquals("geocodePoints"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<GeocodePointsItem> array = new List<GeocodePointsItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(GeocodePointsItem.DeserializeGeocodePointsItem(item));
                    }
                    geocodePoints = array;
                    continue;
                }
            }
            return new FeaturesItemProperties(type, confidence, matchCodes ?? new ChangeTrackingList<MatchCodesEnum>(), address, geocodePoints ?? new ChangeTrackingList<GeocodePointsItem>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static FeaturesItemProperties FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeFeaturesItemProperties(document.RootElement);
        }
    }
}
