// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Search.Models
{
    /// <summary> The type of a feature must be Feature. </summary>
    public readonly partial struct FeatureTypeEnum : IEquatable<FeatureTypeEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FeatureTypeEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FeatureTypeEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FeatureValue = "Feature";

        /// <summary> Feature. </summary>
        public static FeatureTypeEnum Feature { get; } = new FeatureTypeEnum(FeatureValue);
        /// <summary> Determines if two <see cref="FeatureTypeEnum"/> values are the same. </summary>
        public static bool operator ==(FeatureTypeEnum left, FeatureTypeEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FeatureTypeEnum"/> values are not the same. </summary>
        public static bool operator !=(FeatureTypeEnum left, FeatureTypeEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FeatureTypeEnum"/>. </summary>
        public static implicit operator FeatureTypeEnum(string value) => new FeatureTypeEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FeatureTypeEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FeatureTypeEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
