// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Search.Models
{
    /// <summary> The type of a FeatureCollection object must be FeatureCollection. </summary>
    public readonly partial struct FeatureCollectionEnum : IEquatable<FeatureCollectionEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FeatureCollectionEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FeatureCollectionEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FeatureCollectionValue = "FeatureCollection";

        /// <summary> FeatureCollection. </summary>
        public static FeatureCollectionEnum FeatureCollection { get; } = new FeatureCollectionEnum(FeatureCollectionValue);
        /// <summary> Determines if two <see cref="FeatureCollectionEnum"/> values are the same. </summary>
        public static bool operator ==(FeatureCollectionEnum left, FeatureCollectionEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FeatureCollectionEnum"/> values are not the same. </summary>
        public static bool operator !=(FeatureCollectionEnum left, FeatureCollectionEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FeatureCollectionEnum"/>. </summary>
        public static implicit operator FeatureCollectionEnum(string value) => new FeatureCollectionEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FeatureCollectionEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FeatureCollectionEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
