// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Search.Models
{
    /// <summary>
    /// The level of confidence that the geocoded location result is a match. Use this value with the match code to determine for more complete information about the match.
    ///
    /// The confidence of a geocoded location is based on many factors including the relative importance of the geocoded location and the user’s location, if specified.
    /// </summary>
    public readonly partial struct ConfidenceEnum : IEquatable<ConfidenceEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConfidenceEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConfidenceEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HighValue = "High";
        private const string MediumValue = "Medium";
        private const string LowValue = "Low";

        /// <summary>
        /// If the confidence is set to `High`, one or more strong matches were found. Multiple `High` confidence matches are sorted in ranked order by importance when applicable. For example, landmarks have importance but addresses do not.
        ///
        /// If a request includes a location or a view, then the ranking may change appropriately. For example, a location query for "Paris" returns "Paris, France" and "Paris, TX" both with `High` confidence. "Paris, France" is always ranked first due to importance unless a user location indicates that the user is in or very close to Paris, TX or the map view indicates that the user is searching in that area.
        /// </summary>
        public static ConfidenceEnum High { get; } = new ConfidenceEnum(HighValue);
        /// <summary>
        /// In some situations, the returned match may not be at the same level as the information provided in the request. For example, a request may specify address information and the geocode service may only be able to match a postal code. In this case, if the geocode service has a confidence that the postal code matches the data, the confidence is set to `Medium` and the match code is set to `UpHierarchy` to specify that it could not match all of the information and had to search up-hierarchy.
        ///
        /// If the location information in the query is ambiguous, and there is no additional information to rank the locations (such as user location or the relative importance of the location), the confidence is set to `Medium`. For example, a location query for "148th Ave, Bellevue" may return "148th Ave SE" and "148th Ave NE" both with `Medium` confidence.
        ///
        /// If the location information in the query does not provide enough information to geocode a specific location, a less precise location value may be returned and the confidence is set to `Medium`. For example, if an address is provided, but a match is not found for the house number, the geocode result with a Roadblock entity type may be returned.
        /// </summary>
        public static ConfidenceEnum Medium { get; } = new ConfidenceEnum(MediumValue);
        /// <summary> Low. </summary>
        public static ConfidenceEnum Low { get; } = new ConfidenceEnum(LowValue);
        /// <summary> Determines if two <see cref="ConfidenceEnum"/> values are the same. </summary>
        public static bool operator ==(ConfidenceEnum left, ConfidenceEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConfidenceEnum"/> values are not the same. </summary>
        public static bool operator !=(ConfidenceEnum left, ConfidenceEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConfidenceEnum"/>. </summary>
        public static implicit operator ConfidenceEnum(string value) => new ConfidenceEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConfidenceEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConfidenceEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
