// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Search.Models
{
    /// <summary> The method that was used to compute the geocode point. </summary>
    public readonly partial struct CalculationMethodEnum : IEquatable<CalculationMethodEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CalculationMethodEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CalculationMethodEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InterpolationValue = "Interpolation";
        private const string InterpolationOffsetValue = "InterpolationOffset";
        private const string ParcelValue = "Parcel";
        private const string RooftopValue = "Rooftop";

        /// <summary> The geocode point was matched to a point on a road using interpolation. </summary>
        public static CalculationMethodEnum Interpolation { get; } = new CalculationMethodEnum(InterpolationValue);
        /// <summary> The geocode point was matched to a point on a road using interpolation with an additional offset to shift the point to the side of the street. </summary>
        public static CalculationMethodEnum InterpolationOffset { get; } = new CalculationMethodEnum(InterpolationOffsetValue);
        /// <summary> The geocode point was matched to the center of a parcel. </summary>
        public static CalculationMethodEnum Parcel { get; } = new CalculationMethodEnum(ParcelValue);
        /// <summary> The geocode point was matched to the rooftop of a building. </summary>
        public static CalculationMethodEnum Rooftop { get; } = new CalculationMethodEnum(RooftopValue);
        /// <summary> Determines if two <see cref="CalculationMethodEnum"/> values are the same. </summary>
        public static bool operator ==(CalculationMethodEnum left, CalculationMethodEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CalculationMethodEnum"/> values are not the same. </summary>
        public static bool operator !=(CalculationMethodEnum left, CalculationMethodEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CalculationMethodEnum"/>. </summary>
        public static implicit operator CalculationMethodEnum(string value) => new CalculationMethodEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CalculationMethodEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CalculationMethodEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
