// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Search.Models
{
    /// <summary> The BoundaryResultTypeEnum. </summary>
    public readonly partial struct BoundaryResultTypeEnum : IEquatable<BoundaryResultTypeEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BoundaryResultTypeEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BoundaryResultTypeEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountryRegionValue = "countryRegion";
        private const string AdminDistrictValue = "adminDistrict";
        private const string AdminDistrict2Value = "adminDistrict2";
        private const string PostalCodeValue = "postalCode";
        private const string PostalCode2Value = "postalCode2";
        private const string PostalCode3Value = "postalCode3";
        private const string PostalCode4Value = "postalCode4";
        private const string NeighborhoodValue = "neighborhood";
        private const string LocalityValue = "locality";

        /// <summary> Country or region. </summary>
        public static BoundaryResultTypeEnum CountryRegion { get; } = new BoundaryResultTypeEnum(CountryRegionValue);
        /// <summary> First administrative level within the country/region level, such as a state or a province. </summary>
        public static BoundaryResultTypeEnum AdminDistrict { get; } = new BoundaryResultTypeEnum(AdminDistrictValue);
        /// <summary> Second administrative level within the country/region level, such as a county. </summary>
        public static BoundaryResultTypeEnum AdminDistrict2 { get; } = new BoundaryResultTypeEnum(AdminDistrict2Value);
        /// <summary> The smallest post code category, such as a zip code. </summary>
        public static BoundaryResultTypeEnum PostalCode { get; } = new BoundaryResultTypeEnum(PostalCodeValue);
        /// <summary> The next largest post code category after postalCode that is created by aggregating postalCode areas. </summary>
        public static BoundaryResultTypeEnum PostalCode2 { get; } = new BoundaryResultTypeEnum(PostalCode2Value);
        /// <summary> The next largest post code category after postalCode2 that is created by aggregating postalCode2 areas. </summary>
        public static BoundaryResultTypeEnum PostalCode3 { get; } = new BoundaryResultTypeEnum(PostalCode3Value);
        /// <summary> The next largest post code category after postalCode3 that is created by aggregating postalCode3 areas. </summary>
        public static BoundaryResultTypeEnum PostalCode4 { get; } = new BoundaryResultTypeEnum(PostalCode4Value);
        /// <summary> A section of a populated place that is typically well-known, but often with indistinct boundaries. </summary>
        public static BoundaryResultTypeEnum Neighborhood { get; } = new BoundaryResultTypeEnum(NeighborhoodValue);
        /// <summary> A concentrated area of human settlement, such as a city, town or village. </summary>
        public static BoundaryResultTypeEnum Locality { get; } = new BoundaryResultTypeEnum(LocalityValue);
        /// <summary> Determines if two <see cref="BoundaryResultTypeEnum"/> values are the same. </summary>
        public static bool operator ==(BoundaryResultTypeEnum left, BoundaryResultTypeEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BoundaryResultTypeEnum"/> values are not the same. </summary>
        public static bool operator !=(BoundaryResultTypeEnum left, BoundaryResultTypeEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BoundaryResultTypeEnum"/>. </summary>
        public static implicit operator BoundaryResultTypeEnum(string value) => new BoundaryResultTypeEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BoundaryResultTypeEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BoundaryResultTypeEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
