// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    /// <summary> Properties of a Boundary object. </summary>
    public partial class BoundaryProperties
    {
        /// <summary> Initializes a new instance of <see cref="BoundaryProperties"/>. </summary>
        internal BoundaryProperties()
        {
            GeometriesCopyright = new ChangeTrackingList<GeometryCopyright>();
        }

        /// <summary> Initializes a new instance of <see cref="BoundaryProperties"/>. </summary>
        /// <param name="name"> The name associated with the geographical area. </param>
        /// <param name="copyright"> The copyright string. </param>
        /// <param name="copyrightUrl"> A URL that lists many of the data providers for Azure Maps and their related copyright information. </param>
        /// <param name="geometriesCopyright"> A collection of copyright information for each geometry of the Boundary object in the same order they appear. </param>
        internal BoundaryProperties(string name, string copyright, string copyrightUrl, IReadOnlyList<GeometryCopyright> geometriesCopyright)
        {
            Name = name;
            Copyright = copyright;
            CopyrightUrl = copyrightUrl;
            GeometriesCopyright = geometriesCopyright;
        }

        /// <summary> The name associated with the geographical area. </summary>
        public string Name { get; }
        /// <summary> The copyright string. </summary>
        public string Copyright { get; }
        /// <summary> A collection of copyright information for each geometry of the Boundary object in the same order they appear. </summary>
        public IReadOnlyList<GeometryCopyright> GeometriesCopyright { get; }
    }
}
