// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    public partial class BoundaryProperties
    {
        internal static BoundaryProperties DeserializeBoundaryProperties(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string copyright = default;
            string copyrightURL = default;
            IReadOnlyList<GeometryCopyright> geometriesCopyright = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("copyright"u8))
                {
                    copyright = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("copyrightURL"u8))
                {
                    copyrightURL = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("geometriesCopyright"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<GeometryCopyright> array = new List<GeometryCopyright>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(GeometryCopyright.DeserializeGeometryCopyright(item));
                    }
                    geometriesCopyright = array;
                    continue;
                }
            }
            return new BoundaryProperties(name, copyright, copyrightURL, geometriesCopyright ?? new ChangeTrackingList<GeometryCopyright>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static BoundaryProperties FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeBoundaryProperties(document.RootElement);
        }
    }
}
