// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Search.Models
{
    public partial class AddressCountryRegion
    {
        internal static AddressCountryRegion DeserializeAddressCountryRegion(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string iso = default;
            string name = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("iso"u8))
                {
                    iso = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
            }
            return new AddressCountryRegion(iso, name);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AddressCountryRegion FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAddressCountryRegion(document.RootElement);
        }
    }
}
