// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    /// <summary> The address of the result. </summary>
    public partial class Address
    {
        /// <summary> Initializes a new instance of <see cref="Address"/>. </summary>
        internal Address()
        {
            AdminDistricts = new ChangeTrackingList<AddressAdminDistrictsItem>();
        }

        /// <summary> Initializes a new instance of <see cref="Address"/>. </summary>
        /// <param name="addressLine"> AddressLine that includes Street Name and Number. </param>
        /// <param name="locality"> locality property. </param>
        /// <param name="neighborhood"> neighborhood property. </param>
        /// <param name="adminDistricts"> The subdivision name in the country or region for an address. This element is typically treated as the first order administrative subdivision, but in some cases it also contains the second, third, or fourth order subdivision in a country, dependency, or region. </param>
        /// <param name="postalCode"> Postal Code property. </param>
        /// <param name="countryRegion"></param>
        /// <param name="formattedAddress"> Formatted Address property. </param>
        /// <param name="intersection"> The address of the result. </param>
        internal Address(string addressLine, string locality, string neighborhood, IReadOnlyList<AddressAdminDistrictsItem> adminDistricts, string postalCode, AddressCountryRegion countryRegion, string formattedAddress, Intersection intersection)
        {
            AddressLine = addressLine;
            Locality = locality;
            Neighborhood = neighborhood;
            AdminDistricts = adminDistricts;
            PostalCode = postalCode;
            CountryRegion = countryRegion;
            FormattedAddress = formattedAddress;
            Intersection = intersection;
        }

        /// <summary> AddressLine that includes Street Name and Number. </summary>
        public string AddressLine { get; }
        /// <summary> locality property. </summary>
        public string Locality { get; }
        /// <summary> neighborhood property. </summary>
        public string Neighborhood { get; }
        /// <summary> The subdivision name in the country or region for an address. This element is typically treated as the first order administrative subdivision, but in some cases it also contains the second, third, or fourth order subdivision in a country, dependency, or region. </summary>
        public IReadOnlyList<AddressAdminDistrictsItem> AdminDistricts { get; }
        /// <summary> Postal Code property. </summary>
        public string PostalCode { get; }
        /// <summary> Gets the country region. </summary>
        public AddressCountryRegion CountryRegion { get; }
        /// <summary> Formatted Address property. </summary>
        public string FormattedAddress { get; }
        /// <summary> The address of the result. </summary>
        public Intersection Intersection { get; }
    }
}
