// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    public partial class Address
    {
        internal static Address DeserializeAddress(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string addressLine = default;
            string locality = default;
            string neighborhood = default;
            IReadOnlyList<AddressAdminDistrictsItem> adminDistricts = default;
            string postalCode = default;
            AddressCountryRegion countryRegion = default;
            string formattedAddress = default;
            Intersection intersection = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("addressLine"u8))
                {
                    addressLine = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("locality"u8))
                {
                    locality = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("neighborhood"u8))
                {
                    neighborhood = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("adminDistricts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AddressAdminDistrictsItem> array = new List<AddressAdminDistrictsItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AddressAdminDistrictsItem.DeserializeAddressAdminDistrictsItem(item));
                    }
                    adminDistricts = array;
                    continue;
                }
                if (property.NameEquals("postalCode"u8))
                {
                    postalCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("countryRegion"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    countryRegion = AddressCountryRegion.DeserializeAddressCountryRegion(property.Value);
                    continue;
                }
                if (property.NameEquals("formattedAddress"u8))
                {
                    formattedAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("intersection"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    intersection = Intersection.DeserializeIntersection(property.Value);
                    continue;
                }
            }
            return new Address(
                addressLine,
                locality,
                neighborhood,
                adminDistricts ?? new ChangeTrackingList<AddressAdminDistrictsItem>(),
                postalCode,
                countryRegion,
                formattedAddress,
                intersection);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static Address FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAddress(document.RootElement);
        }
    }
}
