// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing
{
    /// <summary> The rendered langauge showing on the map images or map tiles. </summary>
    public readonly partial struct RoutingLanguage : IEquatable<RoutingLanguage>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RoutingLanguage"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RoutingLanguage(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AfrikaansValue = "af-ZA";
        private const string ArabicValue = "ar";
        private const string BulgarianValue = "bg-BG";
        private const string CzechValue = "cs-CZ";
        private const string DanishValue = "da-DK";
        private const string GermanValue = "de-DE";
        private const string GreekValue = "el-GR";
        private const string EnglishGreatBritainValue = "en-GB";
        private const string EnglishUsaValue = "en-US";
        private const string SpanishSpainValue = "es-ES";
        private const string SpanishMexicoValue = "es-MX";
        private const string FinnishValue = "fi-FI";
        private const string FrenchFranceValue = "fr-FR";
        private const string HungarianValue = "hu-HU";
        private const string IndonesianValue = "id-ID";
        private const string ItalianValue = "it-IT";
        private const string KoreanValue = "ko-KR";
        private const string LithuanianValue = "lt-LT";
        private const string MalayValue = "ms-MY";
        private const string NorwegianValue = "nb-NO";
        private const string DutchNetherlandsValue = "nl-NL";
        private const string PolishValue = "pl-PL";
        private const string PortugueseBrazilValue = "pt-BR";
        private const string PortuguesePortugalValue = "pt-PT";
        private const string RussianValue = "ru-RU";
        private const string SlovakValue = "sk-SK";
        private const string SlovenianValue = "sl-SL";
        private const string SwedishValue = "sv-SE";
        private const string ThaiValue = "th-TH";
        private const string TurkishValue = "tr-TR";
        private const string TraditionalChineseValue = "zh-TW";


        /// <summary> Return Arabic ("af-ZA"). </summary>
        public static RoutingLanguage Afrikaans { get; } = new RoutingLanguage(AfrikaansValue);
        /// <summary> Return Arabic ("ar"). </summary>
        public static RoutingLanguage Arabic { get; } = new RoutingLanguage(ArabicValue);
        /// <summary> Return Bulgarian ("bg-BG"). </summary>
        public static RoutingLanguage Bulgarian { get; } = new RoutingLanguage(BulgarianValue);
        /// <summary> Return Czech ("ca-CZ"). </summary>
        public static RoutingLanguage Czech { get; } = new RoutingLanguage(CzechValue);
        /// <summary> Return Danish ("da-DK"). </summary>
        public static RoutingLanguage Danish { get; } = new RoutingLanguage(DanishValue);
        /// <summary> Return German ("de-DE"). </summary>
        public static RoutingLanguage German { get; } = new RoutingLanguage(GermanValue);
        /// <summary> Return Greek ("el-GR"). </summary>
        public static RoutingLanguage Greek { get; } = new RoutingLanguage(GreekValue);
        /// <summary> Return English (Great Britain) ("en-GB"). </summary>
        public static RoutingLanguage EnglishGreatBritain { get; } = new RoutingLanguage(EnglishGreatBritainValue);
        /// <summary> Return English (USA) ("en-US"). </summary>
        public static RoutingLanguage EnglishUsa { get; } = new RoutingLanguage(EnglishUsaValue);
        /// <summary> Return Spanish (Spain) ("es-ES"). </summary>
        public static RoutingLanguage SpanishSpain { get; } = new RoutingLanguage(SpanishSpainValue);
        /// <summary> Return Spanish (Mexico) ("es-MX"). </summary>
        public static RoutingLanguage SpanishMexico { get; } = new RoutingLanguage(SpanishMexicoValue);
        /// <summary> Return Finnish ("fi-FI"). </summary>
        public static RoutingLanguage Finnish { get; } = new RoutingLanguage(FinnishValue);
        /// <summary> Return French (France) ("fr-FR"). </summary>
        public static RoutingLanguage FrenchFrance { get; } = new RoutingLanguage(FrenchFranceValue);
        /// <summary> Return Hungarian ("hu-HU"). </summary>
        public static RoutingLanguage Hungarian { get; } = new RoutingLanguage(HungarianValue);
        /// <summary> Return Indonesian ("id-ID"). </summary>
        public static RoutingLanguage Indonesian { get; } = new RoutingLanguage(IndonesianValue);
        /// <summary> Return Italian ("it-IT"). </summary>
        public static RoutingLanguage Italian { get; } = new RoutingLanguage(ItalianValue);
        /// <summary> Return Korean ("ko-KR"). </summary>
        public static RoutingLanguage Korean { get; } = new RoutingLanguage(KoreanValue);
        /// <summary> Return Lithuanian ("lt-LT"). </summary>
        public static RoutingLanguage Lithuanian { get; } = new RoutingLanguage(LithuanianValue);
        /// <summary> Return Malay ("ms-MY"). </summary>
        public static RoutingLanguage Malay { get; } = new RoutingLanguage(MalayValue);
        /// <summary> Return Norwegian ("nb-NO"). </summary>
        public static RoutingLanguage Norwegian { get; } = new RoutingLanguage(NorwegianValue);
        /// <summary> Return Dutch (Netherlands) ("nl-NL"). </summary>
        public static RoutingLanguage DutchNetherlands { get; } = new RoutingLanguage(DutchNetherlandsValue);
        /// <summary> Return Polish ("pl-PL"). </summary>
        public static RoutingLanguage Polish { get; } = new RoutingLanguage(PolishValue);
        /// <summary> Return Portuguese (Brazil) ("pt-BR"). </summary>
        public static RoutingLanguage PortugueseBrazil { get; } = new RoutingLanguage(PortugueseBrazilValue);
        /// <summary> Return Portuguese (Portugal) ("pt-PT"). </summary>
        public static RoutingLanguage PortuguesePortugal { get; } = new RoutingLanguage(PortuguesePortugalValue);
        /// <summary> Return Russian ("ru-RU"). </summary>
        public static RoutingLanguage Russian { get; } = new RoutingLanguage(RussianValue);
        /// <summary> Return Slovak ("sk-SK"). </summary>
        public static RoutingLanguage Slovak { get; } = new RoutingLanguage(SlovakValue);
        /// <summary> Return Slovenian ("sl-SL"). </summary>
        public static RoutingLanguage Slovenian { get; } = new RoutingLanguage(SlovenianValue);
        /// <summary> Return Swedish ("sv-SE"). </summary>
        public static RoutingLanguage Swedish { get; } = new RoutingLanguage(SwedishValue);
        /// <summary> Return Thai ("th-TH"). </summary>
        public static RoutingLanguage Thai { get; } = new RoutingLanguage(ThaiValue);
        /// <summary> Return Turkish ("tr-TR"). </summary>
        public static RoutingLanguage Turkish { get; } = new RoutingLanguage(TurkishValue);
        /// <summary> Return Traditional Chinese ("zh-TW"). </summary>
        public static RoutingLanguage TraditionalChinese { get; } = new RoutingLanguage(TraditionalChineseValue);
        /// <summary> Determines if two <see cref="RoutingLanguage"/> values are the same. </summary>
        public static bool operator ==(RoutingLanguage left, RoutingLanguage right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RoutingLanguage"/> values are not the same. </summary>
        public static bool operator !=(RoutingLanguage left, RoutingLanguage right) => !left.Equals(right);
        /// <summary> Converts a string to a <see cref="RoutingLanguage"/>. </summary>
        public static implicit operator RoutingLanguage(string value) => new RoutingLanguage(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RoutingLanguage other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RoutingLanguage other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value?.GetHashCode() ?? 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
