// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.Maps.Common;
using Azure.Maps.Routing.Models;

namespace Azure.Maps.Routing
{
    internal partial class RouteRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _clientId;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of RouteRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="clientId"> Specifies which account is intended for usage in conjunction with the Microsoft Entra ID security model.  It represents a unique ID for the Azure Maps account and can be retrieved from the Azure Maps management  plane Account API. To use Microsoft Entra ID security in Azure Maps see the following [articles](https://aka.ms/amauthdetails) for guidance. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public RouteRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint = null, string clientId = null, string apiVersion = "1.0")
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://atlas.microsoft.com");
            _clientId = clientId;
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreateRequestRouteMatrixRequest(JsonFormat format, RouteMatrixQuery routeMatrixQuery, bool? waitForResults, TravelTimeType? computeTravelTime, IEnumerable<SectionType> filterSectionType, DateTimeOffset? arriveAt, DateTimeOffset? departAt, int? vehicleAxleWeight, double? vehicleLength, double? vehicleHeight, double? vehicleWidth, int? vehicleMaxSpeed, int? vehicleWeight, WindingnessLevel? windingness, InclineLevel? inclineLevel, TravelMode? travelMode, IEnumerable<RouteAvoidType> avoid, bool? useTrafficData, RouteType? routeType, VehicleLoadType? vehicleLoadType)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/route/matrix/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (waitForResults != null)
            {
                uri.AppendQuery("waitForResults", waitForResults.Value, true);
            }
            if (computeTravelTime != null)
            {
                uri.AppendQuery("computeTravelTimeFor", computeTravelTime.Value.ToString(), true);
            }
            if (filterSectionType != null && !(filterSectionType is Common.ChangeTrackingList<SectionType> changeTrackingList && changeTrackingList.IsUndefined))
            {
                foreach (var param in filterSectionType)
                {
                    uri.AppendQuery("sectionType", param.ToString(), true);
                }
            }
            if (arriveAt != null)
            {
                uri.AppendQuery("arriveAt", arriveAt.Value, "O", true);
            }
            if (departAt != null)
            {
                uri.AppendQuery("departAt", departAt.Value, "O", true);
            }
            if (vehicleAxleWeight != null)
            {
                uri.AppendQuery("vehicleAxleWeight", vehicleAxleWeight.Value, true);
            }
            if (vehicleLength != null)
            {
                uri.AppendQuery("vehicleLength", vehicleLength.Value, true);
            }
            if (vehicleHeight != null)
            {
                uri.AppendQuery("vehicleHeight", vehicleHeight.Value, true);
            }
            if (vehicleWidth != null)
            {
                uri.AppendQuery("vehicleWidth", vehicleWidth.Value, true);
            }
            if (vehicleMaxSpeed != null)
            {
                uri.AppendQuery("vehicleMaxSpeed", vehicleMaxSpeed.Value, true);
            }
            if (vehicleWeight != null)
            {
                uri.AppendQuery("vehicleWeight", vehicleWeight.Value, true);
            }
            if (windingness != null)
            {
                uri.AppendQuery("windingness", windingness.Value.ToString(), true);
            }
            if (inclineLevel != null)
            {
                uri.AppendQuery("hilliness", inclineLevel.Value.ToString(), true);
            }
            if (travelMode != null)
            {
                uri.AppendQuery("travelMode", travelMode.Value.ToString(), true);
            }
            if (avoid != null && !(avoid is Common.ChangeTrackingList<RouteAvoidType> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                foreach (var param in avoid)
                {
                    uri.AppendQuery("avoid", param.ToString(), true);
                }
            }
            if (useTrafficData != null)
            {
                uri.AppendQuery("traffic", useTrafficData.Value, true);
            }
            if (routeType != null)
            {
                uri.AppendQuery("routeType", routeType.Value.ToString(), true);
            }
            if (vehicleLoadType != null)
            {
                uri.AppendQuery("vehicleLoadType", vehicleLoadType.Value.ToString(), true);
            }
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(routeMatrixQuery);
            request.Content = content;
            return message;
        }

        /// <summary> Use to get a route matrix showing the travel time and distance for all possible pairs in a list of origins and destinations, using an asynchronous request. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="routeMatrixQuery"> The matrix of origin and destination coordinates to compute the route distance, travel time and other summary for each cell of the matrix based on the input parameters. The minimum and the maximum cell count supported are 1 and **700** for async and **100** for sync respectively. For example, it can be 35 origins and 20 destinations or 25 origins and 25 destinations for async API. </param>
        /// <param name="waitForResults"> Boolean to indicate whether to execute the request synchronously. If set to true, user will get a 200 response if the request is finished under 120 seconds. Otherwise, user will get a 202 response right away. Please refer to the API description for more details on 202 response. **Supported only for async request**. </param>
        /// <param name="computeTravelTime"> Specifies whether to return additional travel times using different types of traffic information (none, historic, live) as well as the default best-estimate travel time. </param>
        /// <param name="filterSectionType"> Specifies which of the section types is reported in the route response. &lt;br&gt;&lt;br&gt;For example if sectionType = pedestrian the sections which are suited for pedestrians only are returned. Can be specified multiple times in one request, for example, '&amp;sectionType=carTrain&amp;sectionType=pedestrian&amp;sectionType=motorway'. The default sectionType refers to the travelMode input. By default travelMode is set to car. </param>
        /// <param name="arriveAt">
        /// The date and time of arrival at the destination point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified it will be assumed to be that of the destination point.
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `arriveAt` parameter cannot be used in conjunction with `departAt`, `minDeviationDistance` or `minDeviationTime`.
        /// </param>
        /// <param name="departAt">
        /// The date and time of departure from the origin point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified, it will be assumed to be that of the origin point.
        ///   * Default value: now
        ///   * Other value: `dateTime`
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `departAt` parameter cannot be used in conjunction with `arriveAt`.
        /// </param>
        /// <param name="vehicleAxleWeight"> Weight per axle of the vehicle in kg. A value of 0 means that weight restrictions per axle are not considered. </param>
        /// <param name="vehicleLength"> Length of the vehicle in meters. A value of 0 means that length restrictions are not considered. </param>
        /// <param name="vehicleHeight"> Height of the vehicle in meters. A value of 0 means that height restrictions are not considered. </param>
        /// <param name="vehicleWidth"> Width of the vehicle in meters. A value of 0 means that width restrictions are not considered. </param>
        /// <param name="vehicleMaxSpeed">
        /// Maximum speed of the vehicle in km/hour. The max speed in the vehicle profile is used to check whether a vehicle is allowed on motorways.
        ///
        /// * A value of 0 means that an appropriate value for the vehicle will be determined and applied during route planning.
        ///
        /// * A non-zero value may be overridden during route planning. For example, the current traffic flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will again use 60 km/hour.
        /// </param>
        /// <param name="vehicleWeight"> Weight of the vehicle in kilograms. </param>
        /// <param name="windingness"> Level of turns for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="inclineLevel"> Degree of hilliness for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="travelMode"> The mode of travel for the requested route. If not defined, default is 'car'. Note that the requested travelMode may not be available for the entire route. Where the requested travelMode is not available for a particular section, the travelMode element of the response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van are BETA functionality. Full restriction data is not available in all areas. </param>
        /// <param name="avoid"> Specifies something that the route calculation should try to avoid when determining the route. Can be specified multiple times in one request, for example, '&amp;avoid=motorways&amp;avoid=tollRoads&amp;avoid=ferries'. In Route Range requests, the value alreadyUsedRoads must not be used. </param>
        /// <param name="useTrafficData">
        /// Possible values:
        ///   * true - Do consider all available traffic information during routing
        ///   * false - Ignore current traffic data during routing. Note that although the current traffic data is ignored
        ///   during routing, the effect of historic traffic on effective road speeds is still incorporated.
        /// </param>
        /// <param name="routeType"> The type of route requested. </param>
        /// <param name="vehicleLoadType"> Types of cargo that may be classified as hazardous materials and restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9, plus generic classifications for use in other countries/regions. Values beginning with USHazmat are for US routing while otherHazmat should be used for all other countries/regions. vehicleLoadType can be specified multiple times. This parameter is currently only considered for travelMode=truck. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="routeMatrixQuery"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Post Route Matrix` API is an HTTP `POST` request that allows calculation of a matrix of route summaries for a set of routes defined by origin and destination locations by using an asynchronous (async) request. To make a synchronous (sync) request, see [Post Route Matrix Sync](/rest/api/maps/route/post-route-matrix-sync). For every given origin, the service calculates the cost of routing from that origin to every given destination. The set of origins and the set of destinations can be thought of as the column and row headers of a table and each cell in the table contains the costs of routing from the origin to the destination for that cell. As an example, let's say a food delivery company has 20 drivers and they need to find the closest driver to pick up the delivery from the restaurant. To solve this use case, they can call Matrix Route API.
        ///
        ///
        /// For each route, the travel times and distances are returned. You can use the computed costs to determine which detailed routes to calculate using the Route Directions API.
        ///
        ///
        /// The maximum size of a matrix for async request is **700** and for sync request it's **100** (the number of origins multiplied by the number of destinations).
        ///
        ///
        ///
        /// ### Submit Synchronous Route Matrix Request
        /// If your scenario requires synchronous requests and the maximum size of the matrix is less than or equal to 100, you might want to make synchronous request. The maximum size of a matrix for this API is **100** (the number of origins multiplied by the number of destinations). With that constraint in mind, examples of possible matrix dimensions are: 10x10, 6x8, 9x8 (it does not need to be square).
        ///
        /// ```
        /// POST https://atlas.microsoft.com/route/matrix/sync/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        ///
        /// ### Submit Asynchronous Route Matrix Request
        /// The Asynchronous API is appropriate for processing big volumes of relatively complex routing requests. When you make a request by using async request, by default the service returns a 202 response code along a redirect URL in the Location field of the response header. This URL should be checked periodically until the response data or error information is available. If `waitForResults` parameter in the request is set to true, user will get a 200 response if the request is finished under 120 seconds.
        ///
        ///
        /// The maximum size of a matrix for this API is **700** (the number of origins multiplied by the number of destinations). With that constraint in mind, examples of possible matrix dimensions are: 50x10, 10x10, 28x25. 10x70 (it does not need to be square).
        ///
        ///
        /// The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response if used after the expiration period.
        ///
        ///
        ///
        ///
        /// ```
        /// POST https://atlas.microsoft.com/route/matrix/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        ///
        /// Here's a typical sequence of asynchronous operations:
        /// 1. Client sends a Route Matrix POST request to Azure Maps
        ///
        /// 2. The server will respond with one of the following:
        ///
        ///     &gt; HTTP `202 Accepted` -  Route Matrix request has been accepted.
        ///
        ///     &gt; HTTP `Error` - There was an error processing your Route Matrix request. This could either be a 400 Bad Request or any other Error status code.
        ///
        ///
        /// 3. If the Matrix Route request was accepted successfully, the Location header in the response contains the URL to download the results of the request. This status URI looks like the following:
        ///
        ///   ```
        ///     GET https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}
        ///   ```
        ///
        ///
        /// 4. Client issues a GET request on the download URL obtained in Step 3 to download the results
        ///
        /// ### Download Sync Results
        /// When you make a POST request for Route Matrix Sync API, the service returns 200 response code for successful request and a response array. The response body will contain the data and there will be no possibility to retrieve the results later.
        ///
        /// ### Download Async Results
        /// When a request issues a `202 Accepted` response, the request is being processed using our async pipeline. You will be given a URL to check the progress of your  async request in the location header of the response. This status URI looks like the following:
        /// ```
        ///   GET https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}
        /// ```
        ///
        /// The URL provided by the location header will return the following responses when a `GET` request is issued.
        ///
        ///   &gt; HTTP `202 Accepted` - Matrix request was accepted but is still being processed. Please try again in some time.
        ///
        ///   &gt; HTTP `200 OK` - Matrix request successfully processed. The response body contains all of the results.
        /// </remarks>
        public async Task<ResponseWithHeaders<RouteRequestRouteMatrixHeaders>> RequestRouteMatrixAsync(JsonFormat format, RouteMatrixQuery routeMatrixQuery, bool? waitForResults = null, TravelTimeType? computeTravelTime = null, IEnumerable<SectionType> filterSectionType = null, DateTimeOffset? arriveAt = null, DateTimeOffset? departAt = null, int? vehicleAxleWeight = null, double? vehicleLength = null, double? vehicleHeight = null, double? vehicleWidth = null, int? vehicleMaxSpeed = null, int? vehicleWeight = null, WindingnessLevel? windingness = null, InclineLevel? inclineLevel = null, TravelMode? travelMode = null, IEnumerable<RouteAvoidType> avoid = null, bool? useTrafficData = null, RouteType? routeType = null, VehicleLoadType? vehicleLoadType = null, CancellationToken cancellationToken = default)
        {
            if (routeMatrixQuery == null)
            {
                throw new ArgumentNullException(nameof(routeMatrixQuery));
            }

            using var message = CreateRequestRouteMatrixRequest(format, routeMatrixQuery, waitForResults, computeTravelTime, filterSectionType, arriveAt, departAt, vehicleAxleWeight, vehicleLength, vehicleHeight, vehicleWidth, vehicleMaxSpeed, vehicleWeight, windingness, inclineLevel, travelMode, avoid, useTrafficData, routeType, vehicleLoadType);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new RouteRequestRouteMatrixHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to get a route matrix showing the travel time and distance for all possible pairs in a list of origins and destinations, using an asynchronous request. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="routeMatrixQuery"> The matrix of origin and destination coordinates to compute the route distance, travel time and other summary for each cell of the matrix based on the input parameters. The minimum and the maximum cell count supported are 1 and **700** for async and **100** for sync respectively. For example, it can be 35 origins and 20 destinations or 25 origins and 25 destinations for async API. </param>
        /// <param name="waitForResults"> Boolean to indicate whether to execute the request synchronously. If set to true, user will get a 200 response if the request is finished under 120 seconds. Otherwise, user will get a 202 response right away. Please refer to the API description for more details on 202 response. **Supported only for async request**. </param>
        /// <param name="computeTravelTime"> Specifies whether to return additional travel times using different types of traffic information (none, historic, live) as well as the default best-estimate travel time. </param>
        /// <param name="filterSectionType"> Specifies which of the section types is reported in the route response. &lt;br&gt;&lt;br&gt;For example if sectionType = pedestrian the sections which are suited for pedestrians only are returned. Can be specified multiple times in one request, for example, '&amp;sectionType=carTrain&amp;sectionType=pedestrian&amp;sectionType=motorway'. The default sectionType refers to the travelMode input. By default travelMode is set to car. </param>
        /// <param name="arriveAt">
        /// The date and time of arrival at the destination point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified it will be assumed to be that of the destination point.
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `arriveAt` parameter cannot be used in conjunction with `departAt`, `minDeviationDistance` or `minDeviationTime`.
        /// </param>
        /// <param name="departAt">
        /// The date and time of departure from the origin point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified, it will be assumed to be that of the origin point.
        ///   * Default value: now
        ///   * Other value: `dateTime`
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `departAt` parameter cannot be used in conjunction with `arriveAt`.
        /// </param>
        /// <param name="vehicleAxleWeight"> Weight per axle of the vehicle in kg. A value of 0 means that weight restrictions per axle are not considered. </param>
        /// <param name="vehicleLength"> Length of the vehicle in meters. A value of 0 means that length restrictions are not considered. </param>
        /// <param name="vehicleHeight"> Height of the vehicle in meters. A value of 0 means that height restrictions are not considered. </param>
        /// <param name="vehicleWidth"> Width of the vehicle in meters. A value of 0 means that width restrictions are not considered. </param>
        /// <param name="vehicleMaxSpeed">
        /// Maximum speed of the vehicle in km/hour. The max speed in the vehicle profile is used to check whether a vehicle is allowed on motorways.
        ///
        /// * A value of 0 means that an appropriate value for the vehicle will be determined and applied during route planning.
        ///
        /// * A non-zero value may be overridden during route planning. For example, the current traffic flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will again use 60 km/hour.
        /// </param>
        /// <param name="vehicleWeight"> Weight of the vehicle in kilograms. </param>
        /// <param name="windingness"> Level of turns for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="inclineLevel"> Degree of hilliness for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="travelMode"> The mode of travel for the requested route. If not defined, default is 'car'. Note that the requested travelMode may not be available for the entire route. Where the requested travelMode is not available for a particular section, the travelMode element of the response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van are BETA functionality. Full restriction data is not available in all areas. </param>
        /// <param name="avoid"> Specifies something that the route calculation should try to avoid when determining the route. Can be specified multiple times in one request, for example, '&amp;avoid=motorways&amp;avoid=tollRoads&amp;avoid=ferries'. In Route Range requests, the value alreadyUsedRoads must not be used. </param>
        /// <param name="useTrafficData">
        /// Possible values:
        ///   * true - Do consider all available traffic information during routing
        ///   * false - Ignore current traffic data during routing. Note that although the current traffic data is ignored
        ///   during routing, the effect of historic traffic on effective road speeds is still incorporated.
        /// </param>
        /// <param name="routeType"> The type of route requested. </param>
        /// <param name="vehicleLoadType"> Types of cargo that may be classified as hazardous materials and restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9, plus generic classifications for use in other countries/regions. Values beginning with USHazmat are for US routing while otherHazmat should be used for all other countries/regions. vehicleLoadType can be specified multiple times. This parameter is currently only considered for travelMode=truck. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="routeMatrixQuery"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Post Route Matrix` API is an HTTP `POST` request that allows calculation of a matrix of route summaries for a set of routes defined by origin and destination locations by using an asynchronous (async) request. To make a synchronous (sync) request, see [Post Route Matrix Sync](/rest/api/maps/route/post-route-matrix-sync). For every given origin, the service calculates the cost of routing from that origin to every given destination. The set of origins and the set of destinations can be thought of as the column and row headers of a table and each cell in the table contains the costs of routing from the origin to the destination for that cell. As an example, let's say a food delivery company has 20 drivers and they need to find the closest driver to pick up the delivery from the restaurant. To solve this use case, they can call Matrix Route API.
        ///
        ///
        /// For each route, the travel times and distances are returned. You can use the computed costs to determine which detailed routes to calculate using the Route Directions API.
        ///
        ///
        /// The maximum size of a matrix for async request is **700** and for sync request it's **100** (the number of origins multiplied by the number of destinations).
        ///
        ///
        ///
        /// ### Submit Synchronous Route Matrix Request
        /// If your scenario requires synchronous requests and the maximum size of the matrix is less than or equal to 100, you might want to make synchronous request. The maximum size of a matrix for this API is **100** (the number of origins multiplied by the number of destinations). With that constraint in mind, examples of possible matrix dimensions are: 10x10, 6x8, 9x8 (it does not need to be square).
        ///
        /// ```
        /// POST https://atlas.microsoft.com/route/matrix/sync/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        ///
        /// ### Submit Asynchronous Route Matrix Request
        /// The Asynchronous API is appropriate for processing big volumes of relatively complex routing requests. When you make a request by using async request, by default the service returns a 202 response code along a redirect URL in the Location field of the response header. This URL should be checked periodically until the response data or error information is available. If `waitForResults` parameter in the request is set to true, user will get a 200 response if the request is finished under 120 seconds.
        ///
        ///
        /// The maximum size of a matrix for this API is **700** (the number of origins multiplied by the number of destinations). With that constraint in mind, examples of possible matrix dimensions are: 50x10, 10x10, 28x25. 10x70 (it does not need to be square).
        ///
        ///
        /// The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response if used after the expiration period.
        ///
        ///
        ///
        ///
        /// ```
        /// POST https://atlas.microsoft.com/route/matrix/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        ///
        /// Here's a typical sequence of asynchronous operations:
        /// 1. Client sends a Route Matrix POST request to Azure Maps
        ///
        /// 2. The server will respond with one of the following:
        ///
        ///     &gt; HTTP `202 Accepted` -  Route Matrix request has been accepted.
        ///
        ///     &gt; HTTP `Error` - There was an error processing your Route Matrix request. This could either be a 400 Bad Request or any other Error status code.
        ///
        ///
        /// 3. If the Matrix Route request was accepted successfully, the Location header in the response contains the URL to download the results of the request. This status URI looks like the following:
        ///
        ///   ```
        ///     GET https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}
        ///   ```
        ///
        ///
        /// 4. Client issues a GET request on the download URL obtained in Step 3 to download the results
        ///
        /// ### Download Sync Results
        /// When you make a POST request for Route Matrix Sync API, the service returns 200 response code for successful request and a response array. The response body will contain the data and there will be no possibility to retrieve the results later.
        ///
        /// ### Download Async Results
        /// When a request issues a `202 Accepted` response, the request is being processed using our async pipeline. You will be given a URL to check the progress of your  async request in the location header of the response. This status URI looks like the following:
        /// ```
        ///   GET https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}
        /// ```
        ///
        /// The URL provided by the location header will return the following responses when a `GET` request is issued.
        ///
        ///   &gt; HTTP `202 Accepted` - Matrix request was accepted but is still being processed. Please try again in some time.
        ///
        ///   &gt; HTTP `200 OK` - Matrix request successfully processed. The response body contains all of the results.
        /// </remarks>
        public ResponseWithHeaders<RouteRequestRouteMatrixHeaders> RequestRouteMatrix(JsonFormat format, RouteMatrixQuery routeMatrixQuery, bool? waitForResults = null, TravelTimeType? computeTravelTime = null, IEnumerable<SectionType> filterSectionType = null, DateTimeOffset? arriveAt = null, DateTimeOffset? departAt = null, int? vehicleAxleWeight = null, double? vehicleLength = null, double? vehicleHeight = null, double? vehicleWidth = null, int? vehicleMaxSpeed = null, int? vehicleWeight = null, WindingnessLevel? windingness = null, InclineLevel? inclineLevel = null, TravelMode? travelMode = null, IEnumerable<RouteAvoidType> avoid = null, bool? useTrafficData = null, RouteType? routeType = null, VehicleLoadType? vehicleLoadType = null, CancellationToken cancellationToken = default)
        {
            if (routeMatrixQuery == null)
            {
                throw new ArgumentNullException(nameof(routeMatrixQuery));
            }

            using var message = CreateRequestRouteMatrixRequest(format, routeMatrixQuery, waitForResults, computeTravelTime, filterSectionType, arriveAt, departAt, vehicleAxleWeight, vehicleLength, vehicleHeight, vehicleWidth, vehicleMaxSpeed, vehicleWeight, windingness, inclineLevel, travelMode, avoid, useTrafficData, routeType, vehicleLoadType);
            _pipeline.Send(message, cancellationToken);
            var headers = new RouteRequestRouteMatrixHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetRouteMatrixRequest(string matrixId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/route/matrix/", false);
            uri.AppendPath(matrixId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Use to get a route matrix showing the travel time and distance for all possible pairs in a list of origins and destinations. </summary>
        /// <param name="matrixId"> Matrix id received after the Matrix Route request was accepted successfully. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="matrixId"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Route Matrix` API is an HTTP `GET` request that computes the travel time and distance for all possible pairs in a list of origins and destinations. Unlike the [Get Route Directions](/rest/api/maps/route/get-route-directions) API, which provide detailed route instructions, this API focuses on efficiency by giving you the cost (travel time and distance) of routing from each origin to every destination.  For more information, see [Best practices for Azure Maps Route service](/azure/azure-maps/how-to-use-best-practices-for-routing).
        ///
        /// For every given origin, the service calculates the cost of routing from that origin to every given destination. The set of origins and the set of destinations can be thought of as the column and row headers of a table and each cell in the table contains the costs of routing from the origin to the destination for that cell. As an example, let's say a food delivery company has 20 drivers and they need to find the closest driver to pick up the delivery from the restaurant. To solve this use case, they can call Matrix Route API.
        ///
        ///
        /// For each route, the travel times and distances are returned. You can use the computed costs to determine which detailed routes to calculate using the Route Directions API.
        ///
        ///
        /// The maximum size of a matrix for async request is **700** and for sync request it's **100** (the number of origins multiplied by the number of destinations).
        ///
        ///
        ///
        /// ### Submit Synchronous Route Matrix Request
        /// If your scenario requires synchronous requests and the maximum size of the matrix is less than or equal to 100, you might want to make synchronous request. The maximum size of a matrix for this API is **100** (the number of origins multiplied by the number of destinations). With that constraint in mind, examples of possible matrix dimensions are: 10x10, 6x8, 9x8 (it does not need to be square).
        ///
        /// ```
        /// GET https://atlas.microsoft.com/route/matrix/sync/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        ///
        /// ### Submit Asynchronous Route Matrix Request
        /// The Asynchronous API is appropriate for processing big volumes of relatively complex routing requests. When you make a request by using async request, by default the service returns a 202 response code along a redirect URL in the Location field of the response header. This URL should be checked periodically until the response data or error information is available. If `waitForResults` parameter in the request is set to true, user will get a 200 response if the request is finished under 120 seconds.
        ///
        ///
        /// The maximum size of a matrix for this API is **700** (the number of origins multiplied by the number of destinations). With that constraint in mind, examples of possible matrix dimensions are: 50x10, 10x10, 28x25. 10x70 (it does not need to be square).
        ///
        ///
        /// The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response if used after the expiration period.
        ///
        ///
        ///
        ///
        /// ```
        /// GET https://atlas.microsoft.com/route/matrix/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        ///
        /// Here's a typical sequence of asynchronous operations:
        /// 1. Client sends a Route Matrix GET request to Azure Maps
        ///
        /// 2. The server will respond with one of the following:
        ///
        ///     &gt; HTTP `202 Accepted` -  Route Matrix request has been accepted.
        ///
        ///     &gt; HTTP `Error` - There was an error processing your Route Matrix request. This could either be a 400 Bad Request or any other Error status code.
        ///
        ///
        /// 3. If the Matrix Route request was accepted successfully, the Location header in the response contains the URL to download the results of the request. This status URI looks like the following:
        ///
        ///   ```
        ///     GET https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}
        ///   ```
        ///
        ///
        /// 4. Client issues a GET request on the download URL obtained in Step 3 to download the results
        ///
        /// ### Download Sync Results
        /// When you make a GET request for Route Matrix Sync API, the service returns 200 response code for successful request and a response array. The response body will contain the data and there will be no possibility to retrieve the results later.
        ///
        /// ### Download Async Results
        /// When a request issues a `202 Accepted` response, the request is being processed using our async pipeline. You will be given a URL to check the progress of your  async request in the location header of the response. This status URI looks like the following:
        /// ```
        ///   GET https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}
        /// ```
        ///
        /// The URL provided by the location header will return the following responses when a `GET` request is issued.
        ///
        ///   &gt; HTTP `202 Accepted` - Matrix request was accepted but is still being processed. Please try again in some time.
        ///
        ///   &gt; HTTP `200 OK` - Matrix request successfully processed. The response body contains all of the results.
        /// </remarks>
        public async Task<ResponseWithHeaders<RouteGetRouteMatrixHeaders>> GetRouteMatrixAsync(string matrixId, CancellationToken cancellationToken = default)
        {
            if (matrixId == null)
            {
                throw new ArgumentNullException(nameof(matrixId));
            }

            using var message = CreateGetRouteMatrixRequest(matrixId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new RouteGetRouteMatrixHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to get a route matrix showing the travel time and distance for all possible pairs in a list of origins and destinations. </summary>
        /// <param name="matrixId"> Matrix id received after the Matrix Route request was accepted successfully. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="matrixId"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Route Matrix` API is an HTTP `GET` request that computes the travel time and distance for all possible pairs in a list of origins and destinations. Unlike the [Get Route Directions](/rest/api/maps/route/get-route-directions) API, which provide detailed route instructions, this API focuses on efficiency by giving you the cost (travel time and distance) of routing from each origin to every destination.  For more information, see [Best practices for Azure Maps Route service](/azure/azure-maps/how-to-use-best-practices-for-routing).
        ///
        /// For every given origin, the service calculates the cost of routing from that origin to every given destination. The set of origins and the set of destinations can be thought of as the column and row headers of a table and each cell in the table contains the costs of routing from the origin to the destination for that cell. As an example, let's say a food delivery company has 20 drivers and they need to find the closest driver to pick up the delivery from the restaurant. To solve this use case, they can call Matrix Route API.
        ///
        ///
        /// For each route, the travel times and distances are returned. You can use the computed costs to determine which detailed routes to calculate using the Route Directions API.
        ///
        ///
        /// The maximum size of a matrix for async request is **700** and for sync request it's **100** (the number of origins multiplied by the number of destinations).
        ///
        ///
        ///
        /// ### Submit Synchronous Route Matrix Request
        /// If your scenario requires synchronous requests and the maximum size of the matrix is less than or equal to 100, you might want to make synchronous request. The maximum size of a matrix for this API is **100** (the number of origins multiplied by the number of destinations). With that constraint in mind, examples of possible matrix dimensions are: 10x10, 6x8, 9x8 (it does not need to be square).
        ///
        /// ```
        /// GET https://atlas.microsoft.com/route/matrix/sync/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        ///
        /// ### Submit Asynchronous Route Matrix Request
        /// The Asynchronous API is appropriate for processing big volumes of relatively complex routing requests. When you make a request by using async request, by default the service returns a 202 response code along a redirect URL in the Location field of the response header. This URL should be checked periodically until the response data or error information is available. If `waitForResults` parameter in the request is set to true, user will get a 200 response if the request is finished under 120 seconds.
        ///
        ///
        /// The maximum size of a matrix for this API is **700** (the number of origins multiplied by the number of destinations). With that constraint in mind, examples of possible matrix dimensions are: 50x10, 10x10, 28x25. 10x70 (it does not need to be square).
        ///
        ///
        /// The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response if used after the expiration period.
        ///
        ///
        ///
        ///
        /// ```
        /// GET https://atlas.microsoft.com/route/matrix/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        ///
        /// Here's a typical sequence of asynchronous operations:
        /// 1. Client sends a Route Matrix GET request to Azure Maps
        ///
        /// 2. The server will respond with one of the following:
        ///
        ///     &gt; HTTP `202 Accepted` -  Route Matrix request has been accepted.
        ///
        ///     &gt; HTTP `Error` - There was an error processing your Route Matrix request. This could either be a 400 Bad Request or any other Error status code.
        ///
        ///
        /// 3. If the Matrix Route request was accepted successfully, the Location header in the response contains the URL to download the results of the request. This status URI looks like the following:
        ///
        ///   ```
        ///     GET https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}
        ///   ```
        ///
        ///
        /// 4. Client issues a GET request on the download URL obtained in Step 3 to download the results
        ///
        /// ### Download Sync Results
        /// When you make a GET request for Route Matrix Sync API, the service returns 200 response code for successful request and a response array. The response body will contain the data and there will be no possibility to retrieve the results later.
        ///
        /// ### Download Async Results
        /// When a request issues a `202 Accepted` response, the request is being processed using our async pipeline. You will be given a URL to check the progress of your  async request in the location header of the response. This status URI looks like the following:
        /// ```
        ///   GET https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}
        /// ```
        ///
        /// The URL provided by the location header will return the following responses when a `GET` request is issued.
        ///
        ///   &gt; HTTP `202 Accepted` - Matrix request was accepted but is still being processed. Please try again in some time.
        ///
        ///   &gt; HTTP `200 OK` - Matrix request successfully processed. The response body contains all of the results.
        /// </remarks>
        public ResponseWithHeaders<RouteGetRouteMatrixHeaders> GetRouteMatrix(string matrixId, CancellationToken cancellationToken = default)
        {
            if (matrixId == null)
            {
                throw new ArgumentNullException(nameof(matrixId));
            }

            using var message = CreateGetRouteMatrixRequest(matrixId);
            _pipeline.Send(message, cancellationToken);
            var headers = new RouteGetRouteMatrixHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateRequestRouteMatrixSyncRequest(JsonFormat format, RouteMatrixQuery routeMatrixQuery, bool? waitForResults, TravelTimeType? computeTravelTime, IEnumerable<SectionType> filterSectionType, DateTimeOffset? arriveAt, DateTimeOffset? departAt, int? vehicleAxleWeight, double? vehicleLength, double? vehicleHeight, double? vehicleWidth, int? vehicleMaxSpeed, int? vehicleWeight, WindingnessLevel? windingness, InclineLevel? inclineLevel, TravelMode? travelMode, IEnumerable<RouteAvoidType> avoid, bool? useTrafficData, RouteType? routeType, VehicleLoadType? vehicleLoadType)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/route/matrix/sync/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (waitForResults != null)
            {
                uri.AppendQuery("waitForResults", waitForResults.Value, true);
            }
            if (computeTravelTime != null)
            {
                uri.AppendQuery("computeTravelTimeFor", computeTravelTime.Value.ToString(), true);
            }
            if (filterSectionType != null && !(filterSectionType is Common.ChangeTrackingList<SectionType> changeTrackingList && changeTrackingList.IsUndefined))
            {
                foreach (var param in filterSectionType)
                {
                    uri.AppendQuery("sectionType", param.ToString(), true);
                }
            }
            if (arriveAt != null)
            {
                uri.AppendQuery("arriveAt", arriveAt.Value, "O", true);
            }
            if (departAt != null)
            {
                uri.AppendQuery("departAt", departAt.Value, "O", true);
            }
            if (vehicleAxleWeight != null)
            {
                uri.AppendQuery("vehicleAxleWeight", vehicleAxleWeight.Value, true);
            }
            if (vehicleLength != null)
            {
                uri.AppendQuery("vehicleLength", vehicleLength.Value, true);
            }
            if (vehicleHeight != null)
            {
                uri.AppendQuery("vehicleHeight", vehicleHeight.Value, true);
            }
            if (vehicleWidth != null)
            {
                uri.AppendQuery("vehicleWidth", vehicleWidth.Value, true);
            }
            if (vehicleMaxSpeed != null)
            {
                uri.AppendQuery("vehicleMaxSpeed", vehicleMaxSpeed.Value, true);
            }
            if (vehicleWeight != null)
            {
                uri.AppendQuery("vehicleWeight", vehicleWeight.Value, true);
            }
            if (windingness != null)
            {
                uri.AppendQuery("windingness", windingness.Value.ToString(), true);
            }
            if (inclineLevel != null)
            {
                uri.AppendQuery("hilliness", inclineLevel.Value.ToString(), true);
            }
            if (travelMode != null)
            {
                uri.AppendQuery("travelMode", travelMode.Value.ToString(), true);
            }
            if (avoid != null && !(avoid is Common.ChangeTrackingList<RouteAvoidType> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                foreach (var param in avoid)
                {
                    uri.AppendQuery("avoid", param.ToString(), true);
                }
            }
            if (useTrafficData != null)
            {
                uri.AppendQuery("traffic", useTrafficData.Value, true);
            }
            if (routeType != null)
            {
                uri.AppendQuery("routeType", routeType.Value.ToString(), true);
            }
            if (vehicleLoadType != null)
            {
                uri.AppendQuery("vehicleLoadType", vehicleLoadType.Value.ToString(), true);
            }
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(routeMatrixQuery);
            request.Content = content;
            return message;
        }

        /// <summary> Use to get a route matrix showing the travel time and distance for all possible pairs in a list of origins and destinations, using a synchronous request. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="routeMatrixQuery"> The matrix of origin and destination coordinates to compute the route distance, travel time and other summary for each cell of the matrix based on the input parameters. The minimum and the maximum cell count supported are 1 and **700** for async and **100** for sync respectively. For example, it can be 35 origins and 20 destinations or 25 origins and 25 destinations for async API. </param>
        /// <param name="waitForResults"> Boolean to indicate whether to execute the request synchronously. If set to true, user will get a 200 response if the request is finished under 120 seconds. Otherwise, user will get a 202 response right away. Please refer to the API description for more details on 202 response. **Supported only for async request**. </param>
        /// <param name="computeTravelTime"> Specifies whether to return additional travel times using different types of traffic information (none, historic, live) as well as the default best-estimate travel time. </param>
        /// <param name="filterSectionType"> Specifies which of the section types is reported in the route response. &lt;br&gt;&lt;br&gt;For example if sectionType = pedestrian the sections which are suited for pedestrians only are returned. Can be specified multiple times in one request, for example, '&amp;sectionType=carTrain&amp;sectionType=pedestrian&amp;sectionType=motorway'. The default sectionType refers to the travelMode input. By default travelMode is set to car. </param>
        /// <param name="arriveAt">
        /// The date and time of arrival at the destination point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified it will be assumed to be that of the destination point.
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `arriveAt` parameter cannot be used in conjunction with `departAt`, `minDeviationDistance` or `minDeviationTime`.
        /// </param>
        /// <param name="departAt">
        /// The date and time of departure from the origin point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified, it will be assumed to be that of the origin point.
        ///   * Default value: now
        ///   * Other value: `dateTime`
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `departAt` parameter cannot be used in conjunction with `arriveAt`.
        /// </param>
        /// <param name="vehicleAxleWeight"> Weight per axle of the vehicle in kg. A value of 0 means that weight restrictions per axle are not considered. </param>
        /// <param name="vehicleLength"> Length of the vehicle in meters. A value of 0 means that length restrictions are not considered. </param>
        /// <param name="vehicleHeight"> Height of the vehicle in meters. A value of 0 means that height restrictions are not considered. </param>
        /// <param name="vehicleWidth"> Width of the vehicle in meters. A value of 0 means that width restrictions are not considered. </param>
        /// <param name="vehicleMaxSpeed">
        /// Maximum speed of the vehicle in km/hour. The max speed in the vehicle profile is used to check whether a vehicle is allowed on motorways.
        ///
        /// * A value of 0 means that an appropriate value for the vehicle will be determined and applied during route planning.
        ///
        /// * A non-zero value may be overridden during route planning. For example, the current traffic flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will again use 60 km/hour.
        /// </param>
        /// <param name="vehicleWeight"> Weight of the vehicle in kilograms. </param>
        /// <param name="windingness"> Level of turns for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="inclineLevel"> Degree of hilliness for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="travelMode"> The mode of travel for the requested route. If not defined, default is 'car'. Note that the requested travelMode may not be available for the entire route. Where the requested travelMode is not available for a particular section, the travelMode element of the response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van are BETA functionality. Full restriction data is not available in all areas. </param>
        /// <param name="avoid"> Specifies something that the route calculation should try to avoid when determining the route. Can be specified multiple times in one request, for example, '&amp;avoid=motorways&amp;avoid=tollRoads&amp;avoid=ferries'. In Route Range requests, the value alreadyUsedRoads must not be used. </param>
        /// <param name="useTrafficData">
        /// Possible values:
        ///   * true - Do consider all available traffic information during routing
        ///   * false - Ignore current traffic data during routing. Note that although the current traffic data is ignored
        ///   during routing, the effect of historic traffic on effective road speeds is still incorporated.
        /// </param>
        /// <param name="routeType"> The type of route requested. </param>
        /// <param name="vehicleLoadType"> Types of cargo that may be classified as hazardous materials and restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9, plus generic classifications for use in other countries/regions. Values beginning with USHazmat are for US routing while otherHazmat should be used for all other countries/regions. vehicleLoadType can be specified multiple times. This parameter is currently only considered for travelMode=truck. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="routeMatrixQuery"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Post Route Matrix Sync` API is an HTTP `POST` request that allows calculation of a matrix of route summaries for a set of routes defined by origin and destination locations by using a single synchronous (sync) request. To make an asynchronous (async) request, see [Post Route Matrix](/rest/api/maps/route/post-route-matrix). For every given origin, the service calculates the cost of routing from that origin to every given destination. The set of origins and the set of destinations can be thought of as the column and row headers of a table and each cell in the table contains the costs of routing from the origin to the destination for that cell. As an example, let's say a food delivery company has 20 drivers and they need to find the closest driver to pick up the delivery from the restaurant. To solve this use case, they can call Matrix Route API.
        ///
        ///
        /// For each route, the travel times and distances are returned. You can use the computed costs to determine which detailed routes to calculate using the Route Directions API.
        ///
        ///
        /// The maximum size of a matrix for async request is **700** and for sync request it's **100** (the number of origins multiplied by the number of destinations).
        ///
        ///
        ///
        /// ### Submit Synchronous Route Matrix Request
        /// If your scenario requires synchronous requests and the maximum size of the matrix is less than or equal to 100, you might want to make synchronous request. The maximum size of a matrix for this API is **100** (the number of origins multiplied by the number of destinations). With that constraint in mind, examples of possible matrix dimensions are: 10x10, 6x8, 9x8 (it does not need to be square).
        ///
        /// ```
        /// POST https://atlas.microsoft.com/route/matrix/sync/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        ///
        /// ### Submit Asynchronous Route Matrix Request
        /// The Asynchronous API is appropriate for processing big volumes of relatively complex routing requests. When you make a request by using async request, by default the service returns a 202 response code along a redirect URL in the Location field of the response header. This URL should be checked periodically until the response data or error information is available. If `waitForResults` parameter in the request is set to true, user will get a 200 response if the request is finished under 120 seconds.
        ///
        ///
        /// The maximum size of a matrix for this API is **700** (the number of origins multiplied by the number of destinations). With that constraint in mind, examples of possible matrix dimensions are: 50x10, 10x10, 28x25. 10x70 (it does not need to be square).
        ///
        ///
        /// The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response if used after the expiration period.
        ///
        ///
        ///
        ///
        /// ```
        /// POST https://atlas.microsoft.com/route/matrix/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        ///
        /// Here's a typical sequence of asynchronous operations:
        /// 1. Client sends a Route Matrix POST request to Azure Maps
        ///
        /// 2. The server will respond with one of the following:
        ///
        ///     &gt; HTTP `202 Accepted` -  Route Matrix request has been accepted.
        ///
        ///     &gt; HTTP `Error` - There was an error processing your Route Matrix request. This could either be a 400 Bad Request or any other Error status code.
        ///
        ///
        /// 3. If the Matrix Route request was accepted successfully, the Location header in the response contains the URL to download the results of the request. This status URI looks like the following:
        ///
        ///   ```
        ///     GET https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}
        ///   ```
        ///
        ///
        /// 4. Client issues a GET request on the download URL obtained in Step 3 to download the results
        ///
        /// ### Download Sync Results
        /// When you make a POST request for Route Matrix Sync API, the service returns 200 response code for successful request and a response array. The response body will contain the data and there will be no possibility to retrieve the results later.
        ///
        /// ### Download Async Results
        /// When a request issues a `202 Accepted` response, the request is being processed using our async pipeline. You will be given a URL to check the progress of your  async request in the location header of the response. This status URI looks like the following:
        /// ```
        ///   GET https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}
        /// ```
        ///
        /// The URL provided by the location header will return the following responses when a `GET` request is issued.
        ///
        ///   &gt; HTTP `202 Accepted` - Matrix request was accepted but is still being processed. Please try again in some time.
        ///
        ///   &gt; HTTP `200 OK` - Matrix request successfully processed. The response body contains all of the results.
        /// </remarks>
        public async Task<Response<RouteMatrixResult>> RequestRouteMatrixSyncAsync(JsonFormat format, RouteMatrixQuery routeMatrixQuery, bool? waitForResults = null, TravelTimeType? computeTravelTime = null, IEnumerable<SectionType> filterSectionType = null, DateTimeOffset? arriveAt = null, DateTimeOffset? departAt = null, int? vehicleAxleWeight = null, double? vehicleLength = null, double? vehicleHeight = null, double? vehicleWidth = null, int? vehicleMaxSpeed = null, int? vehicleWeight = null, WindingnessLevel? windingness = null, InclineLevel? inclineLevel = null, TravelMode? travelMode = null, IEnumerable<RouteAvoidType> avoid = null, bool? useTrafficData = null, RouteType? routeType = null, VehicleLoadType? vehicleLoadType = null, CancellationToken cancellationToken = default)
        {
            if (routeMatrixQuery == null)
            {
                throw new ArgumentNullException(nameof(routeMatrixQuery));
            }

            using var message = CreateRequestRouteMatrixSyncRequest(format, routeMatrixQuery, waitForResults, computeTravelTime, filterSectionType, arriveAt, departAt, vehicleAxleWeight, vehicleLength, vehicleHeight, vehicleWidth, vehicleMaxSpeed, vehicleWeight, windingness, inclineLevel, travelMode, avoid, useTrafficData, routeType, vehicleLoadType);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RouteMatrixResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RouteMatrixResult.DeserializeRouteMatrixResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to get a route matrix showing the travel time and distance for all possible pairs in a list of origins and destinations, using a synchronous request. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="routeMatrixQuery"> The matrix of origin and destination coordinates to compute the route distance, travel time and other summary for each cell of the matrix based on the input parameters. The minimum and the maximum cell count supported are 1 and **700** for async and **100** for sync respectively. For example, it can be 35 origins and 20 destinations or 25 origins and 25 destinations for async API. </param>
        /// <param name="waitForResults"> Boolean to indicate whether to execute the request synchronously. If set to true, user will get a 200 response if the request is finished under 120 seconds. Otherwise, user will get a 202 response right away. Please refer to the API description for more details on 202 response. **Supported only for async request**. </param>
        /// <param name="computeTravelTime"> Specifies whether to return additional travel times using different types of traffic information (none, historic, live) as well as the default best-estimate travel time. </param>
        /// <param name="filterSectionType"> Specifies which of the section types is reported in the route response. &lt;br&gt;&lt;br&gt;For example if sectionType = pedestrian the sections which are suited for pedestrians only are returned. Can be specified multiple times in one request, for example, '&amp;sectionType=carTrain&amp;sectionType=pedestrian&amp;sectionType=motorway'. The default sectionType refers to the travelMode input. By default travelMode is set to car. </param>
        /// <param name="arriveAt">
        /// The date and time of arrival at the destination point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified it will be assumed to be that of the destination point.
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `arriveAt` parameter cannot be used in conjunction with `departAt`, `minDeviationDistance` or `minDeviationTime`.
        /// </param>
        /// <param name="departAt">
        /// The date and time of departure from the origin point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified, it will be assumed to be that of the origin point.
        ///   * Default value: now
        ///   * Other value: `dateTime`
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `departAt` parameter cannot be used in conjunction with `arriveAt`.
        /// </param>
        /// <param name="vehicleAxleWeight"> Weight per axle of the vehicle in kg. A value of 0 means that weight restrictions per axle are not considered. </param>
        /// <param name="vehicleLength"> Length of the vehicle in meters. A value of 0 means that length restrictions are not considered. </param>
        /// <param name="vehicleHeight"> Height of the vehicle in meters. A value of 0 means that height restrictions are not considered. </param>
        /// <param name="vehicleWidth"> Width of the vehicle in meters. A value of 0 means that width restrictions are not considered. </param>
        /// <param name="vehicleMaxSpeed">
        /// Maximum speed of the vehicle in km/hour. The max speed in the vehicle profile is used to check whether a vehicle is allowed on motorways.
        ///
        /// * A value of 0 means that an appropriate value for the vehicle will be determined and applied during route planning.
        ///
        /// * A non-zero value may be overridden during route planning. For example, the current traffic flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will again use 60 km/hour.
        /// </param>
        /// <param name="vehicleWeight"> Weight of the vehicle in kilograms. </param>
        /// <param name="windingness"> Level of turns for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="inclineLevel"> Degree of hilliness for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="travelMode"> The mode of travel for the requested route. If not defined, default is 'car'. Note that the requested travelMode may not be available for the entire route. Where the requested travelMode is not available for a particular section, the travelMode element of the response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van are BETA functionality. Full restriction data is not available in all areas. </param>
        /// <param name="avoid"> Specifies something that the route calculation should try to avoid when determining the route. Can be specified multiple times in one request, for example, '&amp;avoid=motorways&amp;avoid=tollRoads&amp;avoid=ferries'. In Route Range requests, the value alreadyUsedRoads must not be used. </param>
        /// <param name="useTrafficData">
        /// Possible values:
        ///   * true - Do consider all available traffic information during routing
        ///   * false - Ignore current traffic data during routing. Note that although the current traffic data is ignored
        ///   during routing, the effect of historic traffic on effective road speeds is still incorporated.
        /// </param>
        /// <param name="routeType"> The type of route requested. </param>
        /// <param name="vehicleLoadType"> Types of cargo that may be classified as hazardous materials and restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9, plus generic classifications for use in other countries/regions. Values beginning with USHazmat are for US routing while otherHazmat should be used for all other countries/regions. vehicleLoadType can be specified multiple times. This parameter is currently only considered for travelMode=truck. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="routeMatrixQuery"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Post Route Matrix Sync` API is an HTTP `POST` request that allows calculation of a matrix of route summaries for a set of routes defined by origin and destination locations by using a single synchronous (sync) request. To make an asynchronous (async) request, see [Post Route Matrix](/rest/api/maps/route/post-route-matrix). For every given origin, the service calculates the cost of routing from that origin to every given destination. The set of origins and the set of destinations can be thought of as the column and row headers of a table and each cell in the table contains the costs of routing from the origin to the destination for that cell. As an example, let's say a food delivery company has 20 drivers and they need to find the closest driver to pick up the delivery from the restaurant. To solve this use case, they can call Matrix Route API.
        ///
        ///
        /// For each route, the travel times and distances are returned. You can use the computed costs to determine which detailed routes to calculate using the Route Directions API.
        ///
        ///
        /// The maximum size of a matrix for async request is **700** and for sync request it's **100** (the number of origins multiplied by the number of destinations).
        ///
        ///
        ///
        /// ### Submit Synchronous Route Matrix Request
        /// If your scenario requires synchronous requests and the maximum size of the matrix is less than or equal to 100, you might want to make synchronous request. The maximum size of a matrix for this API is **100** (the number of origins multiplied by the number of destinations). With that constraint in mind, examples of possible matrix dimensions are: 10x10, 6x8, 9x8 (it does not need to be square).
        ///
        /// ```
        /// POST https://atlas.microsoft.com/route/matrix/sync/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        ///
        /// ### Submit Asynchronous Route Matrix Request
        /// The Asynchronous API is appropriate for processing big volumes of relatively complex routing requests. When you make a request by using async request, by default the service returns a 202 response code along a redirect URL in the Location field of the response header. This URL should be checked periodically until the response data or error information is available. If `waitForResults` parameter in the request is set to true, user will get a 200 response if the request is finished under 120 seconds.
        ///
        ///
        /// The maximum size of a matrix for this API is **700** (the number of origins multiplied by the number of destinations). With that constraint in mind, examples of possible matrix dimensions are: 50x10, 10x10, 28x25. 10x70 (it does not need to be square).
        ///
        ///
        /// The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response if used after the expiration period.
        ///
        ///
        ///
        ///
        /// ```
        /// POST https://atlas.microsoft.com/route/matrix/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        ///
        /// Here's a typical sequence of asynchronous operations:
        /// 1. Client sends a Route Matrix POST request to Azure Maps
        ///
        /// 2. The server will respond with one of the following:
        ///
        ///     &gt; HTTP `202 Accepted` -  Route Matrix request has been accepted.
        ///
        ///     &gt; HTTP `Error` - There was an error processing your Route Matrix request. This could either be a 400 Bad Request or any other Error status code.
        ///
        ///
        /// 3. If the Matrix Route request was accepted successfully, the Location header in the response contains the URL to download the results of the request. This status URI looks like the following:
        ///
        ///   ```
        ///     GET https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}
        ///   ```
        ///
        ///
        /// 4. Client issues a GET request on the download URL obtained in Step 3 to download the results
        ///
        /// ### Download Sync Results
        /// When you make a POST request for Route Matrix Sync API, the service returns 200 response code for successful request and a response array. The response body will contain the data and there will be no possibility to retrieve the results later.
        ///
        /// ### Download Async Results
        /// When a request issues a `202 Accepted` response, the request is being processed using our async pipeline. You will be given a URL to check the progress of your  async request in the location header of the response. This status URI looks like the following:
        /// ```
        ///   GET https://atlas.microsoft.com/route/matrix/{matrixId}?api-version=1.0?subscription-key={subscription-key}
        /// ```
        ///
        /// The URL provided by the location header will return the following responses when a `GET` request is issued.
        ///
        ///   &gt; HTTP `202 Accepted` - Matrix request was accepted but is still being processed. Please try again in some time.
        ///
        ///   &gt; HTTP `200 OK` - Matrix request successfully processed. The response body contains all of the results.
        /// </remarks>
        public Response<RouteMatrixResult> RequestRouteMatrixSync(JsonFormat format, RouteMatrixQuery routeMatrixQuery, bool? waitForResults = null, TravelTimeType? computeTravelTime = null, IEnumerable<SectionType> filterSectionType = null, DateTimeOffset? arriveAt = null, DateTimeOffset? departAt = null, int? vehicleAxleWeight = null, double? vehicleLength = null, double? vehicleHeight = null, double? vehicleWidth = null, int? vehicleMaxSpeed = null, int? vehicleWeight = null, WindingnessLevel? windingness = null, InclineLevel? inclineLevel = null, TravelMode? travelMode = null, IEnumerable<RouteAvoidType> avoid = null, bool? useTrafficData = null, RouteType? routeType = null, VehicleLoadType? vehicleLoadType = null, CancellationToken cancellationToken = default)
        {
            if (routeMatrixQuery == null)
            {
                throw new ArgumentNullException(nameof(routeMatrixQuery));
            }

            using var message = CreateRequestRouteMatrixSyncRequest(format, routeMatrixQuery, waitForResults, computeTravelTime, filterSectionType, arriveAt, departAt, vehicleAxleWeight, vehicleLength, vehicleHeight, vehicleWidth, vehicleMaxSpeed, vehicleWeight, windingness, inclineLevel, travelMode, avoid, useTrafficData, routeType, vehicleLoadType);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RouteMatrixResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RouteMatrixResult.DeserializeRouteMatrixResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetRouteDirectionsRequest(ResponseFormat format, string routePoints, int? maxAlternatives, AlternativeRouteType? alternativeType, int? minDeviationDistance, DateTimeOffset? arriveAt, DateTimeOffset? departAt, int? minDeviationTime, RouteInstructionsType? instructionsType, string language, bool? computeBestWaypointOrder, RouteRepresentationForBestOrder? routeRepresentationForBestOrder, TravelTimeType? computeTravelTime, int? vehicleHeading, Report? report, IEnumerable<SectionType> filterSectionType, int? vehicleAxleWeight, double? vehicleWidth, double? vehicleHeight, double? vehicleLength, int? vehicleMaxSpeed, int? vehicleWeight, bool? isCommercialVehicle, WindingnessLevel? windingness, InclineLevel? inclineLevel, TravelMode? travelMode, IEnumerable<RouteAvoidType> avoid, bool? useTrafficData, RouteType? routeType, VehicleLoadType? vehicleLoadType, VehicleEngineType? vehicleEngineType, string constantSpeedConsumptionInLitersPerHundredKm, double? currentFuelInLiters, double? auxiliaryPowerInLitersPerHour, double? fuelEnergyDensityInMegajoulesPerLiter, double? accelerationEfficiency, double? decelerationEfficiency, double? uphillEfficiency, double? downhillEfficiency, string constantSpeedConsumptionInKwHPerHundredKm, double? currentChargeInKwH, double? maxChargeInKwH, double? auxiliaryPowerInKw)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/route/directions/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            uri.AppendQuery("query", routePoints, true);
            if (maxAlternatives != null)
            {
                uri.AppendQuery("maxAlternatives", maxAlternatives.Value, true);
            }
            if (alternativeType != null)
            {
                uri.AppendQuery("alternativeType", alternativeType.Value.ToString(), true);
            }
            if (minDeviationDistance != null)
            {
                uri.AppendQuery("minDeviationDistance", minDeviationDistance.Value, true);
            }
            if (arriveAt != null)
            {
                uri.AppendQuery("arriveAt", arriveAt.Value, "O", true);
            }
            if (departAt != null)
            {
                uri.AppendQuery("departAt", departAt.Value, "O", true);
            }
            if (minDeviationTime != null)
            {
                uri.AppendQuery("minDeviationTime", minDeviationTime.Value, true);
            }
            if (instructionsType != null)
            {
                uri.AppendQuery("instructionsType", instructionsType.Value.ToString(), true);
            }
            if (language != null)
            {
                uri.AppendQuery("language", language, true);
            }
            if (computeBestWaypointOrder != null)
            {
                uri.AppendQuery("computeBestOrder", computeBestWaypointOrder.Value, true);
            }
            if (routeRepresentationForBestOrder != null)
            {
                uri.AppendQuery("routeRepresentation", routeRepresentationForBestOrder.Value.ToString(), true);
            }
            if (computeTravelTime != null)
            {
                uri.AppendQuery("computeTravelTimeFor", computeTravelTime.Value.ToString(), true);
            }
            if (vehicleHeading != null)
            {
                uri.AppendQuery("vehicleHeading", vehicleHeading.Value, true);
            }
            if (report != null)
            {
                uri.AppendQuery("report", report.Value.ToString(), true);
            }
            if (filterSectionType != null && !(filterSectionType is Common.ChangeTrackingList<SectionType> changeTrackingList && changeTrackingList.IsUndefined))
            {
                foreach (var param in filterSectionType)
                {
                    uri.AppendQuery("sectionType", param.ToString(), true);
                }
            }
            if (vehicleAxleWeight != null)
            {
                uri.AppendQuery("vehicleAxleWeight", vehicleAxleWeight.Value, true);
            }
            if (vehicleWidth != null)
            {
                uri.AppendQuery("vehicleWidth", vehicleWidth.Value, true);
            }
            if (vehicleHeight != null)
            {
                uri.AppendQuery("vehicleHeight", vehicleHeight.Value, true);
            }
            if (vehicleLength != null)
            {
                uri.AppendQuery("vehicleLength", vehicleLength.Value, true);
            }
            if (vehicleMaxSpeed != null)
            {
                uri.AppendQuery("vehicleMaxSpeed", vehicleMaxSpeed.Value, true);
            }
            if (vehicleWeight != null)
            {
                uri.AppendQuery("vehicleWeight", vehicleWeight.Value, true);
            }
            if (isCommercialVehicle != null)
            {
                uri.AppendQuery("vehicleCommercial", isCommercialVehicle.Value, true);
            }
            if (windingness != null)
            {
                uri.AppendQuery("windingness", windingness.Value.ToString(), true);
            }
            if (inclineLevel != null)
            {
                uri.AppendQuery("hilliness", inclineLevel.Value.ToString(), true);
            }
            if (travelMode != null)
            {
                uri.AppendQuery("travelMode", travelMode.Value.ToString(), true);
            }
            if (avoid != null && !(avoid is Common.ChangeTrackingList<RouteAvoidType> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                foreach (var param in avoid)
                {
                    uri.AppendQuery("avoid", param.ToString(), true);
                }
            }
            if (useTrafficData != null)
            {
                uri.AppendQuery("traffic", useTrafficData.Value, true);
            }
            if (routeType != null)
            {
                uri.AppendQuery("routeType", routeType.Value.ToString(), true);
            }
            if (vehicleLoadType != null)
            {
                uri.AppendQuery("vehicleLoadType", vehicleLoadType.Value.ToString(), true);
            }
            if (vehicleEngineType != null)
            {
                uri.AppendQuery("vehicleEngineType", vehicleEngineType.Value.ToString(), true);
            }
            if (constantSpeedConsumptionInLitersPerHundredKm != null)
            {
                uri.AppendQuery("constantSpeedConsumptionInLitersPerHundredkm", constantSpeedConsumptionInLitersPerHundredKm, true);
            }
            if (currentFuelInLiters != null)
            {
                uri.AppendQuery("currentFuelInLiters", currentFuelInLiters.Value, true);
            }
            if (auxiliaryPowerInLitersPerHour != null)
            {
                uri.AppendQuery("auxiliaryPowerInLitersPerHour", auxiliaryPowerInLitersPerHour.Value, true);
            }
            if (fuelEnergyDensityInMegajoulesPerLiter != null)
            {
                uri.AppendQuery("fuelEnergyDensityInMJoulesPerLiter", fuelEnergyDensityInMegajoulesPerLiter.Value, true);
            }
            if (accelerationEfficiency != null)
            {
                uri.AppendQuery("accelerationEfficiency", accelerationEfficiency.Value, true);
            }
            if (decelerationEfficiency != null)
            {
                uri.AppendQuery("decelerationEfficiency", decelerationEfficiency.Value, true);
            }
            if (uphillEfficiency != null)
            {
                uri.AppendQuery("uphillEfficiency", uphillEfficiency.Value, true);
            }
            if (downhillEfficiency != null)
            {
                uri.AppendQuery("downhillEfficiency", downhillEfficiency.Value, true);
            }
            if (constantSpeedConsumptionInKwHPerHundredKm != null)
            {
                uri.AppendQuery("constantSpeedConsumptionInkWhPerHundredkm", constantSpeedConsumptionInKwHPerHundredKm, true);
            }
            if (currentChargeInKwH != null)
            {
                uri.AppendQuery("currentChargeInkWh", currentChargeInKwH.Value, true);
            }
            if (maxChargeInKwH != null)
            {
                uri.AppendQuery("maxChargeInkWh", maxChargeInKwH.Value, true);
            }
            if (auxiliaryPowerInKw != null)
            {
                uri.AppendQuery("auxiliaryPowerInkW", auxiliaryPowerInKw.Value, true);
            }
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Use to calculate a route between a specified origin and destination, passing through any specified waypoints. </summary>
        /// <param name="format"> Desired format of the response. Value can be either _json_ or _xml_. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="routePoints"> The Coordinates through which the route is calculated, delimited by a colon.  A minimum of two coordinates is required.  The first one is the origin and the last is the destination of the route. Optional coordinates in-between act as WayPoints in the route.  You can pass up to 150 WayPoints. </param>
        /// <param name="maxAlternatives"> Number of desired alternative routes to be calculated. Default: 0, minimum: 0 and maximum: 5. </param>
        /// <param name="alternativeType"> Controls the optimality, with respect to the given planning criteria, of the calculated alternatives compared to the reference route. </param>
        /// <param name="minDeviationDistance"> All alternative routes returned will follow the reference route (see section POST Requests) from the origin point of the calculateRoute request for at least this number of meters. Can only be used when reconstructing a route. The minDeviationDistance parameter cannot be used in conjunction with arriveAt. </param>
        /// <param name="arriveAt">
        /// The date and time of arrival at the destination point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified it will be assumed to be that of the destination point.
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `arriveAt` parameter cannot be used in conjunction with `departAt`, `minDeviationDistance` or `minDeviationTime`.
        /// </param>
        /// <param name="departAt">
        /// The date and time of departure from the origin point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified, it will be assumed to be that of the origin point.
        ///   * Default value: now
        ///   * Other value: `dateTime`
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `departAt` parameter cannot be used in conjunction with `arriveAt`.
        /// </param>
        /// <param name="minDeviationTime">
        /// All alternative routes returned will follow the reference route (see section POST Requests) from the origin point of the calculateRoute request for at least this number of seconds. Can only be used when reconstructing a route. The minDeviationTime parameter cannot be used in conjunction with arriveAt. Default value is 0. Setting )minDeviationTime_ to a value greater than zero has the following consequences:
        ///   - The origin point of the _calculateRoute_ Request must be on
        ///     (or very near) the input reference route.
        ///     - If this is not the case, an error is returned.
        ///     - However, the origin point does not need to be at the beginning
        ///       of the input reference route (it can be thought of as the current
        ///       vehicle position on the reference route).
        ///   - The reference route, returned as the first route in the _calculateRoute_
        ///     Response, will start at the origin point specified in the _calculateRoute_
        ///     Request. The initial part of the input reference route up until the origin
        ///     point will be excluded from the Response.
        ///   - The values of _minDeviationDistance_ and _minDeviationTime_ determine
        ///     how far alternative routes will be guaranteed to follow the reference
        ///     route from the origin point onwards.
        ///   - The route must use _departAt_.
        ///   - The _vehicleHeading_ is ignored.
        /// </param>
        /// <param name="instructionsType"> If specified, guidance instructions will be returned. Note that the instructionsType parameter cannot be used in conjunction with routeRepresentation=none. </param>
        /// <param name="language">
        /// The language parameter determines the language of the guidance messages. Proper nouns (the names of streets, plazas, etc.) are returned in the specified  language, or if that is not available, they are returned in an available language  that is close to it. Allowed values are (a subset of) the IETF language tags. The currently supported  languages are listed in the [Supported languages  section](https://docs.microsoft.com/azure/azure-maps/supported-languages).
        ///
        /// Default value: en-GB
        /// </param>
        /// <param name="computeBestWaypointOrder"> Re-order the route waypoints using a fast heuristic algorithm to reduce the route length. Yields best results when used in conjunction with routeType _shortest_. Notice that origin and destination are excluded from the optimized waypoint indices. To include origin and destination in the response, please increase all the indices by 1 to account for the origin, and then add the destination as the final index. Possible values are true or false. True computes a better order if possible, but is not allowed to be used in conjunction with maxAlternatives value greater than 0 or in conjunction with circle waypoints. False will use the locations in the given order and not allowed to be used in conjunction with routeRepresentation _none_. </param>
        /// <param name="routeRepresentationForBestOrder"> Specifies the representation of the set of routes provided as response. This parameter value can only be used in conjunction with computeBestOrder=true. </param>
        /// <param name="computeTravelTime"> Specifies whether to return additional travel times using different types of traffic information (none, historic, live) as well as the default best-estimate travel time. </param>
        /// <param name="vehicleHeading"> The directional heading of the vehicle in degrees starting at true North and continuing in clockwise direction. North is 0 degrees, east is 90 degrees, south is 180 degrees, west is 270 degrees. Possible values 0-359. </param>
        /// <param name="report"> Specifies which data should be reported for diagnosis purposes. The only possible value is _effectiveSettings_. Reports the effective parameters or data used when calling the API. In the case of defaulted parameters the default will be reflected where the parameter was not specified by the caller. </param>
        /// <param name="filterSectionType"> Specifies which of the section types is reported in the route response. &lt;br&gt;&lt;br&gt;For example if sectionType = pedestrian the sections which are suited for pedestrians only are returned. Can be specified multiple times in one request, for example, '&amp;sectionType=carTrain&amp;sectionType=pedestrian&amp;sectionType=motorway'. The default sectionType refers to the travelMode input. By default travelMode is set to car. </param>
        /// <param name="vehicleAxleWeight"> Weight per axle of the vehicle in kg. A value of 0 means that weight restrictions per axle are not considered. </param>
        /// <param name="vehicleWidth"> Width of the vehicle in meters. A value of 0 means that width restrictions are not considered. </param>
        /// <param name="vehicleHeight"> Height of the vehicle in meters. A value of 0 means that height restrictions are not considered. </param>
        /// <param name="vehicleLength"> Length of the vehicle in meters. A value of 0 means that length restrictions are not considered. </param>
        /// <param name="vehicleMaxSpeed">
        /// Maximum speed of the vehicle in km/hour. The max speed in the vehicle profile is used to check whether a vehicle is allowed on motorways.
        ///
        /// * A value of 0 means that an appropriate value for the vehicle will be determined and applied during route planning.
        ///
        /// * A non-zero value may be overridden during route planning. For example, the current traffic flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will again use 60 km/hour.
        /// </param>
        /// <param name="vehicleWeight">
        /// Weight of the vehicle in kilograms.
        ///
        /// * It is mandatory if any of the *Efficiency parameters are set.
        ///
        /// * It must be strictly positive when used in the context of the Consumption Model. Weight restrictions are considered.
        ///
        /// * If no detailed **Consumption Model** is specified and the value of **vehicleWeight** is non-zero, then weight restrictions are considered.
        ///
        /// * In all other cases, this parameter is ignored.
        ///
        /// Sensible Values : for **Combustion Model** : 1600, for **Electric Model** : 1900
        /// </param>
        /// <param name="isCommercialVehicle"> Whether the vehicle is used for commercial purposes. Commercial vehicles may not be allowed to drive on some roads. </param>
        /// <param name="windingness"> Level of turns for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="inclineLevel"> Degree of hilliness for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="travelMode"> The mode of travel for the requested route. If not defined, default is 'car'. Note that the requested travelMode may not be available for the entire route. Where the requested travelMode is not available for a particular section, the travelMode element of the response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van are BETA functionality. Full restriction data is not available in all areas. </param>
        /// <param name="avoid"> Specifies something that the route calculation should try to avoid when determining the route. Can be specified multiple times in one request, for example, '&amp;avoid=motorways&amp;avoid=tollRoads&amp;avoid=ferries'. In Route Range requests, the value alreadyUsedRoads must not be used. </param>
        /// <param name="useTrafficData">
        /// Possible values:
        ///   * true - Do consider all available traffic information during routing
        ///   * false - Ignore current traffic data during routing. Note that although the current traffic data is ignored
        ///   during routing, the effect of historic traffic on effective road speeds is still incorporated.
        /// </param>
        /// <param name="routeType"> The type of route requested. </param>
        /// <param name="vehicleLoadType"> Types of cargo that may be classified as hazardous materials and restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9, plus generic classifications for use in other countries/regions. Values beginning with USHazmat are for US routing while otherHazmat should be used for all other countries/regions. vehicleLoadType can be specified multiple times. This parameter is currently only considered for travelMode=truck. </param>
        /// <param name="vehicleEngineType"> Engine type of the vehicle. When a detailed Consumption Model is specified, it must be consistent with the value of **vehicleEngineType**. </param>
        /// <param name="constantSpeedConsumptionInLitersPerHundredKm">
        ///
        /// Specifies the speed-dependent component of consumption.
        ///
        /// Provided as an unordered list of colon-delimited speed &amp; consumption-rate pairs. The list defines points on a consumption curve. Consumption rates for speeds not in the list are found as follows:
        ///
        ///  * by linear interpolation, if the given speed lies in between two speeds in the list
        ///
        ///  * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by the nearest two points in the list
        ///
        /// The list must contain between 1 and 25 points (inclusive), and may not contain duplicate points for the same speed. If it only contains a single point, then the consumption rate of that point is used without further processing.
        ///
        /// Consumption specified for the largest speed must be greater than or equal to that of the penultimate largest speed. This ensures that extrapolation does not lead to negative consumption rates.
        ///
        /// Similarly, consumption values specified for the two smallest speeds in the list cannot lead to a negative consumption rate for any smaller speed.
        ///
        /// The valid range for the consumption values(expressed in l/100km) is between 0.01 and 100000.0.
        ///
        /// Sensible Values : 50,6.3:130,11.5
        ///
        /// **Note** : This parameter is required for **The Combustion Consumption Model**.
        /// </param>
        /// <param name="currentFuelInLiters">
        /// Specifies the current supply of fuel in liters.
        ///
        /// Sensible Values : 55
        /// </param>
        /// <param name="auxiliaryPowerInLitersPerHour">
        /// Specifies the amount of fuel consumed for sustaining auxiliary systems of the vehicle, in liters per hour.
        ///
        /// It can be used to specify consumption due to devices and systems such as AC systems, radio, heating, etc.
        ///
        /// Sensible Values : 0.2
        /// </param>
        /// <param name="fuelEnergyDensityInMegajoulesPerLiter">
        /// Specifies the amount of chemical energy stored in one liter of fuel in megajoules (MJ). It is used in conjunction with the ***Efficiency** parameters for conversions between saved or consumed energy and fuel. For example, energy density is 34.2 MJ/l for gasoline, and 35.8 MJ/l for Diesel fuel.
        ///
        /// This parameter is required if any ***Efficiency** parameter is set.
        ///
        /// Sensible Values : 34.2
        /// </param>
        /// <param name="accelerationEfficiency">
        /// Specifies the efficiency of converting chemical energy stored in fuel to kinetic energy when the vehicle accelerates _(i.e. KineticEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed_ is obtained by converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **decelerationEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**decelerationEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.33, for **Electric Model** : 0.66
        /// </param>
        /// <param name="decelerationEfficiency">
        /// Specifies the efficiency of converting kinetic energy to saved (not consumed) fuel when the vehicle decelerates _(i.e. ChemicalEnergySaved/KineticEnergyLost). ChemicalEnergySaved_ is obtained by converting saved (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **accelerationEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**accelerationEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.83, for **Electric Model** : 0.91
        /// </param>
        /// <param name="uphillEfficiency">
        /// Specifies the efficiency of converting chemical energy stored in fuel to potential energy when the vehicle gains elevation _(i.e. PotentialEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed_ is obtained by converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **downhillEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**downhillEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.27, for **Electric Model** : 0.74
        /// </param>
        /// <param name="downhillEfficiency">
        /// Specifies the efficiency of converting potential energy to saved (not consumed) fuel when the vehicle loses elevation _(i.e. ChemicalEnergySaved/PotentialEnergyLost). ChemicalEnergySaved_ is obtained by converting saved (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **uphillEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**uphillEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.51, for **Electric Model** : 0.73
        /// </param>
        /// <param name="constantSpeedConsumptionInKwHPerHundredKm">
        /// Specifies the speed-dependent component of consumption.
        ///
        /// Provided as an unordered list of speed/consumption-rate pairs. The list defines points on a consumption curve. Consumption rates for speeds not in the list are found as follows:
        ///
        /// * by linear interpolation, if the given speed lies in between two speeds in the list
        ///
        /// * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by the nearest two points in the list
        ///
        /// The list must contain between 1 and 25 points (inclusive), and may not contain duplicate points for the same speed. If it only contains a single point, then the consumption rate of that point is used without further processing.
        ///
        /// Consumption specified for the largest speed must be greater than or equal to that of the penultimate largest speed. This ensures that extrapolation does not lead to negative consumption rates.
        ///
        /// Similarly, consumption values specified for the two smallest speeds in the list cannot lead to a negative consumption rate for any smaller  speed.
        ///
        /// The valid range for the consumption values(expressed in kWh/100km) is between 0.01 and 100000.0.
        ///
        /// Sensible Values : 50,8.2:130,21.3
        ///
        /// This parameter is required for **Electric consumption model**.
        /// </param>
        /// <param name="currentChargeInKwH">
        /// Specifies the current electric energy supply in kilowatt hours (kWh).
        ///
        /// This parameter co-exists with **maxChargeInkWh** parameter.
        ///
        /// The range of values allowed are 0.0 to **maxChargeInkWh**.
        ///
        /// Sensible Values : 43
        /// </param>
        /// <param name="maxChargeInKwH">
        /// Specifies the maximum electric energy supply in kilowatt hours (kWh) that may be stored in the vehicle's battery.
        ///
        /// This parameter co-exists with **currentChargeInkWh** parameter.
        ///
        /// Minimum value has to be greater than or equal to **currentChargeInkWh**.
        ///
        /// Sensible Values : 85
        /// </param>
        /// <param name="auxiliaryPowerInKw">
        /// Specifies the amount of power consumed for sustaining auxiliary systems, in kilowatts (kW).
        ///
        /// It can be used to specify consumption due to devices and systems such as AC systems, radio, heating, etc.
        ///
        /// Sensible Values : 1.7
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="routePoints"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Route Directions` API is an HTTP `GET` request that returns a route between an origin and a destination, passing through waypoints if specified. The route takes into account factors such as current traffic and the typical road speeds on the requested day of the week and time of day.
        ///
        /// Information returned includes the distance, estimated travel time, and a representation of the route geometry. Additional routing information such as optimized waypoint order or turn by turn instructions is also available, depending on the options selected.
        ///
        /// Routing service provides a set of parameters for a detailed description of a vehicle-specific consumption model. For more information, see [Consumption Model](/azure/azure-maps/consumption-model).
        /// </remarks>
        public async Task<Response<RouteDirections>> GetRouteDirectionsAsync(ResponseFormat format, string routePoints, int? maxAlternatives = null, AlternativeRouteType? alternativeType = null, int? minDeviationDistance = null, DateTimeOffset? arriveAt = null, DateTimeOffset? departAt = null, int? minDeviationTime = null, RouteInstructionsType? instructionsType = null, string language = null, bool? computeBestWaypointOrder = null, RouteRepresentationForBestOrder? routeRepresentationForBestOrder = null, TravelTimeType? computeTravelTime = null, int? vehicleHeading = null, Report? report = null, IEnumerable<SectionType> filterSectionType = null, int? vehicleAxleWeight = null, double? vehicleWidth = null, double? vehicleHeight = null, double? vehicleLength = null, int? vehicleMaxSpeed = null, int? vehicleWeight = null, bool? isCommercialVehicle = null, WindingnessLevel? windingness = null, InclineLevel? inclineLevel = null, TravelMode? travelMode = null, IEnumerable<RouteAvoidType> avoid = null, bool? useTrafficData = null, RouteType? routeType = null, VehicleLoadType? vehicleLoadType = null, VehicleEngineType? vehicleEngineType = null, string constantSpeedConsumptionInLitersPerHundredKm = null, double? currentFuelInLiters = null, double? auxiliaryPowerInLitersPerHour = null, double? fuelEnergyDensityInMegajoulesPerLiter = null, double? accelerationEfficiency = null, double? decelerationEfficiency = null, double? uphillEfficiency = null, double? downhillEfficiency = null, string constantSpeedConsumptionInKwHPerHundredKm = null, double? currentChargeInKwH = null, double? maxChargeInKwH = null, double? auxiliaryPowerInKw = null, CancellationToken cancellationToken = default)
        {
            if (routePoints == null)
            {
                throw new ArgumentNullException(nameof(routePoints));
            }

            using var message = CreateGetRouteDirectionsRequest(format, routePoints, maxAlternatives, alternativeType, minDeviationDistance, arriveAt, departAt, minDeviationTime, instructionsType, language, computeBestWaypointOrder, routeRepresentationForBestOrder, computeTravelTime, vehicleHeading, report, filterSectionType, vehicleAxleWeight, vehicleWidth, vehicleHeight, vehicleLength, vehicleMaxSpeed, vehicleWeight, isCommercialVehicle, windingness, inclineLevel, travelMode, avoid, useTrafficData, routeType, vehicleLoadType, vehicleEngineType, constantSpeedConsumptionInLitersPerHundredKm, currentFuelInLiters, auxiliaryPowerInLitersPerHour, fuelEnergyDensityInMegajoulesPerLiter, accelerationEfficiency, decelerationEfficiency, uphillEfficiency, downhillEfficiency, constantSpeedConsumptionInKwHPerHundredKm, currentChargeInKwH, maxChargeInKwH, auxiliaryPowerInKw);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RouteDirections value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RouteDirections.DeserializeRouteDirections(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to calculate a route between a specified origin and destination, passing through any specified waypoints. </summary>
        /// <param name="format"> Desired format of the response. Value can be either _json_ or _xml_. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="routePoints"> The Coordinates through which the route is calculated, delimited by a colon.  A minimum of two coordinates is required.  The first one is the origin and the last is the destination of the route. Optional coordinates in-between act as WayPoints in the route.  You can pass up to 150 WayPoints. </param>
        /// <param name="maxAlternatives"> Number of desired alternative routes to be calculated. Default: 0, minimum: 0 and maximum: 5. </param>
        /// <param name="alternativeType"> Controls the optimality, with respect to the given planning criteria, of the calculated alternatives compared to the reference route. </param>
        /// <param name="minDeviationDistance"> All alternative routes returned will follow the reference route (see section POST Requests) from the origin point of the calculateRoute request for at least this number of meters. Can only be used when reconstructing a route. The minDeviationDistance parameter cannot be used in conjunction with arriveAt. </param>
        /// <param name="arriveAt">
        /// The date and time of arrival at the destination point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified it will be assumed to be that of the destination point.
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `arriveAt` parameter cannot be used in conjunction with `departAt`, `minDeviationDistance` or `minDeviationTime`.
        /// </param>
        /// <param name="departAt">
        /// The date and time of departure from the origin point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified, it will be assumed to be that of the origin point.
        ///   * Default value: now
        ///   * Other value: `dateTime`
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `departAt` parameter cannot be used in conjunction with `arriveAt`.
        /// </param>
        /// <param name="minDeviationTime">
        /// All alternative routes returned will follow the reference route (see section POST Requests) from the origin point of the calculateRoute request for at least this number of seconds. Can only be used when reconstructing a route. The minDeviationTime parameter cannot be used in conjunction with arriveAt. Default value is 0. Setting )minDeviationTime_ to a value greater than zero has the following consequences:
        ///   - The origin point of the _calculateRoute_ Request must be on
        ///     (or very near) the input reference route.
        ///     - If this is not the case, an error is returned.
        ///     - However, the origin point does not need to be at the beginning
        ///       of the input reference route (it can be thought of as the current
        ///       vehicle position on the reference route).
        ///   - The reference route, returned as the first route in the _calculateRoute_
        ///     Response, will start at the origin point specified in the _calculateRoute_
        ///     Request. The initial part of the input reference route up until the origin
        ///     point will be excluded from the Response.
        ///   - The values of _minDeviationDistance_ and _minDeviationTime_ determine
        ///     how far alternative routes will be guaranteed to follow the reference
        ///     route from the origin point onwards.
        ///   - The route must use _departAt_.
        ///   - The _vehicleHeading_ is ignored.
        /// </param>
        /// <param name="instructionsType"> If specified, guidance instructions will be returned. Note that the instructionsType parameter cannot be used in conjunction with routeRepresentation=none. </param>
        /// <param name="language">
        /// The language parameter determines the language of the guidance messages. Proper nouns (the names of streets, plazas, etc.) are returned in the specified  language, or if that is not available, they are returned in an available language  that is close to it. Allowed values are (a subset of) the IETF language tags. The currently supported  languages are listed in the [Supported languages  section](https://docs.microsoft.com/azure/azure-maps/supported-languages).
        ///
        /// Default value: en-GB
        /// </param>
        /// <param name="computeBestWaypointOrder"> Re-order the route waypoints using a fast heuristic algorithm to reduce the route length. Yields best results when used in conjunction with routeType _shortest_. Notice that origin and destination are excluded from the optimized waypoint indices. To include origin and destination in the response, please increase all the indices by 1 to account for the origin, and then add the destination as the final index. Possible values are true or false. True computes a better order if possible, but is not allowed to be used in conjunction with maxAlternatives value greater than 0 or in conjunction with circle waypoints. False will use the locations in the given order and not allowed to be used in conjunction with routeRepresentation _none_. </param>
        /// <param name="routeRepresentationForBestOrder"> Specifies the representation of the set of routes provided as response. This parameter value can only be used in conjunction with computeBestOrder=true. </param>
        /// <param name="computeTravelTime"> Specifies whether to return additional travel times using different types of traffic information (none, historic, live) as well as the default best-estimate travel time. </param>
        /// <param name="vehicleHeading"> The directional heading of the vehicle in degrees starting at true North and continuing in clockwise direction. North is 0 degrees, east is 90 degrees, south is 180 degrees, west is 270 degrees. Possible values 0-359. </param>
        /// <param name="report"> Specifies which data should be reported for diagnosis purposes. The only possible value is _effectiveSettings_. Reports the effective parameters or data used when calling the API. In the case of defaulted parameters the default will be reflected where the parameter was not specified by the caller. </param>
        /// <param name="filterSectionType"> Specifies which of the section types is reported in the route response. &lt;br&gt;&lt;br&gt;For example if sectionType = pedestrian the sections which are suited for pedestrians only are returned. Can be specified multiple times in one request, for example, '&amp;sectionType=carTrain&amp;sectionType=pedestrian&amp;sectionType=motorway'. The default sectionType refers to the travelMode input. By default travelMode is set to car. </param>
        /// <param name="vehicleAxleWeight"> Weight per axle of the vehicle in kg. A value of 0 means that weight restrictions per axle are not considered. </param>
        /// <param name="vehicleWidth"> Width of the vehicle in meters. A value of 0 means that width restrictions are not considered. </param>
        /// <param name="vehicleHeight"> Height of the vehicle in meters. A value of 0 means that height restrictions are not considered. </param>
        /// <param name="vehicleLength"> Length of the vehicle in meters. A value of 0 means that length restrictions are not considered. </param>
        /// <param name="vehicleMaxSpeed">
        /// Maximum speed of the vehicle in km/hour. The max speed in the vehicle profile is used to check whether a vehicle is allowed on motorways.
        ///
        /// * A value of 0 means that an appropriate value for the vehicle will be determined and applied during route planning.
        ///
        /// * A non-zero value may be overridden during route planning. For example, the current traffic flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will again use 60 km/hour.
        /// </param>
        /// <param name="vehicleWeight">
        /// Weight of the vehicle in kilograms.
        ///
        /// * It is mandatory if any of the *Efficiency parameters are set.
        ///
        /// * It must be strictly positive when used in the context of the Consumption Model. Weight restrictions are considered.
        ///
        /// * If no detailed **Consumption Model** is specified and the value of **vehicleWeight** is non-zero, then weight restrictions are considered.
        ///
        /// * In all other cases, this parameter is ignored.
        ///
        /// Sensible Values : for **Combustion Model** : 1600, for **Electric Model** : 1900
        /// </param>
        /// <param name="isCommercialVehicle"> Whether the vehicle is used for commercial purposes. Commercial vehicles may not be allowed to drive on some roads. </param>
        /// <param name="windingness"> Level of turns for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="inclineLevel"> Degree of hilliness for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="travelMode"> The mode of travel for the requested route. If not defined, default is 'car'. Note that the requested travelMode may not be available for the entire route. Where the requested travelMode is not available for a particular section, the travelMode element of the response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van are BETA functionality. Full restriction data is not available in all areas. </param>
        /// <param name="avoid"> Specifies something that the route calculation should try to avoid when determining the route. Can be specified multiple times in one request, for example, '&amp;avoid=motorways&amp;avoid=tollRoads&amp;avoid=ferries'. In Route Range requests, the value alreadyUsedRoads must not be used. </param>
        /// <param name="useTrafficData">
        /// Possible values:
        ///   * true - Do consider all available traffic information during routing
        ///   * false - Ignore current traffic data during routing. Note that although the current traffic data is ignored
        ///   during routing, the effect of historic traffic on effective road speeds is still incorporated.
        /// </param>
        /// <param name="routeType"> The type of route requested. </param>
        /// <param name="vehicleLoadType"> Types of cargo that may be classified as hazardous materials and restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9, plus generic classifications for use in other countries/regions. Values beginning with USHazmat are for US routing while otherHazmat should be used for all other countries/regions. vehicleLoadType can be specified multiple times. This parameter is currently only considered for travelMode=truck. </param>
        /// <param name="vehicleEngineType"> Engine type of the vehicle. When a detailed Consumption Model is specified, it must be consistent with the value of **vehicleEngineType**. </param>
        /// <param name="constantSpeedConsumptionInLitersPerHundredKm">
        ///
        /// Specifies the speed-dependent component of consumption.
        ///
        /// Provided as an unordered list of colon-delimited speed &amp; consumption-rate pairs. The list defines points on a consumption curve. Consumption rates for speeds not in the list are found as follows:
        ///
        ///  * by linear interpolation, if the given speed lies in between two speeds in the list
        ///
        ///  * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by the nearest two points in the list
        ///
        /// The list must contain between 1 and 25 points (inclusive), and may not contain duplicate points for the same speed. If it only contains a single point, then the consumption rate of that point is used without further processing.
        ///
        /// Consumption specified for the largest speed must be greater than or equal to that of the penultimate largest speed. This ensures that extrapolation does not lead to negative consumption rates.
        ///
        /// Similarly, consumption values specified for the two smallest speeds in the list cannot lead to a negative consumption rate for any smaller speed.
        ///
        /// The valid range for the consumption values(expressed in l/100km) is between 0.01 and 100000.0.
        ///
        /// Sensible Values : 50,6.3:130,11.5
        ///
        /// **Note** : This parameter is required for **The Combustion Consumption Model**.
        /// </param>
        /// <param name="currentFuelInLiters">
        /// Specifies the current supply of fuel in liters.
        ///
        /// Sensible Values : 55
        /// </param>
        /// <param name="auxiliaryPowerInLitersPerHour">
        /// Specifies the amount of fuel consumed for sustaining auxiliary systems of the vehicle, in liters per hour.
        ///
        /// It can be used to specify consumption due to devices and systems such as AC systems, radio, heating, etc.
        ///
        /// Sensible Values : 0.2
        /// </param>
        /// <param name="fuelEnergyDensityInMegajoulesPerLiter">
        /// Specifies the amount of chemical energy stored in one liter of fuel in megajoules (MJ). It is used in conjunction with the ***Efficiency** parameters for conversions between saved or consumed energy and fuel. For example, energy density is 34.2 MJ/l for gasoline, and 35.8 MJ/l for Diesel fuel.
        ///
        /// This parameter is required if any ***Efficiency** parameter is set.
        ///
        /// Sensible Values : 34.2
        /// </param>
        /// <param name="accelerationEfficiency">
        /// Specifies the efficiency of converting chemical energy stored in fuel to kinetic energy when the vehicle accelerates _(i.e. KineticEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed_ is obtained by converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **decelerationEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**decelerationEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.33, for **Electric Model** : 0.66
        /// </param>
        /// <param name="decelerationEfficiency">
        /// Specifies the efficiency of converting kinetic energy to saved (not consumed) fuel when the vehicle decelerates _(i.e. ChemicalEnergySaved/KineticEnergyLost). ChemicalEnergySaved_ is obtained by converting saved (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **accelerationEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**accelerationEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.83, for **Electric Model** : 0.91
        /// </param>
        /// <param name="uphillEfficiency">
        /// Specifies the efficiency of converting chemical energy stored in fuel to potential energy when the vehicle gains elevation _(i.e. PotentialEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed_ is obtained by converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **downhillEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**downhillEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.27, for **Electric Model** : 0.74
        /// </param>
        /// <param name="downhillEfficiency">
        /// Specifies the efficiency of converting potential energy to saved (not consumed) fuel when the vehicle loses elevation _(i.e. ChemicalEnergySaved/PotentialEnergyLost). ChemicalEnergySaved_ is obtained by converting saved (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **uphillEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**uphillEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.51, for **Electric Model** : 0.73
        /// </param>
        /// <param name="constantSpeedConsumptionInKwHPerHundredKm">
        /// Specifies the speed-dependent component of consumption.
        ///
        /// Provided as an unordered list of speed/consumption-rate pairs. The list defines points on a consumption curve. Consumption rates for speeds not in the list are found as follows:
        ///
        /// * by linear interpolation, if the given speed lies in between two speeds in the list
        ///
        /// * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by the nearest two points in the list
        ///
        /// The list must contain between 1 and 25 points (inclusive), and may not contain duplicate points for the same speed. If it only contains a single point, then the consumption rate of that point is used without further processing.
        ///
        /// Consumption specified for the largest speed must be greater than or equal to that of the penultimate largest speed. This ensures that extrapolation does not lead to negative consumption rates.
        ///
        /// Similarly, consumption values specified for the two smallest speeds in the list cannot lead to a negative consumption rate for any smaller  speed.
        ///
        /// The valid range for the consumption values(expressed in kWh/100km) is between 0.01 and 100000.0.
        ///
        /// Sensible Values : 50,8.2:130,21.3
        ///
        /// This parameter is required for **Electric consumption model**.
        /// </param>
        /// <param name="currentChargeInKwH">
        /// Specifies the current electric energy supply in kilowatt hours (kWh).
        ///
        /// This parameter co-exists with **maxChargeInkWh** parameter.
        ///
        /// The range of values allowed are 0.0 to **maxChargeInkWh**.
        ///
        /// Sensible Values : 43
        /// </param>
        /// <param name="maxChargeInKwH">
        /// Specifies the maximum electric energy supply in kilowatt hours (kWh) that may be stored in the vehicle's battery.
        ///
        /// This parameter co-exists with **currentChargeInkWh** parameter.
        ///
        /// Minimum value has to be greater than or equal to **currentChargeInkWh**.
        ///
        /// Sensible Values : 85
        /// </param>
        /// <param name="auxiliaryPowerInKw">
        /// Specifies the amount of power consumed for sustaining auxiliary systems, in kilowatts (kW).
        ///
        /// It can be used to specify consumption due to devices and systems such as AC systems, radio, heating, etc.
        ///
        /// Sensible Values : 1.7
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="routePoints"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Route Directions` API is an HTTP `GET` request that returns a route between an origin and a destination, passing through waypoints if specified. The route takes into account factors such as current traffic and the typical road speeds on the requested day of the week and time of day.
        ///
        /// Information returned includes the distance, estimated travel time, and a representation of the route geometry. Additional routing information such as optimized waypoint order or turn by turn instructions is also available, depending on the options selected.
        ///
        /// Routing service provides a set of parameters for a detailed description of a vehicle-specific consumption model. For more information, see [Consumption Model](/azure/azure-maps/consumption-model).
        /// </remarks>
        public Response<RouteDirections> GetRouteDirections(ResponseFormat format, string routePoints, int? maxAlternatives = null, AlternativeRouteType? alternativeType = null, int? minDeviationDistance = null, DateTimeOffset? arriveAt = null, DateTimeOffset? departAt = null, int? minDeviationTime = null, RouteInstructionsType? instructionsType = null, string language = null, bool? computeBestWaypointOrder = null, RouteRepresentationForBestOrder? routeRepresentationForBestOrder = null, TravelTimeType? computeTravelTime = null, int? vehicleHeading = null, Report? report = null, IEnumerable<SectionType> filterSectionType = null, int? vehicleAxleWeight = null, double? vehicleWidth = null, double? vehicleHeight = null, double? vehicleLength = null, int? vehicleMaxSpeed = null, int? vehicleWeight = null, bool? isCommercialVehicle = null, WindingnessLevel? windingness = null, InclineLevel? inclineLevel = null, TravelMode? travelMode = null, IEnumerable<RouteAvoidType> avoid = null, bool? useTrafficData = null, RouteType? routeType = null, VehicleLoadType? vehicleLoadType = null, VehicleEngineType? vehicleEngineType = null, string constantSpeedConsumptionInLitersPerHundredKm = null, double? currentFuelInLiters = null, double? auxiliaryPowerInLitersPerHour = null, double? fuelEnergyDensityInMegajoulesPerLiter = null, double? accelerationEfficiency = null, double? decelerationEfficiency = null, double? uphillEfficiency = null, double? downhillEfficiency = null, string constantSpeedConsumptionInKwHPerHundredKm = null, double? currentChargeInKwH = null, double? maxChargeInKwH = null, double? auxiliaryPowerInKw = null, CancellationToken cancellationToken = default)
        {
            if (routePoints == null)
            {
                throw new ArgumentNullException(nameof(routePoints));
            }

            using var message = CreateGetRouteDirectionsRequest(format, routePoints, maxAlternatives, alternativeType, minDeviationDistance, arriveAt, departAt, minDeviationTime, instructionsType, language, computeBestWaypointOrder, routeRepresentationForBestOrder, computeTravelTime, vehicleHeading, report, filterSectionType, vehicleAxleWeight, vehicleWidth, vehicleHeight, vehicleLength, vehicleMaxSpeed, vehicleWeight, isCommercialVehicle, windingness, inclineLevel, travelMode, avoid, useTrafficData, routeType, vehicleLoadType, vehicleEngineType, constantSpeedConsumptionInLitersPerHundredKm, currentFuelInLiters, auxiliaryPowerInLitersPerHour, fuelEnergyDensityInMegajoulesPerLiter, accelerationEfficiency, decelerationEfficiency, uphillEfficiency, downhillEfficiency, constantSpeedConsumptionInKwHPerHundredKm, currentChargeInKwH, maxChargeInKwH, auxiliaryPowerInKw);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RouteDirections value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RouteDirections.DeserializeRouteDirections(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetRouteDirectionsWithAdditionalParametersRequest(ResponseFormat format, string routePoints, RouteDirectionParameters routeDirectionParameters, int? maxAlternatives, AlternativeRouteType? alternativeType, int? minDeviationDistance, int? minDeviationTime, RouteInstructionsType? instructionsType, string language, bool? computeBestWaypointOrder, RouteRepresentationForBestOrder? routeRepresentationForBestOrder, TravelTimeType? computeTravelTime, int? vehicleHeading, Report? report, IEnumerable<SectionType> filterSectionType, DateTimeOffset? arriveAt, DateTimeOffset? departAt, int? vehicleAxleWeight, double? vehicleLength, double? vehicleHeight, double? vehicleWidth, int? vehicleMaxSpeed, int? vehicleWeight, bool? isCommercialVehicle, WindingnessLevel? windingness, InclineLevel? inclineLevel, TravelMode? travelMode, IEnumerable<RouteAvoidType> avoid, bool? useTrafficData, RouteType? routeType, VehicleLoadType? vehicleLoadType, VehicleEngineType? vehicleEngineType, string constantSpeedConsumptionInLitersPerHundredKm, double? currentFuelInLiters, double? auxiliaryPowerInLitersPerHour, double? fuelEnergyDensityInMegajoulesPerLiter, double? accelerationEfficiency, double? decelerationEfficiency, double? uphillEfficiency, double? downhillEfficiency, string constantSpeedConsumptionInKwHPerHundredKm, double? currentChargeInKwH, double? maxChargeInKwH, double? auxiliaryPowerInKw)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/route/directions/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            uri.AppendQuery("query", routePoints, true);
            if (maxAlternatives != null)
            {
                uri.AppendQuery("maxAlternatives", maxAlternatives.Value, true);
            }
            if (alternativeType != null)
            {
                uri.AppendQuery("alternativeType", alternativeType.Value.ToString(), true);
            }
            if (minDeviationDistance != null)
            {
                uri.AppendQuery("minDeviationDistance", minDeviationDistance.Value, true);
            }
            if (minDeviationTime != null)
            {
                uri.AppendQuery("minDeviationTime", minDeviationTime.Value, true);
            }
            if (instructionsType != null)
            {
                uri.AppendQuery("instructionsType", instructionsType.Value.ToString(), true);
            }
            if (language != null)
            {
                uri.AppendQuery("language", language, true);
            }
            if (computeBestWaypointOrder != null)
            {
                uri.AppendQuery("computeBestOrder", computeBestWaypointOrder.Value, true);
            }
            if (routeRepresentationForBestOrder != null)
            {
                uri.AppendQuery("routeRepresentation", routeRepresentationForBestOrder.Value.ToString(), true);
            }
            if (computeTravelTime != null)
            {
                uri.AppendQuery("computeTravelTimeFor", computeTravelTime.Value.ToString(), true);
            }
            if (vehicleHeading != null)
            {
                uri.AppendQuery("vehicleHeading", vehicleHeading.Value, true);
            }
            if (report != null)
            {
                uri.AppendQuery("report", report.Value.ToString(), true);
            }
            if (filterSectionType != null && !(filterSectionType is Common.ChangeTrackingList<SectionType> changeTrackingList && changeTrackingList.IsUndefined))
            {
                foreach (var param in filterSectionType)
                {
                    uri.AppendQuery("sectionType", param.ToString(), true);
                }
            }
            if (arriveAt != null)
            {
                uri.AppendQuery("arriveAt", arriveAt.Value, "O", true);
            }
            if (departAt != null)
            {
                uri.AppendQuery("departAt", departAt.Value, "O", true);
            }
            if (vehicleAxleWeight != null)
            {
                uri.AppendQuery("vehicleAxleWeight", vehicleAxleWeight.Value, true);
            }
            if (vehicleLength != null)
            {
                uri.AppendQuery("vehicleLength", vehicleLength.Value, true);
            }
            if (vehicleHeight != null)
            {
                uri.AppendQuery("vehicleHeight", vehicleHeight.Value, true);
            }
            if (vehicleWidth != null)
            {
                uri.AppendQuery("vehicleWidth", vehicleWidth.Value, true);
            }
            if (vehicleMaxSpeed != null)
            {
                uri.AppendQuery("vehicleMaxSpeed", vehicleMaxSpeed.Value, true);
            }
            if (vehicleWeight != null)
            {
                uri.AppendQuery("vehicleWeight", vehicleWeight.Value, true);
            }
            if (isCommercialVehicle != null)
            {
                uri.AppendQuery("vehicleCommercial", isCommercialVehicle.Value, true);
            }
            if (windingness != null)
            {
                uri.AppendQuery("windingness", windingness.Value.ToString(), true);
            }
            if (inclineLevel != null)
            {
                uri.AppendQuery("hilliness", inclineLevel.Value.ToString(), true);
            }
            if (travelMode != null)
            {
                uri.AppendQuery("travelMode", travelMode.Value.ToString(), true);
            }
            if (avoid != null && !(avoid is Common.ChangeTrackingList<RouteAvoidType> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                foreach (var param in avoid)
                {
                    uri.AppendQuery("avoid", param.ToString(), true);
                }
            }
            if (useTrafficData != null)
            {
                uri.AppendQuery("traffic", useTrafficData.Value, true);
            }
            if (routeType != null)
            {
                uri.AppendQuery("routeType", routeType.Value.ToString(), true);
            }
            if (vehicleLoadType != null)
            {
                uri.AppendQuery("vehicleLoadType", vehicleLoadType.Value.ToString(), true);
            }
            if (vehicleEngineType != null)
            {
                uri.AppendQuery("vehicleEngineType", vehicleEngineType.Value.ToString(), true);
            }
            if (constantSpeedConsumptionInLitersPerHundredKm != null)
            {
                uri.AppendQuery("constantSpeedConsumptionInLitersPerHundredkm", constantSpeedConsumptionInLitersPerHundredKm, true);
            }
            if (currentFuelInLiters != null)
            {
                uri.AppendQuery("currentFuelInLiters", currentFuelInLiters.Value, true);
            }
            if (auxiliaryPowerInLitersPerHour != null)
            {
                uri.AppendQuery("auxiliaryPowerInLitersPerHour", auxiliaryPowerInLitersPerHour.Value, true);
            }
            if (fuelEnergyDensityInMegajoulesPerLiter != null)
            {
                uri.AppendQuery("fuelEnergyDensityInMJoulesPerLiter", fuelEnergyDensityInMegajoulesPerLiter.Value, true);
            }
            if (accelerationEfficiency != null)
            {
                uri.AppendQuery("accelerationEfficiency", accelerationEfficiency.Value, true);
            }
            if (decelerationEfficiency != null)
            {
                uri.AppendQuery("decelerationEfficiency", decelerationEfficiency.Value, true);
            }
            if (uphillEfficiency != null)
            {
                uri.AppendQuery("uphillEfficiency", uphillEfficiency.Value, true);
            }
            if (downhillEfficiency != null)
            {
                uri.AppendQuery("downhillEfficiency", downhillEfficiency.Value, true);
            }
            if (constantSpeedConsumptionInKwHPerHundredKm != null)
            {
                uri.AppendQuery("constantSpeedConsumptionInkWhPerHundredkm", constantSpeedConsumptionInKwHPerHundredKm, true);
            }
            if (currentChargeInKwH != null)
            {
                uri.AppendQuery("currentChargeInkWh", currentChargeInKwH.Value, true);
            }
            if (maxChargeInKwH != null)
            {
                uri.AppendQuery("maxChargeInkWh", maxChargeInKwH.Value, true);
            }
            if (auxiliaryPowerInKw != null)
            {
                uri.AppendQuery("auxiliaryPowerInkW", auxiliaryPowerInKw.Value, true);
            }
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(routeDirectionParameters);
            request.Content = content;
            return message;
        }

        /// <summary> Use to calculate a route between a given origin and destination, passing through any specified waypoints. </summary>
        /// <param name="format"> Desired format of the response. Value can be either _json_ or _xml_. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="routePoints"> The Coordinates through which the route is calculated, delimited by a colon.  A minimum of two coordinates is required.  The first one is the origin and the last is the destination of the route. Optional coordinates in-between act as WayPoints in the route.  You can pass up to 150 WayPoints. </param>
        /// <param name="routeDirectionParameters">
        /// Used for reconstructing a route and for calculating zero or more alternative routes to this reference route.  The provided sequence of coordinates is used as input for route reconstruction. The alternative routes  are calculated between the origin and destination points specified in the base path parameter locations.  If both minDeviationDistance and minDeviationTime are set to zero, then these origin and destination points  are expected to be at (or very near) the beginning and end of the reference route, respectively. Intermediate  locations (waypoints) are not supported when using supportingPoints.
        ///
        /// Setting at least one of minDeviationDistance or minDeviationTime to a value greater than zero has the  following consequences:
        ///
        /// *  The origin point of the calculateRoute request must be on (or very near) the input reference route. If  this is not the case, an error is returned. However, the origin point does not need to be at the beginning of  the input reference route (it can be thought of as the current vehicle position on the reference route).
        /// *  The reference route, returned as the first route in the calculateRoute response, will start at the origin  point specified in the calculateRoute request. The initial part of the input reference route up until the  origin point will be excluded from the response.
        /// *  The values of minDeviationDistance and minDeviationTime determine how far alternative routes will be  guaranteed to follow the reference route from the origin point onwards.
        /// *  The route must use departAt.
        /// *  The vehicleHeading is ignored.
        /// </param>
        /// <param name="maxAlternatives"> Number of desired alternative routes to be calculated. Default: 0, minimum: 0 and maximum: 5. </param>
        /// <param name="alternativeType"> Controls the optimality, with respect to the given planning criteria, of the calculated alternatives compared to the reference route. </param>
        /// <param name="minDeviationDistance"> All alternative routes returned will follow the reference route (see section POST Requests) from the origin point of the calculateRoute request for at least this number of meters. Can only be used when reconstructing a route. The minDeviationDistance parameter cannot be used in conjunction with arriveAt. </param>
        /// <param name="minDeviationTime">
        /// All alternative routes returned will follow the reference route (see section POST Requests) from the origin point of the calculateRoute request for at least this number of seconds. Can only be used when reconstructing a route. The minDeviationTime parameter cannot be used in conjunction with arriveAt. Default value is 0. Setting )minDeviationTime_ to a value greater than zero has the following consequences:
        ///   - The origin point of the _calculateRoute_ Request must be on
        ///     (or very near) the input reference route.
        ///     - If this is not the case, an error is returned.
        ///     - However, the origin point does not need to be at the beginning
        ///       of the input reference route (it can be thought of as the current
        ///       vehicle position on the reference route).
        ///   - The reference route, returned as the first route in the _calculateRoute_
        ///     Response, will start at the origin point specified in the _calculateRoute_
        ///     Request. The initial part of the input reference route up until the origin
        ///     point will be excluded from the Response.
        ///   - The values of _minDeviationDistance_ and _minDeviationTime_ determine
        ///     how far alternative routes will be guaranteed to follow the reference
        ///     route from the origin point onwards.
        ///   - The route must use _departAt_.
        ///   - The _vehicleHeading_ is ignored.
        /// </param>
        /// <param name="instructionsType"> If specified, guidance instructions will be returned. Note that the instructionsType parameter cannot be used in conjunction with routeRepresentation=none. </param>
        /// <param name="language"> The language parameter determines the language of the guidance messages. It does not affect proper nouns (the names of streets, plazas, etc.) It has no effect when instructionsType=coded. Allowed values are (a subset of) the IETF language tags described. </param>
        /// <param name="computeBestWaypointOrder"> Re-order the route waypoints using a fast heuristic algorithm to reduce the route length. Yields best results when used in conjunction with routeType _shortest_. Notice that origin and destination are excluded from the optimized waypoint indices. To include origin and destination in the response, please increase all the indices by 1 to account for the origin, and then add the destination as the final index. Possible values are true or false. True computes a better order if possible, but is not allowed to be used in conjunction with maxAlternatives value greater than 0 or in conjunction with circle waypoints. False will use the locations in the given order and not allowed to be used in conjunction with routeRepresentation _none_. </param>
        /// <param name="routeRepresentationForBestOrder"> Specifies the representation of the set of routes provided as response. This parameter value can only be used in conjunction with computeBestOrder=true. </param>
        /// <param name="computeTravelTime"> Specifies whether to return additional travel times using different types of traffic information (none, historic, live) as well as the default best-estimate travel time. </param>
        /// <param name="vehicleHeading"> The directional heading of the vehicle in degrees starting at true North and continuing in clockwise direction. North is 0 degrees, east is 90 degrees, south is 180 degrees, west is 270 degrees. Possible values 0-359. </param>
        /// <param name="report"> Specifies which data should be reported for diagnosis purposes. The only possible value is _effectiveSettings_. Reports the effective parameters or data used when calling the API. In the case of defaulted parameters the default will be reflected where the parameter was not specified by the caller. </param>
        /// <param name="filterSectionType"> Specifies which of the section types is reported in the route response. &lt;br&gt;&lt;br&gt;For example if sectionType = pedestrian the sections which are suited for pedestrians only are returned. Can be specified multiple times in one request, for example, '&amp;sectionType=carTrain&amp;sectionType=pedestrian&amp;sectionType=motorway'. The default sectionType refers to the travelMode input. By default travelMode is set to car. </param>
        /// <param name="arriveAt">
        /// The date and time of arrival at the destination point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified it will be assumed to be that of the destination point.
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `arriveAt` parameter cannot be used in conjunction with `departAt`, `minDeviationDistance` or `minDeviationTime`.
        /// </param>
        /// <param name="departAt">
        /// The date and time of departure from the origin point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified, it will be assumed to be that of the origin point.
        ///   * Default value: now
        ///   * Other value: `dateTime`
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `departAt` parameter cannot be used in conjunction with `arriveAt`.
        /// </param>
        /// <param name="vehicleAxleWeight"> Weight per axle of the vehicle in kg. A value of 0 means that weight restrictions per axle are not considered. </param>
        /// <param name="vehicleLength"> Length of the vehicle in meters. A value of 0 means that length restrictions are not considered. </param>
        /// <param name="vehicleHeight"> Height of the vehicle in meters. A value of 0 means that height restrictions are not considered. </param>
        /// <param name="vehicleWidth"> Width of the vehicle in meters. A value of 0 means that width restrictions are not considered. </param>
        /// <param name="vehicleMaxSpeed">
        /// Maximum speed of the vehicle in km/hour. The max speed in the vehicle profile is used to check whether a vehicle is allowed on motorways.
        ///
        /// * A value of 0 means that an appropriate value for the vehicle will be determined and applied during route planning.
        ///
        /// * A non-zero value may be overridden during route planning. For example, the current traffic flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will again use 60 km/hour.
        /// </param>
        /// <param name="vehicleWeight">
        /// Weight of the vehicle in kilograms.
        ///
        /// * It is mandatory if any of the *Efficiency parameters are set.
        ///
        /// * It must be strictly positive when used in the context of the Consumption Model. Weight restrictions are considered.
        ///
        /// * If no detailed **Consumption Model** is specified and the value of **vehicleWeight** is non-zero, then weight restrictions are considered.
        ///
        /// * In all other cases, this parameter is ignored.
        ///
        /// Sensible Values : for **Combustion Model** : 1600, for **Electric Model** : 1900
        /// </param>
        /// <param name="isCommercialVehicle"> Whether the vehicle is used for commercial purposes. Commercial vehicles may not be allowed to drive on some roads. </param>
        /// <param name="windingness"> Level of turns for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="inclineLevel"> Degree of hilliness for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="travelMode"> The mode of travel for the requested route. If not defined, default is 'car'. Note that the requested travelMode may not be available for the entire route. Where the requested travelMode is not available for a particular section, the travelMode element of the response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van are BETA functionality. Full restriction data is not available in all areas. </param>
        /// <param name="avoid"> Specifies something that the route calculation should try to avoid when determining the route. Can be specified multiple times in one request, for example, '&amp;avoid=motorways&amp;avoid=tollRoads&amp;avoid=ferries'. In Route Range requests, the value alreadyUsedRoads must not be used. </param>
        /// <param name="useTrafficData">
        /// Possible values:
        ///   * true - Do consider all available traffic information during routing
        ///   * false - Ignore current traffic data during routing. Note that although the current traffic data is ignored
        ///   during routing, the effect of historic traffic on effective road speeds is still incorporated.
        /// </param>
        /// <param name="routeType"> The type of route requested. </param>
        /// <param name="vehicleLoadType"> Types of cargo that may be classified as hazardous materials and restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9, plus generic classifications for use in other countries/regions. Values beginning with USHazmat are for US routing while otherHazmat should be used for all other countries/regions. vehicleLoadType can be specified multiple times. This parameter is currently only considered for travelMode=truck. </param>
        /// <param name="vehicleEngineType"> Engine type of the vehicle. When a detailed Consumption Model is specified, it must be consistent with the value of **vehicleEngineType**. </param>
        /// <param name="constantSpeedConsumptionInLitersPerHundredKm">
        ///
        /// Specifies the speed-dependent component of consumption.
        ///
        /// Provided as an unordered list of colon-delimited speed &amp; consumption-rate pairs. The list defines points on a consumption curve. Consumption rates for speeds not in the list are found as follows:
        ///
        ///  * by linear interpolation, if the given speed lies in between two speeds in the list
        ///
        ///  * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by the nearest two points in the list
        ///
        /// The list must contain between 1 and 25 points (inclusive), and may not contain duplicate points for the same speed. If it only contains a single point, then the consumption rate of that point is used without further processing.
        ///
        /// Consumption specified for the largest speed must be greater than or equal to that of the penultimate largest speed. This ensures that extrapolation does not lead to negative consumption rates.
        ///
        /// Similarly, consumption values specified for the two smallest speeds in the list cannot lead to a negative consumption rate for any smaller speed.
        ///
        /// The valid range for the consumption values(expressed in l/100km) is between 0.01 and 100000.0.
        ///
        /// Sensible Values : 50,6.3:130,11.5
        ///
        /// **Note** : This parameter is required for **The Combustion Consumption Model**.
        /// </param>
        /// <param name="currentFuelInLiters">
        /// Specifies the current supply of fuel in liters.
        ///
        /// Sensible Values : 55
        /// </param>
        /// <param name="auxiliaryPowerInLitersPerHour">
        /// Specifies the amount of fuel consumed for sustaining auxiliary systems of the vehicle, in liters per hour.
        ///
        /// It can be used to specify consumption due to devices and systems such as AC systems, radio, heating, etc.
        ///
        /// Sensible Values : 0.2
        /// </param>
        /// <param name="fuelEnergyDensityInMegajoulesPerLiter">
        /// Specifies the amount of chemical energy stored in one liter of fuel in megajoules (MJ). It is used in conjunction with the ***Efficiency** parameters for conversions between saved or consumed energy and fuel. For example, energy density is 34.2 MJ/l for gasoline, and 35.8 MJ/l for Diesel fuel.
        ///
        /// This parameter is required if any ***Efficiency** parameter is set.
        ///
        /// Sensible Values : 34.2
        /// </param>
        /// <param name="accelerationEfficiency">
        /// Specifies the efficiency of converting chemical energy stored in fuel to kinetic energy when the vehicle accelerates _(i.e. KineticEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed_ is obtained by converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **decelerationEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**decelerationEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.33, for **Electric Model** : 0.66
        /// </param>
        /// <param name="decelerationEfficiency">
        /// Specifies the efficiency of converting kinetic energy to saved (not consumed) fuel when the vehicle decelerates _(i.e. ChemicalEnergySaved/KineticEnergyLost). ChemicalEnergySaved_ is obtained by converting saved (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **accelerationEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**accelerationEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.83, for **Electric Model** : 0.91
        /// </param>
        /// <param name="uphillEfficiency">
        /// Specifies the efficiency of converting chemical energy stored in fuel to potential energy when the vehicle gains elevation _(i.e. PotentialEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed_ is obtained by converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **downhillEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**downhillEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.27, for **Electric Model** : 0.74
        /// </param>
        /// <param name="downhillEfficiency">
        /// Specifies the efficiency of converting potential energy to saved (not consumed) fuel when the vehicle loses elevation _(i.e. ChemicalEnergySaved/PotentialEnergyLost). ChemicalEnergySaved_ is obtained by converting saved (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **uphillEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**uphillEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.51, for **Electric Model** : 0.73
        /// </param>
        /// <param name="constantSpeedConsumptionInKwHPerHundredKm">
        /// Specifies the speed-dependent component of consumption.
        ///
        /// Provided as an unordered list of speed/consumption-rate pairs. The list defines points on a consumption curve. Consumption rates for speeds not in the list are found as follows:
        ///
        /// * by linear interpolation, if the given speed lies in between two speeds in the list
        ///
        /// * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by the nearest two points in the list
        ///
        /// The list must contain between 1 and 25 points (inclusive), and may not contain duplicate points for the same speed. If it only contains a single point, then the consumption rate of that point is used without further processing.
        ///
        /// Consumption specified for the largest speed must be greater than or equal to that of the penultimate largest speed. This ensures that extrapolation does not lead to negative consumption rates.
        ///
        /// Similarly, consumption values specified for the two smallest speeds in the list cannot lead to a negative consumption rate for any smaller  speed.
        ///
        /// The valid range for the consumption values(expressed in kWh/100km) is between 0.01 and 100000.0.
        ///
        /// Sensible Values : 50,8.2:130,21.3
        ///
        /// This parameter is required for **Electric consumption model**.
        /// </param>
        /// <param name="currentChargeInKwH">
        /// Specifies the current electric energy supply in kilowatt hours (kWh).
        ///
        /// This parameter co-exists with **maxChargeInkWh** parameter.
        ///
        /// The range of values allowed are 0.0 to **maxChargeInkWh**.
        ///
        /// Sensible Values : 43
        /// </param>
        /// <param name="maxChargeInKwH">
        /// Specifies the maximum electric energy supply in kilowatt hours (kWh) that may be stored in the vehicle's battery.
        ///
        /// This parameter co-exists with **currentChargeInkWh** parameter.
        ///
        /// Minimum value has to be greater than or equal to **currentChargeInkWh**.
        ///
        /// Sensible Values : 85
        /// </param>
        /// <param name="auxiliaryPowerInKw">
        /// Specifies the amount of power consumed for sustaining auxiliary systems, in kilowatts (kW).
        ///
        /// It can be used to specify consumption due to devices and systems such as AC systems, radio, heating, etc.
        ///
        /// Sensible Values : 1.7
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="routePoints"/> or <paramref name="routeDirectionParameters"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Post Route Directions` API is an HTTP `POST` request that returns a route between an origin and a destination, passing through waypoints if they are specified. The route will take into account factors such as current traffic and the typical road speeds on the requested day of the week and time of day.
        ///
        /// Information returned includes the distance, estimated travel time, and a representation of the route geometry. Additional routing information such as optimized waypoint order or turn by turn instructions is also available, depending on the options selected.
        ///
        /// Routing service provides a set of parameters for a detailed description of a vehicle-specific Consumption Model. Please check [Consumption Model](https://docs.microsoft.com/azure/azure-maps/consumption-model) for detailed explanation of the concepts and parameters involved.
        /// </remarks>
        public async Task<Response<RouteDirections>> GetRouteDirectionsWithAdditionalParametersAsync(ResponseFormat format, string routePoints, RouteDirectionParameters routeDirectionParameters, int? maxAlternatives = null, AlternativeRouteType? alternativeType = null, int? minDeviationDistance = null, int? minDeviationTime = null, RouteInstructionsType? instructionsType = null, string language = null, bool? computeBestWaypointOrder = null, RouteRepresentationForBestOrder? routeRepresentationForBestOrder = null, TravelTimeType? computeTravelTime = null, int? vehicleHeading = null, Report? report = null, IEnumerable<SectionType> filterSectionType = null, DateTimeOffset? arriveAt = null, DateTimeOffset? departAt = null, int? vehicleAxleWeight = null, double? vehicleLength = null, double? vehicleHeight = null, double? vehicleWidth = null, int? vehicleMaxSpeed = null, int? vehicleWeight = null, bool? isCommercialVehicle = null, WindingnessLevel? windingness = null, InclineLevel? inclineLevel = null, TravelMode? travelMode = null, IEnumerable<RouteAvoidType> avoid = null, bool? useTrafficData = null, RouteType? routeType = null, VehicleLoadType? vehicleLoadType = null, VehicleEngineType? vehicleEngineType = null, string constantSpeedConsumptionInLitersPerHundredKm = null, double? currentFuelInLiters = null, double? auxiliaryPowerInLitersPerHour = null, double? fuelEnergyDensityInMegajoulesPerLiter = null, double? accelerationEfficiency = null, double? decelerationEfficiency = null, double? uphillEfficiency = null, double? downhillEfficiency = null, string constantSpeedConsumptionInKwHPerHundredKm = null, double? currentChargeInKwH = null, double? maxChargeInKwH = null, double? auxiliaryPowerInKw = null, CancellationToken cancellationToken = default)
        {
            if (routePoints == null)
            {
                throw new ArgumentNullException(nameof(routePoints));
            }
            if (routeDirectionParameters == null)
            {
                throw new ArgumentNullException(nameof(routeDirectionParameters));
            }

            using var message = CreateGetRouteDirectionsWithAdditionalParametersRequest(format, routePoints, routeDirectionParameters, maxAlternatives, alternativeType, minDeviationDistance, minDeviationTime, instructionsType, language, computeBestWaypointOrder, routeRepresentationForBestOrder, computeTravelTime, vehicleHeading, report, filterSectionType, arriveAt, departAt, vehicleAxleWeight, vehicleLength, vehicleHeight, vehicleWidth, vehicleMaxSpeed, vehicleWeight, isCommercialVehicle, windingness, inclineLevel, travelMode, avoid, useTrafficData, routeType, vehicleLoadType, vehicleEngineType, constantSpeedConsumptionInLitersPerHundredKm, currentFuelInLiters, auxiliaryPowerInLitersPerHour, fuelEnergyDensityInMegajoulesPerLiter, accelerationEfficiency, decelerationEfficiency, uphillEfficiency, downhillEfficiency, constantSpeedConsumptionInKwHPerHundredKm, currentChargeInKwH, maxChargeInKwH, auxiliaryPowerInKw);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RouteDirections value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RouteDirections.DeserializeRouteDirections(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to calculate a route between a given origin and destination, passing through any specified waypoints. </summary>
        /// <param name="format"> Desired format of the response. Value can be either _json_ or _xml_. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="routePoints"> The Coordinates through which the route is calculated, delimited by a colon.  A minimum of two coordinates is required.  The first one is the origin and the last is the destination of the route. Optional coordinates in-between act as WayPoints in the route.  You can pass up to 150 WayPoints. </param>
        /// <param name="routeDirectionParameters">
        /// Used for reconstructing a route and for calculating zero or more alternative routes to this reference route.  The provided sequence of coordinates is used as input for route reconstruction. The alternative routes  are calculated between the origin and destination points specified in the base path parameter locations.  If both minDeviationDistance and minDeviationTime are set to zero, then these origin and destination points  are expected to be at (or very near) the beginning and end of the reference route, respectively. Intermediate  locations (waypoints) are not supported when using supportingPoints.
        ///
        /// Setting at least one of minDeviationDistance or minDeviationTime to a value greater than zero has the  following consequences:
        ///
        /// *  The origin point of the calculateRoute request must be on (or very near) the input reference route. If  this is not the case, an error is returned. However, the origin point does not need to be at the beginning of  the input reference route (it can be thought of as the current vehicle position on the reference route).
        /// *  The reference route, returned as the first route in the calculateRoute response, will start at the origin  point specified in the calculateRoute request. The initial part of the input reference route up until the  origin point will be excluded from the response.
        /// *  The values of minDeviationDistance and minDeviationTime determine how far alternative routes will be  guaranteed to follow the reference route from the origin point onwards.
        /// *  The route must use departAt.
        /// *  The vehicleHeading is ignored.
        /// </param>
        /// <param name="maxAlternatives"> Number of desired alternative routes to be calculated. Default: 0, minimum: 0 and maximum: 5. </param>
        /// <param name="alternativeType"> Controls the optimality, with respect to the given planning criteria, of the calculated alternatives compared to the reference route. </param>
        /// <param name="minDeviationDistance"> All alternative routes returned will follow the reference route (see section POST Requests) from the origin point of the calculateRoute request for at least this number of meters. Can only be used when reconstructing a route. The minDeviationDistance parameter cannot be used in conjunction with arriveAt. </param>
        /// <param name="minDeviationTime">
        /// All alternative routes returned will follow the reference route (see section POST Requests) from the origin point of the calculateRoute request for at least this number of seconds. Can only be used when reconstructing a route. The minDeviationTime parameter cannot be used in conjunction with arriveAt. Default value is 0. Setting )minDeviationTime_ to a value greater than zero has the following consequences:
        ///   - The origin point of the _calculateRoute_ Request must be on
        ///     (or very near) the input reference route.
        ///     - If this is not the case, an error is returned.
        ///     - However, the origin point does not need to be at the beginning
        ///       of the input reference route (it can be thought of as the current
        ///       vehicle position on the reference route).
        ///   - The reference route, returned as the first route in the _calculateRoute_
        ///     Response, will start at the origin point specified in the _calculateRoute_
        ///     Request. The initial part of the input reference route up until the origin
        ///     point will be excluded from the Response.
        ///   - The values of _minDeviationDistance_ and _minDeviationTime_ determine
        ///     how far alternative routes will be guaranteed to follow the reference
        ///     route from the origin point onwards.
        ///   - The route must use _departAt_.
        ///   - The _vehicleHeading_ is ignored.
        /// </param>
        /// <param name="instructionsType"> If specified, guidance instructions will be returned. Note that the instructionsType parameter cannot be used in conjunction with routeRepresentation=none. </param>
        /// <param name="language"> The language parameter determines the language of the guidance messages. It does not affect proper nouns (the names of streets, plazas, etc.) It has no effect when instructionsType=coded. Allowed values are (a subset of) the IETF language tags described. </param>
        /// <param name="computeBestWaypointOrder"> Re-order the route waypoints using a fast heuristic algorithm to reduce the route length. Yields best results when used in conjunction with routeType _shortest_. Notice that origin and destination are excluded from the optimized waypoint indices. To include origin and destination in the response, please increase all the indices by 1 to account for the origin, and then add the destination as the final index. Possible values are true or false. True computes a better order if possible, but is not allowed to be used in conjunction with maxAlternatives value greater than 0 or in conjunction with circle waypoints. False will use the locations in the given order and not allowed to be used in conjunction with routeRepresentation _none_. </param>
        /// <param name="routeRepresentationForBestOrder"> Specifies the representation of the set of routes provided as response. This parameter value can only be used in conjunction with computeBestOrder=true. </param>
        /// <param name="computeTravelTime"> Specifies whether to return additional travel times using different types of traffic information (none, historic, live) as well as the default best-estimate travel time. </param>
        /// <param name="vehicleHeading"> The directional heading of the vehicle in degrees starting at true North and continuing in clockwise direction. North is 0 degrees, east is 90 degrees, south is 180 degrees, west is 270 degrees. Possible values 0-359. </param>
        /// <param name="report"> Specifies which data should be reported for diagnosis purposes. The only possible value is _effectiveSettings_. Reports the effective parameters or data used when calling the API. In the case of defaulted parameters the default will be reflected where the parameter was not specified by the caller. </param>
        /// <param name="filterSectionType"> Specifies which of the section types is reported in the route response. &lt;br&gt;&lt;br&gt;For example if sectionType = pedestrian the sections which are suited for pedestrians only are returned. Can be specified multiple times in one request, for example, '&amp;sectionType=carTrain&amp;sectionType=pedestrian&amp;sectionType=motorway'. The default sectionType refers to the travelMode input. By default travelMode is set to car. </param>
        /// <param name="arriveAt">
        /// The date and time of arrival at the destination point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified it will be assumed to be that of the destination point.
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `arriveAt` parameter cannot be used in conjunction with `departAt`, `minDeviationDistance` or `minDeviationTime`.
        /// </param>
        /// <param name="departAt">
        /// The date and time of departure from the origin point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified, it will be assumed to be that of the origin point.
        ///   * Default value: now
        ///   * Other value: `dateTime`
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `departAt` parameter cannot be used in conjunction with `arriveAt`.
        /// </param>
        /// <param name="vehicleAxleWeight"> Weight per axle of the vehicle in kg. A value of 0 means that weight restrictions per axle are not considered. </param>
        /// <param name="vehicleLength"> Length of the vehicle in meters. A value of 0 means that length restrictions are not considered. </param>
        /// <param name="vehicleHeight"> Height of the vehicle in meters. A value of 0 means that height restrictions are not considered. </param>
        /// <param name="vehicleWidth"> Width of the vehicle in meters. A value of 0 means that width restrictions are not considered. </param>
        /// <param name="vehicleMaxSpeed">
        /// Maximum speed of the vehicle in km/hour. The max speed in the vehicle profile is used to check whether a vehicle is allowed on motorways.
        ///
        /// * A value of 0 means that an appropriate value for the vehicle will be determined and applied during route planning.
        ///
        /// * A non-zero value may be overridden during route planning. For example, the current traffic flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will again use 60 km/hour.
        /// </param>
        /// <param name="vehicleWeight">
        /// Weight of the vehicle in kilograms.
        ///
        /// * It is mandatory if any of the *Efficiency parameters are set.
        ///
        /// * It must be strictly positive when used in the context of the Consumption Model. Weight restrictions are considered.
        ///
        /// * If no detailed **Consumption Model** is specified and the value of **vehicleWeight** is non-zero, then weight restrictions are considered.
        ///
        /// * In all other cases, this parameter is ignored.
        ///
        /// Sensible Values : for **Combustion Model** : 1600, for **Electric Model** : 1900
        /// </param>
        /// <param name="isCommercialVehicle"> Whether the vehicle is used for commercial purposes. Commercial vehicles may not be allowed to drive on some roads. </param>
        /// <param name="windingness"> Level of turns for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="inclineLevel"> Degree of hilliness for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="travelMode"> The mode of travel for the requested route. If not defined, default is 'car'. Note that the requested travelMode may not be available for the entire route. Where the requested travelMode is not available for a particular section, the travelMode element of the response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van are BETA functionality. Full restriction data is not available in all areas. </param>
        /// <param name="avoid"> Specifies something that the route calculation should try to avoid when determining the route. Can be specified multiple times in one request, for example, '&amp;avoid=motorways&amp;avoid=tollRoads&amp;avoid=ferries'. In Route Range requests, the value alreadyUsedRoads must not be used. </param>
        /// <param name="useTrafficData">
        /// Possible values:
        ///   * true - Do consider all available traffic information during routing
        ///   * false - Ignore current traffic data during routing. Note that although the current traffic data is ignored
        ///   during routing, the effect of historic traffic on effective road speeds is still incorporated.
        /// </param>
        /// <param name="routeType"> The type of route requested. </param>
        /// <param name="vehicleLoadType"> Types of cargo that may be classified as hazardous materials and restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9, plus generic classifications for use in other countries/regions. Values beginning with USHazmat are for US routing while otherHazmat should be used for all other countries/regions. vehicleLoadType can be specified multiple times. This parameter is currently only considered for travelMode=truck. </param>
        /// <param name="vehicleEngineType"> Engine type of the vehicle. When a detailed Consumption Model is specified, it must be consistent with the value of **vehicleEngineType**. </param>
        /// <param name="constantSpeedConsumptionInLitersPerHundredKm">
        ///
        /// Specifies the speed-dependent component of consumption.
        ///
        /// Provided as an unordered list of colon-delimited speed &amp; consumption-rate pairs. The list defines points on a consumption curve. Consumption rates for speeds not in the list are found as follows:
        ///
        ///  * by linear interpolation, if the given speed lies in between two speeds in the list
        ///
        ///  * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by the nearest two points in the list
        ///
        /// The list must contain between 1 and 25 points (inclusive), and may not contain duplicate points for the same speed. If it only contains a single point, then the consumption rate of that point is used without further processing.
        ///
        /// Consumption specified for the largest speed must be greater than or equal to that of the penultimate largest speed. This ensures that extrapolation does not lead to negative consumption rates.
        ///
        /// Similarly, consumption values specified for the two smallest speeds in the list cannot lead to a negative consumption rate for any smaller speed.
        ///
        /// The valid range for the consumption values(expressed in l/100km) is between 0.01 and 100000.0.
        ///
        /// Sensible Values : 50,6.3:130,11.5
        ///
        /// **Note** : This parameter is required for **The Combustion Consumption Model**.
        /// </param>
        /// <param name="currentFuelInLiters">
        /// Specifies the current supply of fuel in liters.
        ///
        /// Sensible Values : 55
        /// </param>
        /// <param name="auxiliaryPowerInLitersPerHour">
        /// Specifies the amount of fuel consumed for sustaining auxiliary systems of the vehicle, in liters per hour.
        ///
        /// It can be used to specify consumption due to devices and systems such as AC systems, radio, heating, etc.
        ///
        /// Sensible Values : 0.2
        /// </param>
        /// <param name="fuelEnergyDensityInMegajoulesPerLiter">
        /// Specifies the amount of chemical energy stored in one liter of fuel in megajoules (MJ). It is used in conjunction with the ***Efficiency** parameters for conversions between saved or consumed energy and fuel. For example, energy density is 34.2 MJ/l for gasoline, and 35.8 MJ/l for Diesel fuel.
        ///
        /// This parameter is required if any ***Efficiency** parameter is set.
        ///
        /// Sensible Values : 34.2
        /// </param>
        /// <param name="accelerationEfficiency">
        /// Specifies the efficiency of converting chemical energy stored in fuel to kinetic energy when the vehicle accelerates _(i.e. KineticEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed_ is obtained by converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **decelerationEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**decelerationEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.33, for **Electric Model** : 0.66
        /// </param>
        /// <param name="decelerationEfficiency">
        /// Specifies the efficiency of converting kinetic energy to saved (not consumed) fuel when the vehicle decelerates _(i.e. ChemicalEnergySaved/KineticEnergyLost). ChemicalEnergySaved_ is obtained by converting saved (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **accelerationEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**accelerationEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.83, for **Electric Model** : 0.91
        /// </param>
        /// <param name="uphillEfficiency">
        /// Specifies the efficiency of converting chemical energy stored in fuel to potential energy when the vehicle gains elevation _(i.e. PotentialEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed_ is obtained by converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **downhillEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**downhillEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.27, for **Electric Model** : 0.74
        /// </param>
        /// <param name="downhillEfficiency">
        /// Specifies the efficiency of converting potential energy to saved (not consumed) fuel when the vehicle loses elevation _(i.e. ChemicalEnergySaved/PotentialEnergyLost). ChemicalEnergySaved_ is obtained by converting saved (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **uphillEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**uphillEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.51, for **Electric Model** : 0.73
        /// </param>
        /// <param name="constantSpeedConsumptionInKwHPerHundredKm">
        /// Specifies the speed-dependent component of consumption.
        ///
        /// Provided as an unordered list of speed/consumption-rate pairs. The list defines points on a consumption curve. Consumption rates for speeds not in the list are found as follows:
        ///
        /// * by linear interpolation, if the given speed lies in between two speeds in the list
        ///
        /// * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by the nearest two points in the list
        ///
        /// The list must contain between 1 and 25 points (inclusive), and may not contain duplicate points for the same speed. If it only contains a single point, then the consumption rate of that point is used without further processing.
        ///
        /// Consumption specified for the largest speed must be greater than or equal to that of the penultimate largest speed. This ensures that extrapolation does not lead to negative consumption rates.
        ///
        /// Similarly, consumption values specified for the two smallest speeds in the list cannot lead to a negative consumption rate for any smaller  speed.
        ///
        /// The valid range for the consumption values(expressed in kWh/100km) is between 0.01 and 100000.0.
        ///
        /// Sensible Values : 50,8.2:130,21.3
        ///
        /// This parameter is required for **Electric consumption model**.
        /// </param>
        /// <param name="currentChargeInKwH">
        /// Specifies the current electric energy supply in kilowatt hours (kWh).
        ///
        /// This parameter co-exists with **maxChargeInkWh** parameter.
        ///
        /// The range of values allowed are 0.0 to **maxChargeInkWh**.
        ///
        /// Sensible Values : 43
        /// </param>
        /// <param name="maxChargeInKwH">
        /// Specifies the maximum electric energy supply in kilowatt hours (kWh) that may be stored in the vehicle's battery.
        ///
        /// This parameter co-exists with **currentChargeInkWh** parameter.
        ///
        /// Minimum value has to be greater than or equal to **currentChargeInkWh**.
        ///
        /// Sensible Values : 85
        /// </param>
        /// <param name="auxiliaryPowerInKw">
        /// Specifies the amount of power consumed for sustaining auxiliary systems, in kilowatts (kW).
        ///
        /// It can be used to specify consumption due to devices and systems such as AC systems, radio, heating, etc.
        ///
        /// Sensible Values : 1.7
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="routePoints"/> or <paramref name="routeDirectionParameters"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Post Route Directions` API is an HTTP `POST` request that returns a route between an origin and a destination, passing through waypoints if they are specified. The route will take into account factors such as current traffic and the typical road speeds on the requested day of the week and time of day.
        ///
        /// Information returned includes the distance, estimated travel time, and a representation of the route geometry. Additional routing information such as optimized waypoint order or turn by turn instructions is also available, depending on the options selected.
        ///
        /// Routing service provides a set of parameters for a detailed description of a vehicle-specific Consumption Model. Please check [Consumption Model](https://docs.microsoft.com/azure/azure-maps/consumption-model) for detailed explanation of the concepts and parameters involved.
        /// </remarks>
        public Response<RouteDirections> GetRouteDirectionsWithAdditionalParameters(ResponseFormat format, string routePoints, RouteDirectionParameters routeDirectionParameters, int? maxAlternatives = null, AlternativeRouteType? alternativeType = null, int? minDeviationDistance = null, int? minDeviationTime = null, RouteInstructionsType? instructionsType = null, string language = null, bool? computeBestWaypointOrder = null, RouteRepresentationForBestOrder? routeRepresentationForBestOrder = null, TravelTimeType? computeTravelTime = null, int? vehicleHeading = null, Report? report = null, IEnumerable<SectionType> filterSectionType = null, DateTimeOffset? arriveAt = null, DateTimeOffset? departAt = null, int? vehicleAxleWeight = null, double? vehicleLength = null, double? vehicleHeight = null, double? vehicleWidth = null, int? vehicleMaxSpeed = null, int? vehicleWeight = null, bool? isCommercialVehicle = null, WindingnessLevel? windingness = null, InclineLevel? inclineLevel = null, TravelMode? travelMode = null, IEnumerable<RouteAvoidType> avoid = null, bool? useTrafficData = null, RouteType? routeType = null, VehicleLoadType? vehicleLoadType = null, VehicleEngineType? vehicleEngineType = null, string constantSpeedConsumptionInLitersPerHundredKm = null, double? currentFuelInLiters = null, double? auxiliaryPowerInLitersPerHour = null, double? fuelEnergyDensityInMegajoulesPerLiter = null, double? accelerationEfficiency = null, double? decelerationEfficiency = null, double? uphillEfficiency = null, double? downhillEfficiency = null, string constantSpeedConsumptionInKwHPerHundredKm = null, double? currentChargeInKwH = null, double? maxChargeInKwH = null, double? auxiliaryPowerInKw = null, CancellationToken cancellationToken = default)
        {
            if (routePoints == null)
            {
                throw new ArgumentNullException(nameof(routePoints));
            }
            if (routeDirectionParameters == null)
            {
                throw new ArgumentNullException(nameof(routeDirectionParameters));
            }

            using var message = CreateGetRouteDirectionsWithAdditionalParametersRequest(format, routePoints, routeDirectionParameters, maxAlternatives, alternativeType, minDeviationDistance, minDeviationTime, instructionsType, language, computeBestWaypointOrder, routeRepresentationForBestOrder, computeTravelTime, vehicleHeading, report, filterSectionType, arriveAt, departAt, vehicleAxleWeight, vehicleLength, vehicleHeight, vehicleWidth, vehicleMaxSpeed, vehicleWeight, isCommercialVehicle, windingness, inclineLevel, travelMode, avoid, useTrafficData, routeType, vehicleLoadType, vehicleEngineType, constantSpeedConsumptionInLitersPerHundredKm, currentFuelInLiters, auxiliaryPowerInLitersPerHour, fuelEnergyDensityInMegajoulesPerLiter, accelerationEfficiency, decelerationEfficiency, uphillEfficiency, downhillEfficiency, constantSpeedConsumptionInKwHPerHundredKm, currentChargeInKwH, maxChargeInKwH, auxiliaryPowerInKw);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RouteDirections value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RouteDirections.DeserializeRouteDirections(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetRouteRangeRequest(ResponseFormat format, IEnumerable<double> query, double? fuelBudgetInLiters, double? energyBudgetInKwH, double? timeBudgetInSec, double? distanceBudgetInMeters, DateTimeOffset? departAt, RouteType? routeType, bool? useTrafficData, IEnumerable<RouteAvoidType> avoid, TravelMode? travelMode, InclineLevel? inclineLevel, WindingnessLevel? windingness, int? vehicleAxleWeight, double? vehicleWidth, double? vehicleHeight, double? vehicleLength, int? vehicleMaxSpeed, int? vehicleWeight, bool? isCommercialVehicle, VehicleLoadType? vehicleLoadType, VehicleEngineType? vehicleEngineType, string constantSpeedConsumptionInLitersPerHundredKm, double? currentFuelInLiters, double? auxiliaryPowerInLitersPerHour, double? fuelEnergyDensityInMegajoulesPerLiter, double? accelerationEfficiency, double? decelerationEfficiency, double? uphillEfficiency, double? downhillEfficiency, string constantSpeedConsumptionInKwHPerHundredKm, double? currentChargeInKwH, double? maxChargeInKwH, double? auxiliaryPowerInKw)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/route/range/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (query != null && !(query is Common.ChangeTrackingList<double> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("query", query, ",", true);
            }
            if (fuelBudgetInLiters != null)
            {
                uri.AppendQuery("fuelBudgetInLiters", fuelBudgetInLiters.Value, true);
            }
            if (energyBudgetInKwH != null)
            {
                uri.AppendQuery("energyBudgetInkWh", energyBudgetInKwH.Value, true);
            }
            if (timeBudgetInSec != null)
            {
                uri.AppendQuery("timeBudgetInSec", timeBudgetInSec.Value, true);
            }
            if (distanceBudgetInMeters != null)
            {
                uri.AppendQuery("distanceBudgetInMeters", distanceBudgetInMeters.Value, true);
            }
            if (departAt != null)
            {
                uri.AppendQuery("departAt", departAt.Value, "O", true);
            }
            if (routeType != null)
            {
                uri.AppendQuery("routeType", routeType.Value.ToString(), true);
            }
            if (useTrafficData != null)
            {
                uri.AppendQuery("traffic", useTrafficData.Value, true);
            }
            if (avoid != null && !(avoid is Common.ChangeTrackingList<RouteAvoidType> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                foreach (var param in avoid)
                {
                    uri.AppendQuery("avoid", param.ToString(), true);
                }
            }
            if (travelMode != null)
            {
                uri.AppendQuery("travelMode", travelMode.Value.ToString(), true);
            }
            if (inclineLevel != null)
            {
                uri.AppendQuery("hilliness", inclineLevel.Value.ToString(), true);
            }
            if (windingness != null)
            {
                uri.AppendQuery("windingness", windingness.Value.ToString(), true);
            }
            if (vehicleAxleWeight != null)
            {
                uri.AppendQuery("vehicleAxleWeight", vehicleAxleWeight.Value, true);
            }
            if (vehicleWidth != null)
            {
                uri.AppendQuery("vehicleWidth", vehicleWidth.Value, true);
            }
            if (vehicleHeight != null)
            {
                uri.AppendQuery("vehicleHeight", vehicleHeight.Value, true);
            }
            if (vehicleLength != null)
            {
                uri.AppendQuery("vehicleLength", vehicleLength.Value, true);
            }
            if (vehicleMaxSpeed != null)
            {
                uri.AppendQuery("vehicleMaxSpeed", vehicleMaxSpeed.Value, true);
            }
            if (vehicleWeight != null)
            {
                uri.AppendQuery("vehicleWeight", vehicleWeight.Value, true);
            }
            if (isCommercialVehicle != null)
            {
                uri.AppendQuery("vehicleCommercial", isCommercialVehicle.Value, true);
            }
            if (vehicleLoadType != null)
            {
                uri.AppendQuery("vehicleLoadType", vehicleLoadType.Value.ToString(), true);
            }
            if (vehicleEngineType != null)
            {
                uri.AppendQuery("vehicleEngineType", vehicleEngineType.Value.ToString(), true);
            }
            if (constantSpeedConsumptionInLitersPerHundredKm != null)
            {
                uri.AppendQuery("constantSpeedConsumptionInLitersPerHundredkm", constantSpeedConsumptionInLitersPerHundredKm, true);
            }
            if (currentFuelInLiters != null)
            {
                uri.AppendQuery("currentFuelInLiters", currentFuelInLiters.Value, true);
            }
            if (auxiliaryPowerInLitersPerHour != null)
            {
                uri.AppendQuery("auxiliaryPowerInLitersPerHour", auxiliaryPowerInLitersPerHour.Value, true);
            }
            if (fuelEnergyDensityInMegajoulesPerLiter != null)
            {
                uri.AppendQuery("fuelEnergyDensityInMJoulesPerLiter", fuelEnergyDensityInMegajoulesPerLiter.Value, true);
            }
            if (accelerationEfficiency != null)
            {
                uri.AppendQuery("accelerationEfficiency", accelerationEfficiency.Value, true);
            }
            if (decelerationEfficiency != null)
            {
                uri.AppendQuery("decelerationEfficiency", decelerationEfficiency.Value, true);
            }
            if (uphillEfficiency != null)
            {
                uri.AppendQuery("uphillEfficiency", uphillEfficiency.Value, true);
            }
            if (downhillEfficiency != null)
            {
                uri.AppendQuery("downhillEfficiency", downhillEfficiency.Value, true);
            }
            if (constantSpeedConsumptionInKwHPerHundredKm != null)
            {
                uri.AppendQuery("constantSpeedConsumptionInkWhPerHundredkm", constantSpeedConsumptionInKwHPerHundredKm, true);
            }
            if (currentChargeInKwH != null)
            {
                uri.AppendQuery("currentChargeInkWh", currentChargeInKwH.Value, true);
            }
            if (maxChargeInKwH != null)
            {
                uri.AppendQuery("maxChargeInkWh", maxChargeInKwH.Value, true);
            }
            if (auxiliaryPowerInKw != null)
            {
                uri.AppendQuery("auxiliaryPowerInkW", auxiliaryPowerInKw.Value, true);
            }
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Use to create a map that depicts the area accessible from a given point within a certain threshold based on time, distance or fuel capacity. </summary>
        /// <param name="format"> Desired format of the response. Value can be either _json_ or _xml_. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="query"> The Coordinate from which the range calculation should start. </param>
        /// <param name="fuelBudgetInLiters"> Fuel budget in liters that determines maximal range which can be travelled using the specified Combustion Consumption Model.&lt;br&gt; When fuelBudgetInLiters is used, it is mandatory to specify a detailed  Combustion Consumption Model.&lt;br&gt; Exactly one budget (fuelBudgetInLiters, energyBudgetInkWh, timeBudgetInSec, or distanceBudgetInMeters) must be used. </param>
        /// <param name="energyBudgetInKwH"> Electric energy budget in kilowatt hours (kWh) that determines maximal range which can be travelled using the specified Electric Consumption Model.&lt;br&gt; When energyBudgetInkWh is used, it is mandatory to specify a detailed Electric Consumption Model.&lt;br&gt; Exactly one budget (fuelBudgetInLiters, energyBudgetInkWh, timeBudgetInSec, or distanceBudgetInMeters) must be used. </param>
        /// <param name="timeBudgetInSec"> Time budget in seconds that determines maximal range which can be travelled using driving time. The Consumption Model will only affect the range when routeType is eco.&lt;br&gt; Exactly one budget (fuelBudgetInLiters, energyBudgetInkWh, timeBudgetInSec, or distanceBudgetInMeters) must be used. </param>
        /// <param name="distanceBudgetInMeters"> Distance budget in meters that determines maximal range which can be travelled using driving distance.  The Consumption Model will only affect the range when routeType is eco.&lt;br&gt; Exactly one budget (fuelBudgetInLiters, energyBudgetInkWh, timeBudgetInSec, or distanceBudgetInMeters) must be used. </param>
        /// <param name="departAt">
        /// The date and time of departure from the origin point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified, it will be assumed to be that of the origin point.
        ///   * Default value: now
        ///   * Other value: `dateTime`
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `departAt` parameter cannot be used in conjunction with `arriveAt`.
        /// </param>
        /// <param name="routeType"> The type of route requested. </param>
        /// <param name="useTrafficData">
        /// Possible values:
        ///   * true - Do consider all available traffic information during routing
        ///   * false - Ignore current traffic data during routing. Note that although the current traffic data is ignored
        ///   during routing, the effect of historic traffic on effective road speeds is still incorporated.
        /// </param>
        /// <param name="avoid"> Specifies something that the route calculation should try to avoid when determining the route. Can be specified multiple times in one request, for example, '&amp;avoid=motorways&amp;avoid=tollRoads&amp;avoid=ferries'. In Route Range requests, the value alreadyUsedRoads must not be used. </param>
        /// <param name="travelMode"> The mode of travel for the requested route. If not defined, default is 'car'. Note that the requested travelMode may not be available for the entire route. Where the requested travelMode is not available for a particular section, the travelMode element of the response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van are BETA functionality. Full restriction data is not available in all areas. </param>
        /// <param name="inclineLevel"> Degree of hilliness for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="windingness"> Level of turns for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="vehicleAxleWeight"> Weight per axle of the vehicle in kg. A value of 0 means that weight restrictions per axle are not considered. </param>
        /// <param name="vehicleWidth"> Width of the vehicle in meters. A value of 0 means that width restrictions are not considered. </param>
        /// <param name="vehicleHeight"> Height of the vehicle in meters. A value of 0 means that height restrictions are not considered. </param>
        /// <param name="vehicleLength"> Length of the vehicle in meters. A value of 0 means that length restrictions are not considered. </param>
        /// <param name="vehicleMaxSpeed">
        /// Maximum speed of the vehicle in km/hour. The max speed in the vehicle profile is used to check whether a vehicle is allowed on motorways.
        ///
        /// * A value of 0 means that an appropriate value for the vehicle will be determined and applied during route planning.
        ///
        /// * A non-zero value may be overridden during route planning. For example, the current traffic flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will again use 60 km/hour.
        /// </param>
        /// <param name="vehicleWeight">
        /// Weight of the vehicle in kilograms.
        ///
        /// * It is mandatory if any of the *Efficiency parameters are set.
        ///
        /// * It must be strictly positive when used in the context of the Consumption Model. Weight restrictions are considered.
        ///
        /// * If no detailed **Consumption Model** is specified and the value of **vehicleWeight** is non-zero, then weight restrictions are considered.
        ///
        /// * In all other cases, this parameter is ignored.
        ///
        /// Sensible Values : for **Combustion Model** : 1600, for **Electric Model** : 1900
        /// </param>
        /// <param name="isCommercialVehicle"> Whether the vehicle is used for commercial purposes. Commercial vehicles may not be allowed to drive on some roads. </param>
        /// <param name="vehicleLoadType"> Types of cargo that may be classified as hazardous materials and restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9, plus generic classifications for use in other countries/regions. Values beginning with USHazmat are for US routing while otherHazmat should be used for all other countries/regions. vehicleLoadType can be specified multiple times. This parameter is currently only considered for travelMode=truck. </param>
        /// <param name="vehicleEngineType"> Engine type of the vehicle. When a detailed Consumption Model is specified, it must be consistent with the value of **vehicleEngineType**. </param>
        /// <param name="constantSpeedConsumptionInLitersPerHundredKm">
        ///
        /// Specifies the speed-dependent component of consumption.
        ///
        /// Provided as an unordered list of colon-delimited speed &amp; consumption-rate pairs. The list defines points on a consumption curve. Consumption rates for speeds not in the list are found as follows:
        ///
        ///  * by linear interpolation, if the given speed lies in between two speeds in the list
        ///
        ///  * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by the nearest two points in the list
        ///
        /// The list must contain between 1 and 25 points (inclusive), and may not contain duplicate points for the same speed. If it only contains a single point, then the consumption rate of that point is used without further processing.
        ///
        /// Consumption specified for the largest speed must be greater than or equal to that of the penultimate largest speed. This ensures that extrapolation does not lead to negative consumption rates.
        ///
        /// Similarly, consumption values specified for the two smallest speeds in the list cannot lead to a negative consumption rate for any smaller speed.
        ///
        /// The valid range for the consumption values(expressed in l/100km) is between 0.01 and 100000.0.
        ///
        /// Sensible Values : 50,6.3:130,11.5
        ///
        /// **Note** : This parameter is required for **The Combustion Consumption Model**.
        /// </param>
        /// <param name="currentFuelInLiters">
        /// Specifies the current supply of fuel in liters.
        ///
        /// Sensible Values : 55
        /// </param>
        /// <param name="auxiliaryPowerInLitersPerHour">
        /// Specifies the amount of fuel consumed for sustaining auxiliary systems of the vehicle, in liters per hour.
        ///
        /// It can be used to specify consumption due to devices and systems such as AC systems, radio, heating, etc.
        ///
        /// Sensible Values : 0.2
        /// </param>
        /// <param name="fuelEnergyDensityInMegajoulesPerLiter">
        /// Specifies the amount of chemical energy stored in one liter of fuel in megajoules (MJ). It is used in conjunction with the ***Efficiency** parameters for conversions between saved or consumed energy and fuel. For example, energy density is 34.2 MJ/l for gasoline, and 35.8 MJ/l for Diesel fuel.
        ///
        /// This parameter is required if any ***Efficiency** parameter is set.
        ///
        /// Sensible Values : 34.2
        /// </param>
        /// <param name="accelerationEfficiency">
        /// Specifies the efficiency of converting chemical energy stored in fuel to kinetic energy when the vehicle accelerates _(i.e. KineticEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed_ is obtained by converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **decelerationEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**decelerationEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.33, for **Electric Model** : 0.66
        /// </param>
        /// <param name="decelerationEfficiency">
        /// Specifies the efficiency of converting kinetic energy to saved (not consumed) fuel when the vehicle decelerates _(i.e. ChemicalEnergySaved/KineticEnergyLost). ChemicalEnergySaved_ is obtained by converting saved (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **accelerationEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**accelerationEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.83, for **Electric Model** : 0.91
        /// </param>
        /// <param name="uphillEfficiency">
        /// Specifies the efficiency of converting chemical energy stored in fuel to potential energy when the vehicle gains elevation _(i.e. PotentialEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed_ is obtained by converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **downhillEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**downhillEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.27, for **Electric Model** : 0.74
        /// </param>
        /// <param name="downhillEfficiency">
        /// Specifies the efficiency of converting potential energy to saved (not consumed) fuel when the vehicle loses elevation _(i.e. ChemicalEnergySaved/PotentialEnergyLost). ChemicalEnergySaved_ is obtained by converting saved (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **uphillEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**uphillEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.51, for **Electric Model** : 0.73
        /// </param>
        /// <param name="constantSpeedConsumptionInKwHPerHundredKm">
        /// Specifies the speed-dependent component of consumption.
        ///
        /// Provided as an unordered list of speed/consumption-rate pairs. The list defines points on a consumption curve. Consumption rates for speeds not in the list are found as follows:
        ///
        /// * by linear interpolation, if the given speed lies in between two speeds in the list
        ///
        /// * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by the nearest two points in the list
        ///
        /// The list must contain between 1 and 25 points (inclusive), and may not contain duplicate points for the same speed. If it only contains a single point, then the consumption rate of that point is used without further processing.
        ///
        /// Consumption specified for the largest speed must be greater than or equal to that of the penultimate largest speed. This ensures that extrapolation does not lead to negative consumption rates.
        ///
        /// Similarly, consumption values specified for the two smallest speeds in the list cannot lead to a negative consumption rate for any smaller  speed.
        ///
        /// The valid range for the consumption values(expressed in kWh/100km) is between 0.01 and 100000.0.
        ///
        /// Sensible Values : 50,8.2:130,21.3
        ///
        /// This parameter is required for **Electric consumption model**.
        /// </param>
        /// <param name="currentChargeInKwH">
        /// Specifies the current electric energy supply in kilowatt hours (kWh).
        ///
        /// This parameter co-exists with **maxChargeInkWh** parameter.
        ///
        /// The range of values allowed are 0.0 to **maxChargeInkWh**.
        ///
        /// Sensible Values : 43
        /// </param>
        /// <param name="maxChargeInKwH">
        /// Specifies the maximum electric energy supply in kilowatt hours (kWh) that may be stored in the vehicle's battery.
        ///
        /// This parameter co-exists with **currentChargeInkWh** parameter.
        ///
        /// Minimum value has to be greater than or equal to **currentChargeInkWh**.
        ///
        /// Sensible Values : 85
        /// </param>
        /// <param name="auxiliaryPowerInKw">
        /// Specifies the amount of power consumed for sustaining auxiliary systems, in kilowatts (kW).
        ///
        /// It can be used to specify consumption due to devices and systems such as AC systems, radio, heating, etc.
        ///
        /// Sensible Values : 1.7
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="query"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Route Range` (Isochrone) API is an HTTP `GET` request that will calculate a set of locations that can be reached from the origin point based on fuel, energy, time or distance budget that is specified. A polygon boundary (or Isochrone) is returned in a counterclockwise  orientation as well as the precise polygon center which was the result of the origin point.
        ///
        /// The returned polygon can be used for further processing such as  [Search Inside Geometry](/rest/api/maps/search/post-search-inside-geometry) to  search for POIs within the provided isochrone.
        /// </remarks>
        public async Task<Response<RouteRangeResult>> GetRouteRangeAsync(ResponseFormat format, IEnumerable<double> query, double? fuelBudgetInLiters = null, double? energyBudgetInKwH = null, double? timeBudgetInSec = null, double? distanceBudgetInMeters = null, DateTimeOffset? departAt = null, RouteType? routeType = null, bool? useTrafficData = null, IEnumerable<RouteAvoidType> avoid = null, TravelMode? travelMode = null, InclineLevel? inclineLevel = null, WindingnessLevel? windingness = null, int? vehicleAxleWeight = null, double? vehicleWidth = null, double? vehicleHeight = null, double? vehicleLength = null, int? vehicleMaxSpeed = null, int? vehicleWeight = null, bool? isCommercialVehicle = null, VehicleLoadType? vehicleLoadType = null, VehicleEngineType? vehicleEngineType = null, string constantSpeedConsumptionInLitersPerHundredKm = null, double? currentFuelInLiters = null, double? auxiliaryPowerInLitersPerHour = null, double? fuelEnergyDensityInMegajoulesPerLiter = null, double? accelerationEfficiency = null, double? decelerationEfficiency = null, double? uphillEfficiency = null, double? downhillEfficiency = null, string constantSpeedConsumptionInKwHPerHundredKm = null, double? currentChargeInKwH = null, double? maxChargeInKwH = null, double? auxiliaryPowerInKw = null, CancellationToken cancellationToken = default)
        {
            if (query == null)
            {
                throw new ArgumentNullException(nameof(query));
            }

            using var message = CreateGetRouteRangeRequest(format, query, fuelBudgetInLiters, energyBudgetInKwH, timeBudgetInSec, distanceBudgetInMeters, departAt, routeType, useTrafficData, avoid, travelMode, inclineLevel, windingness, vehicleAxleWeight, vehicleWidth, vehicleHeight, vehicleLength, vehicleMaxSpeed, vehicleWeight, isCommercialVehicle, vehicleLoadType, vehicleEngineType, constantSpeedConsumptionInLitersPerHundredKm, currentFuelInLiters, auxiliaryPowerInLitersPerHour, fuelEnergyDensityInMegajoulesPerLiter, accelerationEfficiency, decelerationEfficiency, uphillEfficiency, downhillEfficiency, constantSpeedConsumptionInKwHPerHundredKm, currentChargeInKwH, maxChargeInKwH, auxiliaryPowerInKw);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RouteRangeResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RouteRangeResult.DeserializeRouteRangeResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to create a map that depicts the area accessible from a given point within a certain threshold based on time, distance or fuel capacity. </summary>
        /// <param name="format"> Desired format of the response. Value can be either _json_ or _xml_. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="query"> The Coordinate from which the range calculation should start. </param>
        /// <param name="fuelBudgetInLiters"> Fuel budget in liters that determines maximal range which can be travelled using the specified Combustion Consumption Model.&lt;br&gt; When fuelBudgetInLiters is used, it is mandatory to specify a detailed  Combustion Consumption Model.&lt;br&gt; Exactly one budget (fuelBudgetInLiters, energyBudgetInkWh, timeBudgetInSec, or distanceBudgetInMeters) must be used. </param>
        /// <param name="energyBudgetInKwH"> Electric energy budget in kilowatt hours (kWh) that determines maximal range which can be travelled using the specified Electric Consumption Model.&lt;br&gt; When energyBudgetInkWh is used, it is mandatory to specify a detailed Electric Consumption Model.&lt;br&gt; Exactly one budget (fuelBudgetInLiters, energyBudgetInkWh, timeBudgetInSec, or distanceBudgetInMeters) must be used. </param>
        /// <param name="timeBudgetInSec"> Time budget in seconds that determines maximal range which can be travelled using driving time. The Consumption Model will only affect the range when routeType is eco.&lt;br&gt; Exactly one budget (fuelBudgetInLiters, energyBudgetInkWh, timeBudgetInSec, or distanceBudgetInMeters) must be used. </param>
        /// <param name="distanceBudgetInMeters"> Distance budget in meters that determines maximal range which can be travelled using driving distance.  The Consumption Model will only affect the range when routeType is eco.&lt;br&gt; Exactly one budget (fuelBudgetInLiters, energyBudgetInkWh, timeBudgetInSec, or distanceBudgetInMeters) must be used. </param>
        /// <param name="departAt">
        /// The date and time of departure from the origin point formatted as a `dateTime` value as defined in [RFC 3339, section 5.6](https://www.rfc-editor.org/rfc/rfc3339#section-5.6), with an optional time zone offset. When a time zone offset is not specified, it will be assumed to be that of the origin point.
        ///   * Default value: now
        ///   * Other value: `dateTime`
        ///
        /// Examples:
        ///   * 2023-12-19T16:39:57
        ///   * 2023-12-19T16:39:57-08:00
        ///
        /// The `departAt` parameter cannot be used in conjunction with `arriveAt`.
        /// </param>
        /// <param name="routeType"> The type of route requested. </param>
        /// <param name="useTrafficData">
        /// Possible values:
        ///   * true - Do consider all available traffic information during routing
        ///   * false - Ignore current traffic data during routing. Note that although the current traffic data is ignored
        ///   during routing, the effect of historic traffic on effective road speeds is still incorporated.
        /// </param>
        /// <param name="avoid"> Specifies something that the route calculation should try to avoid when determining the route. Can be specified multiple times in one request, for example, '&amp;avoid=motorways&amp;avoid=tollRoads&amp;avoid=ferries'. In Route Range requests, the value alreadyUsedRoads must not be used. </param>
        /// <param name="travelMode"> The mode of travel for the requested route. If not defined, default is 'car'. Note that the requested travelMode may not be available for the entire route. Where the requested travelMode is not available for a particular section, the travelMode element of the response for that section will be "other". Note that travel modes bus, motorcycle, taxi and van are BETA functionality. Full restriction data is not available in all areas. </param>
        /// <param name="inclineLevel"> Degree of hilliness for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="windingness"> Level of turns for thrilling route. This parameter can only be used in conjunction with `routeType`=thrilling. </param>
        /// <param name="vehicleAxleWeight"> Weight per axle of the vehicle in kg. A value of 0 means that weight restrictions per axle are not considered. </param>
        /// <param name="vehicleWidth"> Width of the vehicle in meters. A value of 0 means that width restrictions are not considered. </param>
        /// <param name="vehicleHeight"> Height of the vehicle in meters. A value of 0 means that height restrictions are not considered. </param>
        /// <param name="vehicleLength"> Length of the vehicle in meters. A value of 0 means that length restrictions are not considered. </param>
        /// <param name="vehicleMaxSpeed">
        /// Maximum speed of the vehicle in km/hour. The max speed in the vehicle profile is used to check whether a vehicle is allowed on motorways.
        ///
        /// * A value of 0 means that an appropriate value for the vehicle will be determined and applied during route planning.
        ///
        /// * A non-zero value may be overridden during route planning. For example, the current traffic flow is 60 km/hour. If the vehicle  maximum speed is set to 50 km/hour, the routing engine will consider 60 km/hour as this is the current situation.  If the maximum speed of the vehicle is provided as 80 km/hour but the current traffic flow is 60 km/hour, then routing engine will again use 60 km/hour.
        /// </param>
        /// <param name="vehicleWeight">
        /// Weight of the vehicle in kilograms.
        ///
        /// * It is mandatory if any of the *Efficiency parameters are set.
        ///
        /// * It must be strictly positive when used in the context of the Consumption Model. Weight restrictions are considered.
        ///
        /// * If no detailed **Consumption Model** is specified and the value of **vehicleWeight** is non-zero, then weight restrictions are considered.
        ///
        /// * In all other cases, this parameter is ignored.
        ///
        /// Sensible Values : for **Combustion Model** : 1600, for **Electric Model** : 1900
        /// </param>
        /// <param name="isCommercialVehicle"> Whether the vehicle is used for commercial purposes. Commercial vehicles may not be allowed to drive on some roads. </param>
        /// <param name="vehicleLoadType"> Types of cargo that may be classified as hazardous materials and restricted from some roads. Available vehicleLoadType values are US Hazmat classes 1 through 9, plus generic classifications for use in other countries/regions. Values beginning with USHazmat are for US routing while otherHazmat should be used for all other countries/regions. vehicleLoadType can be specified multiple times. This parameter is currently only considered for travelMode=truck. </param>
        /// <param name="vehicleEngineType"> Engine type of the vehicle. When a detailed Consumption Model is specified, it must be consistent with the value of **vehicleEngineType**. </param>
        /// <param name="constantSpeedConsumptionInLitersPerHundredKm">
        ///
        /// Specifies the speed-dependent component of consumption.
        ///
        /// Provided as an unordered list of colon-delimited speed &amp; consumption-rate pairs. The list defines points on a consumption curve. Consumption rates for speeds not in the list are found as follows:
        ///
        ///  * by linear interpolation, if the given speed lies in between two speeds in the list
        ///
        ///  * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by the nearest two points in the list
        ///
        /// The list must contain between 1 and 25 points (inclusive), and may not contain duplicate points for the same speed. If it only contains a single point, then the consumption rate of that point is used without further processing.
        ///
        /// Consumption specified for the largest speed must be greater than or equal to that of the penultimate largest speed. This ensures that extrapolation does not lead to negative consumption rates.
        ///
        /// Similarly, consumption values specified for the two smallest speeds in the list cannot lead to a negative consumption rate for any smaller speed.
        ///
        /// The valid range for the consumption values(expressed in l/100km) is between 0.01 and 100000.0.
        ///
        /// Sensible Values : 50,6.3:130,11.5
        ///
        /// **Note** : This parameter is required for **The Combustion Consumption Model**.
        /// </param>
        /// <param name="currentFuelInLiters">
        /// Specifies the current supply of fuel in liters.
        ///
        /// Sensible Values : 55
        /// </param>
        /// <param name="auxiliaryPowerInLitersPerHour">
        /// Specifies the amount of fuel consumed for sustaining auxiliary systems of the vehicle, in liters per hour.
        ///
        /// It can be used to specify consumption due to devices and systems such as AC systems, radio, heating, etc.
        ///
        /// Sensible Values : 0.2
        /// </param>
        /// <param name="fuelEnergyDensityInMegajoulesPerLiter">
        /// Specifies the amount of chemical energy stored in one liter of fuel in megajoules (MJ). It is used in conjunction with the ***Efficiency** parameters for conversions between saved or consumed energy and fuel. For example, energy density is 34.2 MJ/l for gasoline, and 35.8 MJ/l for Diesel fuel.
        ///
        /// This parameter is required if any ***Efficiency** parameter is set.
        ///
        /// Sensible Values : 34.2
        /// </param>
        /// <param name="accelerationEfficiency">
        /// Specifies the efficiency of converting chemical energy stored in fuel to kinetic energy when the vehicle accelerates _(i.e. KineticEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed_ is obtained by converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **decelerationEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**decelerationEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.33, for **Electric Model** : 0.66
        /// </param>
        /// <param name="decelerationEfficiency">
        /// Specifies the efficiency of converting kinetic energy to saved (not consumed) fuel when the vehicle decelerates _(i.e. ChemicalEnergySaved/KineticEnergyLost). ChemicalEnergySaved_ is obtained by converting saved (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **accelerationEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**accelerationEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.83, for **Electric Model** : 0.91
        /// </param>
        /// <param name="uphillEfficiency">
        /// Specifies the efficiency of converting chemical energy stored in fuel to potential energy when the vehicle gains elevation _(i.e. PotentialEnergyGained/ChemicalEnergyConsumed). ChemicalEnergyConsumed_ is obtained by converting consumed fuel to chemical energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **downhillEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**downhillEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.27, for **Electric Model** : 0.74
        /// </param>
        /// <param name="downhillEfficiency">
        /// Specifies the efficiency of converting potential energy to saved (not consumed) fuel when the vehicle loses elevation _(i.e. ChemicalEnergySaved/PotentialEnergyLost). ChemicalEnergySaved_ is obtained by converting saved (not consumed) fuel to energy using **fuelEnergyDensityInMJoulesPerLiter**.
        ///
        /// Must be paired with **uphillEfficiency**.
        ///
        /// The range of values allowed are 0.0 to 1/**uphillEfficiency**.
        ///
        /// Sensible Values : for **Combustion Model** : 0.51, for **Electric Model** : 0.73
        /// </param>
        /// <param name="constantSpeedConsumptionInKwHPerHundredKm">
        /// Specifies the speed-dependent component of consumption.
        ///
        /// Provided as an unordered list of speed/consumption-rate pairs. The list defines points on a consumption curve. Consumption rates for speeds not in the list are found as follows:
        ///
        /// * by linear interpolation, if the given speed lies in between two speeds in the list
        ///
        /// * by linear extrapolation otherwise, assuming a constant (ΔConsumption/ΔSpeed) determined by the nearest two points in the list
        ///
        /// The list must contain between 1 and 25 points (inclusive), and may not contain duplicate points for the same speed. If it only contains a single point, then the consumption rate of that point is used without further processing.
        ///
        /// Consumption specified for the largest speed must be greater than or equal to that of the penultimate largest speed. This ensures that extrapolation does not lead to negative consumption rates.
        ///
        /// Similarly, consumption values specified for the two smallest speeds in the list cannot lead to a negative consumption rate for any smaller  speed.
        ///
        /// The valid range for the consumption values(expressed in kWh/100km) is between 0.01 and 100000.0.
        ///
        /// Sensible Values : 50,8.2:130,21.3
        ///
        /// This parameter is required for **Electric consumption model**.
        /// </param>
        /// <param name="currentChargeInKwH">
        /// Specifies the current electric energy supply in kilowatt hours (kWh).
        ///
        /// This parameter co-exists with **maxChargeInkWh** parameter.
        ///
        /// The range of values allowed are 0.0 to **maxChargeInkWh**.
        ///
        /// Sensible Values : 43
        /// </param>
        /// <param name="maxChargeInKwH">
        /// Specifies the maximum electric energy supply in kilowatt hours (kWh) that may be stored in the vehicle's battery.
        ///
        /// This parameter co-exists with **currentChargeInkWh** parameter.
        ///
        /// Minimum value has to be greater than or equal to **currentChargeInkWh**.
        ///
        /// Sensible Values : 85
        /// </param>
        /// <param name="auxiliaryPowerInKw">
        /// Specifies the amount of power consumed for sustaining auxiliary systems, in kilowatts (kW).
        ///
        /// It can be used to specify consumption due to devices and systems such as AC systems, radio, heating, etc.
        ///
        /// Sensible Values : 1.7
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="query"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Route Range` (Isochrone) API is an HTTP `GET` request that will calculate a set of locations that can be reached from the origin point based on fuel, energy, time or distance budget that is specified. A polygon boundary (or Isochrone) is returned in a counterclockwise  orientation as well as the precise polygon center which was the result of the origin point.
        ///
        /// The returned polygon can be used for further processing such as  [Search Inside Geometry](/rest/api/maps/search/post-search-inside-geometry) to  search for POIs within the provided isochrone.
        /// </remarks>
        public Response<RouteRangeResult> GetRouteRange(ResponseFormat format, IEnumerable<double> query, double? fuelBudgetInLiters = null, double? energyBudgetInKwH = null, double? timeBudgetInSec = null, double? distanceBudgetInMeters = null, DateTimeOffset? departAt = null, RouteType? routeType = null, bool? useTrafficData = null, IEnumerable<RouteAvoidType> avoid = null, TravelMode? travelMode = null, InclineLevel? inclineLevel = null, WindingnessLevel? windingness = null, int? vehicleAxleWeight = null, double? vehicleWidth = null, double? vehicleHeight = null, double? vehicleLength = null, int? vehicleMaxSpeed = null, int? vehicleWeight = null, bool? isCommercialVehicle = null, VehicleLoadType? vehicleLoadType = null, VehicleEngineType? vehicleEngineType = null, string constantSpeedConsumptionInLitersPerHundredKm = null, double? currentFuelInLiters = null, double? auxiliaryPowerInLitersPerHour = null, double? fuelEnergyDensityInMegajoulesPerLiter = null, double? accelerationEfficiency = null, double? decelerationEfficiency = null, double? uphillEfficiency = null, double? downhillEfficiency = null, string constantSpeedConsumptionInKwHPerHundredKm = null, double? currentChargeInKwH = null, double? maxChargeInKwH = null, double? auxiliaryPowerInKw = null, CancellationToken cancellationToken = default)
        {
            if (query == null)
            {
                throw new ArgumentNullException(nameof(query));
            }

            using var message = CreateGetRouteRangeRequest(format, query, fuelBudgetInLiters, energyBudgetInKwH, timeBudgetInSec, distanceBudgetInMeters, departAt, routeType, useTrafficData, avoid, travelMode, inclineLevel, windingness, vehicleAxleWeight, vehicleWidth, vehicleHeight, vehicleLength, vehicleMaxSpeed, vehicleWeight, isCommercialVehicle, vehicleLoadType, vehicleEngineType, constantSpeedConsumptionInLitersPerHundredKm, currentFuelInLiters, auxiliaryPowerInLitersPerHour, fuelEnergyDensityInMegajoulesPerLiter, accelerationEfficiency, decelerationEfficiency, uphillEfficiency, downhillEfficiency, constantSpeedConsumptionInKwHPerHundredKm, currentChargeInKwH, maxChargeInKwH, auxiliaryPowerInKw);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RouteRangeResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RouteRangeResult.DeserializeRouteRangeResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateRequestRouteDirectionsBatchRequest(JsonFormat format, BatchRequest routeDirectionsBatchQueries)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/route/directions/batch/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(routeDirectionsBatchQueries);
            request.Content = content;
            return message;
        }

        /// <summary> Use to send a batch of queries to the [Get Route Directions](/rest/api/maps/route/get-route-directions) API in a single asynchronous request. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="routeDirectionsBatchQueries"> The list of route directions queries/requests to process. The list can contain a max of 700 queries for async and 100 queries for sync version and must contain at least 1 query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="routeDirectionsBatchQueries"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Post Route Directions Batch` API is an HTTP `POST` request that sends batches of queries to the [Get Route Directions](/rest/api/maps/route/get-route-directions) API using a single asynchronous request. You can call `Route Directions Batch` API to run either asynchronously (async) or synchronously (sync). The async API allows caller to batch up to **700** queries and sync API up to **100** queries. To call the `Post Route Directions Batch` API in a synchronous request, see [Post Route Directions Batch Sync](/rest/api/maps/route/post-route-directions-batch-sync).
        ///
        /// ### Submit Asynchronous Batch Request
        /// The Asynchronous API is appropriate for processing big volumes of relatively complex route requests
        /// - It allows the retrieval of results in a separate call (multiple downloads are possible).
        /// - The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        /// - The number of batch items is limited to **700** for this API.
        ///
        /// When you make a request by using async request, by default the service returns a 202 response code along a redirect URL in the Location field of the response header. This URL should be checked periodically until the response data or error information is available.
        /// The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response if used after the expiration period.
        ///
        /// Please note that asynchronous batch request is a long-running operation. Here's a typical sequence of operations:
        /// 1. Client sends a Route Directions Batch `POST` request to Azure Maps.
        /// ```
        /// POST https://atlas.microsoft.com/route/directions/batch/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        /// 2. The server will respond with one of the following:
        ///
        ///     &gt; HTTP `202 Accepted` - Batch request has been accepted.
        ///
        ///     &gt; HTTP `Error` - There was an error processing your Batch request. This could either be a `400 Bad Request` or any other `Error` status code.
        ///
        /// 3. If the batch request was accepted successfully, the `Location` header in the response contains the URL to download the results of the batch request.
        ///     This status URI looks like following:
        /// ```
        /// GET https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        /// 4. Client issues a `GET` request on the _download URL_ obtained in Step 3 to download the batch results.
        ///
        /// ### POST Body for Batch Request
        /// To send the _route directions_ queries you will use a `POST` request where the request body will contain the `batchItems` array in `json` format and the `Content-Type` header will be set to `application/json`. Here's a sample request body containing 3 _route directions_ queries:
        ///
        ///
        /// ```json
        /// {
        ///     "batchItems": [
        ///         { "query": "?query=47.620659,-122.348934:47.610101,-122.342015&amp;travelMode=bicycle&amp;routeType=eco&amp;traffic=false" },
        ///         { "query": "?query=40.759856,-73.985108:40.771136,-73.973506&amp;travelMode=pedestrian&amp;routeType=shortest" },
        ///         { "query": "?query=48.923159,-122.557362:32.621279,-116.840362" }
        ///     ]
        /// }
        /// ```
        ///
        /// A _route directions_ query in a batch is just a partial URL _without_ the protocol, base URL, path, api-version and subscription-key. It can accept any of the supported _route directions_ [URI parameters](https://docs.microsoft.com/rest/api/maps/route/getroutedirections#uri-parameters). The string values in the _route directions_ query must be properly escaped (e.g. " character should be escaped with \\ ) and it should also be properly URL-encoded.
        ///
        ///
        /// The async API allows caller to batch up to **700** queries and sync API up to **100** queries, and the batch should contain at least **1** query.
        ///
        ///
        /// ### Download Asynchronous Batch Results
        /// To download the async batch results you will issue a `GET` request to the batch download endpoint. This _download URL_ can be obtained from the `Location` header of a successful `POST` batch request and looks like the following:
        ///
        /// ```
        /// https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        /// Here's the typical sequence of operations for downloading the batch results:
        /// 1. Client sends a `GET` request using the _download URL_.
        /// 2. The server will respond with one of the following:
        ///
        ///     &gt; HTTP `202 Accepted` - Batch request was accepted but is still being processed. Please try again in some time.
        ///
        ///     &gt; HTTP `200 OK` - Batch request successfully processed. The response body contains all the batch results.
        ///
        ///
        ///
        /// ### Batch Response Model
        /// The returned data content is similar for async and sync requests. When downloading the results of an async batch request, if the batch has finished processing, the response body contains the batch response. This batch response contains a `summary` component that indicates the `totalRequests` that were part of the original batch request and `successfulRequests`i.e. queries which were executed successfully. The batch response also includes a `batchItems` array which contains a response for each and every query in the batch request. The `batchItems` will contain the results in the exact same order the original queries were sent in the batch request. Each item in `batchItems` contains `statusCode` and `response` fields. Each `response` in `batchItems` is of one of the following types:
        ///
        ///   - [`RouteDirections`](https://docs.microsoft.com/rest/api/maps/route/getroutedirections#routedirections) - If the query completed successfully.
        ///
        ///   - `Error` - If the query failed. The response will contain a `code` and a `message` in this case.
        ///
        ///
        /// Here's a sample Batch Response with 1 _successful_ and 1 _failed_ result:
        ///
        ///
        /// ```json
        /// {
        ///     "summary": {
        ///         "successfulRequests": 1,
        ///         "totalRequests": 2
        ///     },
        ///     "batchItems": [
        ///         {
        ///             "statusCode": 200,
        ///             "response": {
        ///                 "routes": [
        ///                     {
        ///                         "summary": {
        ///                             "lengthInMeters": 1758,
        ///                             "travelTimeInSeconds": 387,
        ///                             "trafficDelayInSeconds": 0,
        ///                             "departureTime": "2018-07-17T00:49:56+00:00",
        ///                             "arrivalTime": "2018-07-17T00:56:22+00:00"
        ///                         },
        ///                         "legs": [
        ///                             {
        ///                                 "summary": {
        ///                                     "lengthInMeters": 1758,
        ///                                     "travelTimeInSeconds": 387,
        ///                                     "trafficDelayInSeconds": 0,
        ///                                     "departureTime": "2018-07-17T00:49:56+00:00",
        ///                                     "arrivalTime": "2018-07-17T00:56:22+00:00"
        ///                                 },
        ///                                 "points": [
        ///                                     {
        ///                                         "latitude": 47.62094,
        ///                                         "longitude": -122.34892
        ///                                     },
        ///                                     {
        ///                                         "latitude": 47.62094,
        ///                                         "longitude": -122.3485
        ///                                     },
        ///                                     {
        ///                                         "latitude": 47.62095,
        ///                                         "longitude": -122.3476
        ///                                     }
        ///                                 ]
        ///                             }
        ///                         ],
        ///                         "sections": [
        ///                             {
        ///                                 "startPointIndex": 0,
        ///                                 "endPointIndex": 40,
        ///                                 "sectionType": "TRAVEL_MODE",
        ///                                 "travelMode": "bicycle"
        ///                             }
        ///                         ]
        ///                     }
        ///                 ]
        ///             }
        ///         },
        ///         {
        ///             "statusCode": 400,
        ///             "response":
        ///             {
        ///                 "error":
        ///                 {
        ///                     "code": "400 BadRequest",
        ///                     "message": "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
        ///                 }
        ///             }
        ///         }
        ///     ]
        /// }
        /// ```
        /// </remarks>
        public async Task<ResponseWithHeaders<RouteRequestRouteDirectionsBatchHeaders>> RequestRouteDirectionsBatchAsync(JsonFormat format, BatchRequest routeDirectionsBatchQueries, CancellationToken cancellationToken = default)
        {
            if (routeDirectionsBatchQueries == null)
            {
                throw new ArgumentNullException(nameof(routeDirectionsBatchQueries));
            }

            using var message = CreateRequestRouteDirectionsBatchRequest(format, routeDirectionsBatchQueries);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new RouteRequestRouteDirectionsBatchHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to send a batch of queries to the [Get Route Directions](/rest/api/maps/route/get-route-directions) API in a single asynchronous request. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="routeDirectionsBatchQueries"> The list of route directions queries/requests to process. The list can contain a max of 700 queries for async and 100 queries for sync version and must contain at least 1 query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="routeDirectionsBatchQueries"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Post Route Directions Batch` API is an HTTP `POST` request that sends batches of queries to the [Get Route Directions](/rest/api/maps/route/get-route-directions) API using a single asynchronous request. You can call `Route Directions Batch` API to run either asynchronously (async) or synchronously (sync). The async API allows caller to batch up to **700** queries and sync API up to **100** queries. To call the `Post Route Directions Batch` API in a synchronous request, see [Post Route Directions Batch Sync](/rest/api/maps/route/post-route-directions-batch-sync).
        ///
        /// ### Submit Asynchronous Batch Request
        /// The Asynchronous API is appropriate for processing big volumes of relatively complex route requests
        /// - It allows the retrieval of results in a separate call (multiple downloads are possible).
        /// - The asynchronous API is optimized for reliability and is not expected to run into a timeout.
        /// - The number of batch items is limited to **700** for this API.
        ///
        /// When you make a request by using async request, by default the service returns a 202 response code along a redirect URL in the Location field of the response header. This URL should be checked periodically until the response data or error information is available.
        /// The asynchronous responses are stored for **14** days. The redirect URL returns a 404 response if used after the expiration period.
        ///
        /// Please note that asynchronous batch request is a long-running operation. Here's a typical sequence of operations:
        /// 1. Client sends a Route Directions Batch `POST` request to Azure Maps.
        /// ```
        /// POST https://atlas.microsoft.com/route/directions/batch/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        /// 2. The server will respond with one of the following:
        ///
        ///     &gt; HTTP `202 Accepted` - Batch request has been accepted.
        ///
        ///     &gt; HTTP `Error` - There was an error processing your Batch request. This could either be a `400 Bad Request` or any other `Error` status code.
        ///
        /// 3. If the batch request was accepted successfully, the `Location` header in the response contains the URL to download the results of the batch request.
        ///     This status URI looks like following:
        /// ```
        /// GET https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        /// 4. Client issues a `GET` request on the _download URL_ obtained in Step 3 to download the batch results.
        ///
        /// ### POST Body for Batch Request
        /// To send the _route directions_ queries you will use a `POST` request where the request body will contain the `batchItems` array in `json` format and the `Content-Type` header will be set to `application/json`. Here's a sample request body containing 3 _route directions_ queries:
        ///
        ///
        /// ```json
        /// {
        ///     "batchItems": [
        ///         { "query": "?query=47.620659,-122.348934:47.610101,-122.342015&amp;travelMode=bicycle&amp;routeType=eco&amp;traffic=false" },
        ///         { "query": "?query=40.759856,-73.985108:40.771136,-73.973506&amp;travelMode=pedestrian&amp;routeType=shortest" },
        ///         { "query": "?query=48.923159,-122.557362:32.621279,-116.840362" }
        ///     ]
        /// }
        /// ```
        ///
        /// A _route directions_ query in a batch is just a partial URL _without_ the protocol, base URL, path, api-version and subscription-key. It can accept any of the supported _route directions_ [URI parameters](https://docs.microsoft.com/rest/api/maps/route/getroutedirections#uri-parameters). The string values in the _route directions_ query must be properly escaped (e.g. " character should be escaped with \\ ) and it should also be properly URL-encoded.
        ///
        ///
        /// The async API allows caller to batch up to **700** queries and sync API up to **100** queries, and the batch should contain at least **1** query.
        ///
        ///
        /// ### Download Asynchronous Batch Results
        /// To download the async batch results you will issue a `GET` request to the batch download endpoint. This _download URL_ can be obtained from the `Location` header of a successful `POST` batch request and looks like the following:
        ///
        /// ```
        /// https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        /// Here's the typical sequence of operations for downloading the batch results:
        /// 1. Client sends a `GET` request using the _download URL_.
        /// 2. The server will respond with one of the following:
        ///
        ///     &gt; HTTP `202 Accepted` - Batch request was accepted but is still being processed. Please try again in some time.
        ///
        ///     &gt; HTTP `200 OK` - Batch request successfully processed. The response body contains all the batch results.
        ///
        ///
        ///
        /// ### Batch Response Model
        /// The returned data content is similar for async and sync requests. When downloading the results of an async batch request, if the batch has finished processing, the response body contains the batch response. This batch response contains a `summary` component that indicates the `totalRequests` that were part of the original batch request and `successfulRequests`i.e. queries which were executed successfully. The batch response also includes a `batchItems` array which contains a response for each and every query in the batch request. The `batchItems` will contain the results in the exact same order the original queries were sent in the batch request. Each item in `batchItems` contains `statusCode` and `response` fields. Each `response` in `batchItems` is of one of the following types:
        ///
        ///   - [`RouteDirections`](https://docs.microsoft.com/rest/api/maps/route/getroutedirections#routedirections) - If the query completed successfully.
        ///
        ///   - `Error` - If the query failed. The response will contain a `code` and a `message` in this case.
        ///
        ///
        /// Here's a sample Batch Response with 1 _successful_ and 1 _failed_ result:
        ///
        ///
        /// ```json
        /// {
        ///     "summary": {
        ///         "successfulRequests": 1,
        ///         "totalRequests": 2
        ///     },
        ///     "batchItems": [
        ///         {
        ///             "statusCode": 200,
        ///             "response": {
        ///                 "routes": [
        ///                     {
        ///                         "summary": {
        ///                             "lengthInMeters": 1758,
        ///                             "travelTimeInSeconds": 387,
        ///                             "trafficDelayInSeconds": 0,
        ///                             "departureTime": "2018-07-17T00:49:56+00:00",
        ///                             "arrivalTime": "2018-07-17T00:56:22+00:00"
        ///                         },
        ///                         "legs": [
        ///                             {
        ///                                 "summary": {
        ///                                     "lengthInMeters": 1758,
        ///                                     "travelTimeInSeconds": 387,
        ///                                     "trafficDelayInSeconds": 0,
        ///                                     "departureTime": "2018-07-17T00:49:56+00:00",
        ///                                     "arrivalTime": "2018-07-17T00:56:22+00:00"
        ///                                 },
        ///                                 "points": [
        ///                                     {
        ///                                         "latitude": 47.62094,
        ///                                         "longitude": -122.34892
        ///                                     },
        ///                                     {
        ///                                         "latitude": 47.62094,
        ///                                         "longitude": -122.3485
        ///                                     },
        ///                                     {
        ///                                         "latitude": 47.62095,
        ///                                         "longitude": -122.3476
        ///                                     }
        ///                                 ]
        ///                             }
        ///                         ],
        ///                         "sections": [
        ///                             {
        ///                                 "startPointIndex": 0,
        ///                                 "endPointIndex": 40,
        ///                                 "sectionType": "TRAVEL_MODE",
        ///                                 "travelMode": "bicycle"
        ///                             }
        ///                         ]
        ///                     }
        ///                 ]
        ///             }
        ///         },
        ///         {
        ///             "statusCode": 400,
        ///             "response":
        ///             {
        ///                 "error":
        ///                 {
        ///                     "code": "400 BadRequest",
        ///                     "message": "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
        ///                 }
        ///             }
        ///         }
        ///     ]
        /// }
        /// ```
        /// </remarks>
        public ResponseWithHeaders<RouteRequestRouteDirectionsBatchHeaders> RequestRouteDirectionsBatch(JsonFormat format, BatchRequest routeDirectionsBatchQueries, CancellationToken cancellationToken = default)
        {
            if (routeDirectionsBatchQueries == null)
            {
                throw new ArgumentNullException(nameof(routeDirectionsBatchQueries));
            }

            using var message = CreateRequestRouteDirectionsBatchRequest(format, routeDirectionsBatchQueries);
            _pipeline.Send(message, cancellationToken);
            var headers = new RouteRequestRouteDirectionsBatchHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetRouteDirectionsBatchRequest(string batchId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/route/directions/batch/", false);
            uri.AppendPath(batchId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Use to send a batch of queries to the [Get Route Directions](/rest/api/maps/route/get-route-directions) API in a single asynchronous request. </summary>
        /// <param name="batchId"> Batch id for querying the operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="batchId"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Route Directions Batch` API is an HTTP `GET` request that sends batches of queries to the [Get Route Directions](/rest/api/maps/route/get-route-directions) API using a single request. You can call `Get Route Directions Batch` API to run either asynchronously (async) or synchronously (sync). The async API allows caller to batch up to **700** queries and sync API up to **100** queries.
        ///
        /// ### Download Asynchronous Batch Results
        /// To download the async batch results you will issue a `GET` request to the batch download endpoint. This _download URL_ can be obtained from the `Location` header of a successful `POST` batch request and looks like the following:
        ///
        /// ```
        /// https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        /// Here's the typical sequence of operations for downloading the batch results:
        /// 1. Client sends a `GET` request using the _download URL_.
        /// 2. The server will respond with one of the following:
        ///
        ///     &gt; HTTP `202 Accepted` - Batch request was accepted but is still being processed. Please try again in some time.
        ///
        ///     &gt; HTTP `200 OK` - Batch request successfully processed. The response body contains all the batch results.
        ///
        ///
        ///
        /// ### Batch Response Model
        /// The returned data content is similar for async and sync requests. When downloading the results of an async batch request, if the batch has finished processing, the response body contains the batch response. This batch response contains a `summary` component that indicates the `totalRequests` that were part of the original batch request and `successfulRequests`i.e. queries which were executed successfully. The batch response also includes a `batchItems` array which contains a response for each and every query in the batch request. The `batchItems` will contain the results in the exact same order the original queries were sent in the batch request. Each item in `batchItems` contains `statusCode` and `response` fields. Each `response` in `batchItems` is of one of the following types:
        ///
        ///   - [`RouteDirections`](https://docs.microsoft.com/rest/api/maps/route/getroutedirections#routedirections) - If the query completed successfully.
        ///
        ///   - `Error` - If the query failed. The response will contain a `code` and a `message` in this case.
        ///
        ///
        /// Here's a sample Batch Response with 1 _successful_ and 1 _failed_ result:
        ///
        ///
        /// ```json
        /// {
        ///     "summary": {
        ///         "successfulRequests": 1,
        ///         "totalRequests": 2
        ///     },
        ///     "batchItems": [
        ///         {
        ///             "statusCode": 200,
        ///             "response": {
        ///                 "routes": [
        ///                     {
        ///                         "summary": {
        ///                             "lengthInMeters": 1758,
        ///                             "travelTimeInSeconds": 387,
        ///                             "trafficDelayInSeconds": 0,
        ///                             "departureTime": "2018-07-17T00:49:56+00:00",
        ///                             "arrivalTime": "2018-07-17T00:56:22+00:00"
        ///                         },
        ///                         "legs": [
        ///                             {
        ///                                 "summary": {
        ///                                     "lengthInMeters": 1758,
        ///                                     "travelTimeInSeconds": 387,
        ///                                     "trafficDelayInSeconds": 0,
        ///                                     "departureTime": "2018-07-17T00:49:56+00:00",
        ///                                     "arrivalTime": "2018-07-17T00:56:22+00:00"
        ///                                 },
        ///                                 "points": [
        ///                                     {
        ///                                         "latitude": 47.62094,
        ///                                         "longitude": -122.34892
        ///                                     },
        ///                                     {
        ///                                         "latitude": 47.62094,
        ///                                         "longitude": -122.3485
        ///                                     },
        ///                                     {
        ///                                         "latitude": 47.62095,
        ///                                         "longitude": -122.3476
        ///                                     }
        ///                                 ]
        ///                             }
        ///                         ],
        ///                         "sections": [
        ///                             {
        ///                                 "startPointIndex": 0,
        ///                                 "endPointIndex": 40,
        ///                                 "sectionType": "TRAVEL_MODE",
        ///                                 "travelMode": "bicycle"
        ///                             }
        ///                         ]
        ///                     }
        ///                 ]
        ///             }
        ///         },
        ///         {
        ///             "statusCode": 400,
        ///             "response":
        ///             {
        ///                 "error":
        ///                 {
        ///                     "code": "400 BadRequest",
        ///                     "message": "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
        ///                 }
        ///             }
        ///         }
        ///     ]
        /// }
        /// ```
        /// </remarks>
        public async Task<ResponseWithHeaders<RouteGetRouteDirectionsBatchHeaders>> GetRouteDirectionsBatchAsync(string batchId, CancellationToken cancellationToken = default)
        {
            if (batchId == null)
            {
                throw new ArgumentNullException(nameof(batchId));
            }

            using var message = CreateGetRouteDirectionsBatchRequest(batchId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new RouteGetRouteDirectionsBatchHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to send a batch of queries to the [Get Route Directions](/rest/api/maps/route/get-route-directions) API in a single asynchronous request. </summary>
        /// <param name="batchId"> Batch id for querying the operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="batchId"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Route Directions Batch` API is an HTTP `GET` request that sends batches of queries to the [Get Route Directions](/rest/api/maps/route/get-route-directions) API using a single request. You can call `Get Route Directions Batch` API to run either asynchronously (async) or synchronously (sync). The async API allows caller to batch up to **700** queries and sync API up to **100** queries.
        ///
        /// ### Download Asynchronous Batch Results
        /// To download the async batch results you will issue a `GET` request to the batch download endpoint. This _download URL_ can be obtained from the `Location` header of a successful `POST` batch request and looks like the following:
        ///
        /// ```
        /// https://atlas.microsoft.com/route/directions/batch/{batch-id}?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        /// Here's the typical sequence of operations for downloading the batch results:
        /// 1. Client sends a `GET` request using the _download URL_.
        /// 2. The server will respond with one of the following:
        ///
        ///     &gt; HTTP `202 Accepted` - Batch request was accepted but is still being processed. Please try again in some time.
        ///
        ///     &gt; HTTP `200 OK` - Batch request successfully processed. The response body contains all the batch results.
        ///
        ///
        ///
        /// ### Batch Response Model
        /// The returned data content is similar for async and sync requests. When downloading the results of an async batch request, if the batch has finished processing, the response body contains the batch response. This batch response contains a `summary` component that indicates the `totalRequests` that were part of the original batch request and `successfulRequests`i.e. queries which were executed successfully. The batch response also includes a `batchItems` array which contains a response for each and every query in the batch request. The `batchItems` will contain the results in the exact same order the original queries were sent in the batch request. Each item in `batchItems` contains `statusCode` and `response` fields. Each `response` in `batchItems` is of one of the following types:
        ///
        ///   - [`RouteDirections`](https://docs.microsoft.com/rest/api/maps/route/getroutedirections#routedirections) - If the query completed successfully.
        ///
        ///   - `Error` - If the query failed. The response will contain a `code` and a `message` in this case.
        ///
        ///
        /// Here's a sample Batch Response with 1 _successful_ and 1 _failed_ result:
        ///
        ///
        /// ```json
        /// {
        ///     "summary": {
        ///         "successfulRequests": 1,
        ///         "totalRequests": 2
        ///     },
        ///     "batchItems": [
        ///         {
        ///             "statusCode": 200,
        ///             "response": {
        ///                 "routes": [
        ///                     {
        ///                         "summary": {
        ///                             "lengthInMeters": 1758,
        ///                             "travelTimeInSeconds": 387,
        ///                             "trafficDelayInSeconds": 0,
        ///                             "departureTime": "2018-07-17T00:49:56+00:00",
        ///                             "arrivalTime": "2018-07-17T00:56:22+00:00"
        ///                         },
        ///                         "legs": [
        ///                             {
        ///                                 "summary": {
        ///                                     "lengthInMeters": 1758,
        ///                                     "travelTimeInSeconds": 387,
        ///                                     "trafficDelayInSeconds": 0,
        ///                                     "departureTime": "2018-07-17T00:49:56+00:00",
        ///                                     "arrivalTime": "2018-07-17T00:56:22+00:00"
        ///                                 },
        ///                                 "points": [
        ///                                     {
        ///                                         "latitude": 47.62094,
        ///                                         "longitude": -122.34892
        ///                                     },
        ///                                     {
        ///                                         "latitude": 47.62094,
        ///                                         "longitude": -122.3485
        ///                                     },
        ///                                     {
        ///                                         "latitude": 47.62095,
        ///                                         "longitude": -122.3476
        ///                                     }
        ///                                 ]
        ///                             }
        ///                         ],
        ///                         "sections": [
        ///                             {
        ///                                 "startPointIndex": 0,
        ///                                 "endPointIndex": 40,
        ///                                 "sectionType": "TRAVEL_MODE",
        ///                                 "travelMode": "bicycle"
        ///                             }
        ///                         ]
        ///                     }
        ///                 ]
        ///             }
        ///         },
        ///         {
        ///             "statusCode": 400,
        ///             "response":
        ///             {
        ///                 "error":
        ///                 {
        ///                     "code": "400 BadRequest",
        ///                     "message": "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
        ///                 }
        ///             }
        ///         }
        ///     ]
        /// }
        /// ```
        /// </remarks>
        public ResponseWithHeaders<RouteGetRouteDirectionsBatchHeaders> GetRouteDirectionsBatch(string batchId, CancellationToken cancellationToken = default)
        {
            if (batchId == null)
            {
                throw new ArgumentNullException(nameof(batchId));
            }

            using var message = CreateGetRouteDirectionsBatchRequest(batchId);
            _pipeline.Send(message, cancellationToken);
            var headers = new RouteGetRouteDirectionsBatchHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateRequestRouteDirectionsBatchSyncRequest(JsonFormat format, BatchRequest routeDirectionsBatchQueries)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/route/directions/batch/sync/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(routeDirectionsBatchQueries);
            request.Content = content;
            return message;
        }

        /// <summary> Use to send a batch of queries to the [Get Route Directions](/rest/api/maps/route/get-route-directions) API in a single synchronous request. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="routeDirectionsBatchQueries"> The list of route directions queries/requests to process. The list can contain  a max of 700 queries for async and 100 queries for sync version and must contain at least 1 query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="routeDirectionsBatchQueries"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Post Route Directions Batch Sync` API is an HTTP `POST` request that sends batches of queries to the [Get Route Directions](/rest/api/maps/route/get-route-directions) API using a single synchronous request. You can call `Route Directions Batch` API to run either asynchronously (async) or synchronously (sync). The async API allows caller to batch up to **700** queries and sync API up to **100** queries. To call the `Post Route Directions Batch` API in a asynchronous request, see [Post Route Directions Batch](/rest/api/maps/route/post-route-directions-batch).
        /// ### Submit Synchronous Batch Request
        /// The Synchronous API is recommended for lightweight batch requests. When the service receives a request, it will respond as soon as the batch items are calculated and there will be no possibility to retrieve the results later. The Synchronous API will return a timeout error (a 408 response) if the request takes longer than 60 seconds. The number of batch items is limited to **100** for this API.
        /// ```
        /// POST https://atlas.microsoft.com/route/directions/batch/sync/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        /// ### Batch Response Model
        /// The returned data content is similar for async and sync requests. When downloading the results of an async batch request, if the batch has finished processing, the response body contains the batch response. This batch response contains a `summary` component that indicates the `totalRequests` that were part of the original batch request and `successfulRequests`i.e. queries which were executed successfully. The batch response also includes a `batchItems` array which contains a response for each and every query in the batch request. The `batchItems` will contain the results in the exact same order the original queries were sent in the batch request. Each item in `batchItems` contains `statusCode` and `response` fields. Each `response` in `batchItems` is of one of the following types:
        ///
        ///   - [`RouteDirections`](https://docs.microsoft.com/rest/api/maps/route/getroutedirections#routedirections) - If the query completed successfully.
        ///
        ///   - `Error` - If the query failed. The response will contain a `code` and a `message` in this case.
        ///
        ///
        /// Here's a sample Batch Response with 1 _successful_ and 1 _failed_ result:
        ///
        ///
        /// ```json
        /// {
        ///     "summary": {
        ///         "successfulRequests": 1,
        ///         "totalRequests": 2
        ///     },
        ///     "batchItems": [
        ///         {
        ///             "statusCode": 200,
        ///             "response": {
        ///                 "routes": [
        ///                     {
        ///                         "summary": {
        ///                             "lengthInMeters": 1758,
        ///                             "travelTimeInSeconds": 387,
        ///                             "trafficDelayInSeconds": 0,
        ///                             "departureTime": "2018-07-17T00:49:56+00:00",
        ///                             "arrivalTime": "2018-07-17T00:56:22+00:00"
        ///                         },
        ///                         "legs": [
        ///                             {
        ///                                 "summary": {
        ///                                     "lengthInMeters": 1758,
        ///                                     "travelTimeInSeconds": 387,
        ///                                     "trafficDelayInSeconds": 0,
        ///                                     "departureTime": "2018-07-17T00:49:56+00:00",
        ///                                     "arrivalTime": "2018-07-17T00:56:22+00:00"
        ///                                 },
        ///                                 "points": [
        ///                                     {
        ///                                         "latitude": 47.62094,
        ///                                         "longitude": -122.34892
        ///                                     },
        ///                                     {
        ///                                         "latitude": 47.62094,
        ///                                         "longitude": -122.3485
        ///                                     },
        ///                                     {
        ///                                         "latitude": 47.62095,
        ///                                         "longitude": -122.3476
        ///                                     }
        ///                                 ]
        ///                             }
        ///                         ],
        ///                         "sections": [
        ///                             {
        ///                                 "startPointIndex": 0,
        ///                                 "endPointIndex": 40,
        ///                                 "sectionType": "TRAVEL_MODE",
        ///                                 "travelMode": "bicycle"
        ///                             }
        ///                         ]
        ///                     }
        ///                 ]
        ///             }
        ///         },
        ///         {
        ///             "statusCode": 400,
        ///             "response":
        ///             {
        ///                 "error":
        ///                 {
        ///                     "code": "400 BadRequest",
        ///                     "message": "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
        ///                 }
        ///             }
        ///         }
        ///     ]
        /// }
        /// ```
        /// </remarks>
        public async Task<Response<RouteDirectionsBatchResult>> RequestRouteDirectionsBatchSyncAsync(JsonFormat format, BatchRequest routeDirectionsBatchQueries, CancellationToken cancellationToken = default)
        {
            if (routeDirectionsBatchQueries == null)
            {
                throw new ArgumentNullException(nameof(routeDirectionsBatchQueries));
            }

            using var message = CreateRequestRouteDirectionsBatchSyncRequest(format, routeDirectionsBatchQueries);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RouteDirectionsBatchResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RouteDirectionsBatchResult.DeserializeRouteDirectionsBatchResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to send a batch of queries to the [Get Route Directions](/rest/api/maps/route/get-route-directions) API in a single synchronous request. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="routeDirectionsBatchQueries"> The list of route directions queries/requests to process. The list can contain  a max of 700 queries for async and 100 queries for sync version and must contain at least 1 query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="routeDirectionsBatchQueries"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Post Route Directions Batch Sync` API is an HTTP `POST` request that sends batches of queries to the [Get Route Directions](/rest/api/maps/route/get-route-directions) API using a single synchronous request. You can call `Route Directions Batch` API to run either asynchronously (async) or synchronously (sync). The async API allows caller to batch up to **700** queries and sync API up to **100** queries. To call the `Post Route Directions Batch` API in a asynchronous request, see [Post Route Directions Batch](/rest/api/maps/route/post-route-directions-batch).
        /// ### Submit Synchronous Batch Request
        /// The Synchronous API is recommended for lightweight batch requests. When the service receives a request, it will respond as soon as the batch items are calculated and there will be no possibility to retrieve the results later. The Synchronous API will return a timeout error (a 408 response) if the request takes longer than 60 seconds. The number of batch items is limited to **100** for this API.
        /// ```
        /// POST https://atlas.microsoft.com/route/directions/batch/sync/json?api-version=1.0&amp;subscription-key={subscription-key}
        /// ```
        /// ### Batch Response Model
        /// The returned data content is similar for async and sync requests. When downloading the results of an async batch request, if the batch has finished processing, the response body contains the batch response. This batch response contains a `summary` component that indicates the `totalRequests` that were part of the original batch request and `successfulRequests`i.e. queries which were executed successfully. The batch response also includes a `batchItems` array which contains a response for each and every query in the batch request. The `batchItems` will contain the results in the exact same order the original queries were sent in the batch request. Each item in `batchItems` contains `statusCode` and `response` fields. Each `response` in `batchItems` is of one of the following types:
        ///
        ///   - [`RouteDirections`](https://docs.microsoft.com/rest/api/maps/route/getroutedirections#routedirections) - If the query completed successfully.
        ///
        ///   - `Error` - If the query failed. The response will contain a `code` and a `message` in this case.
        ///
        ///
        /// Here's a sample Batch Response with 1 _successful_ and 1 _failed_ result:
        ///
        ///
        /// ```json
        /// {
        ///     "summary": {
        ///         "successfulRequests": 1,
        ///         "totalRequests": 2
        ///     },
        ///     "batchItems": [
        ///         {
        ///             "statusCode": 200,
        ///             "response": {
        ///                 "routes": [
        ///                     {
        ///                         "summary": {
        ///                             "lengthInMeters": 1758,
        ///                             "travelTimeInSeconds": 387,
        ///                             "trafficDelayInSeconds": 0,
        ///                             "departureTime": "2018-07-17T00:49:56+00:00",
        ///                             "arrivalTime": "2018-07-17T00:56:22+00:00"
        ///                         },
        ///                         "legs": [
        ///                             {
        ///                                 "summary": {
        ///                                     "lengthInMeters": 1758,
        ///                                     "travelTimeInSeconds": 387,
        ///                                     "trafficDelayInSeconds": 0,
        ///                                     "departureTime": "2018-07-17T00:49:56+00:00",
        ///                                     "arrivalTime": "2018-07-17T00:56:22+00:00"
        ///                                 },
        ///                                 "points": [
        ///                                     {
        ///                                         "latitude": 47.62094,
        ///                                         "longitude": -122.34892
        ///                                     },
        ///                                     {
        ///                                         "latitude": 47.62094,
        ///                                         "longitude": -122.3485
        ///                                     },
        ///                                     {
        ///                                         "latitude": 47.62095,
        ///                                         "longitude": -122.3476
        ///                                     }
        ///                                 ]
        ///                             }
        ///                         ],
        ///                         "sections": [
        ///                             {
        ///                                 "startPointIndex": 0,
        ///                                 "endPointIndex": 40,
        ///                                 "sectionType": "TRAVEL_MODE",
        ///                                 "travelMode": "bicycle"
        ///                             }
        ///                         ]
        ///                     }
        ///                 ]
        ///             }
        ///         },
        ///         {
        ///             "statusCode": 400,
        ///             "response":
        ///             {
        ///                 "error":
        ///                 {
        ///                     "code": "400 BadRequest",
        ///                     "message": "Bad request: one or more parameters were incorrectly specified or are mutually exclusive."
        ///                 }
        ///             }
        ///         }
        ///     ]
        /// }
        /// ```
        /// </remarks>
        public Response<RouteDirectionsBatchResult> RequestRouteDirectionsBatchSync(JsonFormat format, BatchRequest routeDirectionsBatchQueries, CancellationToken cancellationToken = default)
        {
            if (routeDirectionsBatchQueries == null)
            {
                throw new ArgumentNullException(nameof(routeDirectionsBatchQueries));
            }

            using var message = CreateRequestRouteDirectionsBatchSyncRequest(format, routeDirectionsBatchQueries);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RouteDirectionsBatchResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RouteDirectionsBatchResult.DeserializeRouteDirectionsBatchResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
