// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing
{
    /// <summary> The VehicleEngineType. </summary>
    public readonly partial struct VehicleEngineType : IEquatable<VehicleEngineType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VehicleEngineType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VehicleEngineType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CombustionValue = "combustion";
        private const string ElectricValue = "electric";

        /// <summary> Internal combustion engine. </summary>
        public static VehicleEngineType Combustion { get; } = new VehicleEngineType(CombustionValue);
        /// <summary> Electric engine. </summary>
        public static VehicleEngineType Electric { get; } = new VehicleEngineType(ElectricValue);
        /// <summary> Determines if two <see cref="VehicleEngineType"/> values are the same. </summary>
        public static bool operator ==(VehicleEngineType left, VehicleEngineType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VehicleEngineType"/> values are not the same. </summary>
        public static bool operator !=(VehicleEngineType left, VehicleEngineType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VehicleEngineType"/>. </summary>
        public static implicit operator VehicleEngineType(string value) => new VehicleEngineType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VehicleEngineType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VehicleEngineType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
