// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing
{
    /// <summary> The SectionType. </summary>
    public readonly partial struct SectionType : IEquatable<SectionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SectionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SectionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CarOrTrainValue = "carTrain";
        private const string CountryValue = "country";
        private const string FerryValue = "ferry";
        private const string MotorwayValue = "motorway";
        private const string PedestrianValue = "pedestrian";
        private const string TollRoadValue = "tollRoad";
        private const string TollVignetteValue = "tollVignette";
        private const string TrafficValue = "traffic";
        private const string TravelModeValue = "travelMode";
        private const string TunnelValue = "tunnel";
        private const string CarpoolValue = "carpool";
        private const string UrbanValue = "urban";

        /// <summary> Sections of the route that are cars or trains. </summary>
        public static SectionType CarOrTrain { get; } = new SectionType(CarOrTrainValue);
        /// <summary> Sections indicating which countries/regions the route is in. </summary>
        public static SectionType Country { get; } = new SectionType(CountryValue);
        /// <summary> Sections of the route that are ferries. </summary>
        public static SectionType Ferry { get; } = new SectionType(FerryValue);
        /// <summary> Sections of the route that are motorways. </summary>
        public static SectionType Motorway { get; } = new SectionType(MotorwayValue);
        /// <summary> Sections of the route that are only suited for pedestrians. </summary>
        public static SectionType Pedestrian { get; } = new SectionType(PedestrianValue);
        /// <summary> Sections of the route that require a toll to be paid. </summary>
        public static SectionType TollRoad { get; } = new SectionType(TollRoadValue);
        /// <summary> Sections of the route that require a toll vignette to be present. </summary>
        public static SectionType TollVignette { get; } = new SectionType(TollVignetteValue);
        /// <summary> Sections of the route that contain traffic information. </summary>
        public static SectionType Traffic { get; } = new SectionType(TrafficValue);
        /// <summary> Sections in relation to the request parameter `travelMode`. </summary>
        public static SectionType TravelMode { get; } = new SectionType(TravelModeValue);
        /// <summary> Sections of the route that are tunnels. </summary>
        public static SectionType Tunnel { get; } = new SectionType(TunnelValue);
        /// <summary> Sections of the route that require use of carpool (HOV/High Occupancy Vehicle) lanes. </summary>
        public static SectionType Carpool { get; } = new SectionType(CarpoolValue);
        /// <summary> Sections of the route that are located within urban areas. </summary>
        public static SectionType Urban { get; } = new SectionType(UrbanValue);
        /// <summary> Determines if two <see cref="SectionType"/> values are the same. </summary>
        public static bool operator ==(SectionType left, SectionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SectionType"/> values are not the same. </summary>
        public static bool operator !=(SectionType left, SectionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SectionType"/>. </summary>
        public static implicit operator SectionType(string value) => new SectionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SectionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SectionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
