// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Routing.Models
{
    public partial class RouteSummary
    {
        internal static RouteSummary DeserializeRouteSummary(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? lengthInMeters = default;
            int? travelTimeInSeconds = default;
            int? trafficDelayInSeconds = default;
            DateTimeOffset? departureTime = default;
            DateTimeOffset? arrivalTime = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("lengthInMeters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lengthInMeters = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("travelTimeInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    travelTimeInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("trafficDelayInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    trafficDelayInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("departureTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    departureTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("arrivalTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    arrivalTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
            }
            return new RouteSummary(lengthInMeters, travelTimeInSeconds, trafficDelayInSeconds, departureTime, arrivalTime);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RouteSummary FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRouteSummary(document.RootElement);
        }
    }
}
