// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Routing.Models
{
    public partial class RouteSectionTecCause
    {
        internal static RouteSectionTecCause DeserializeRouteSectionTecCause(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? mainCauseCode = default;
            int? subCauseCode = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("mainCauseCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mainCauseCode = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("subCauseCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    subCauseCode = property.Value.GetInt32();
                    continue;
                }
            }
            return new RouteSectionTecCause(mainCauseCode, subCauseCode);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RouteSectionTecCause FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRouteSectionTecCause(document.RootElement);
        }
    }
}
