// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Routing.Models
{
    /// <summary> Details of the traffic event, using definitions in the [TPEG2-TEC](https://www.iso.org/standard/63116.html) standard. Can contain effectCode and causes elements. </summary>
    public partial class RouteSectionTec
    {
        /// <summary> Initializes a new instance of <see cref="RouteSectionTec"/>. </summary>
        internal RouteSectionTec()
        {
            Causes = new ChangeTrackingList<RouteSectionTecCause>();
        }

        /// <summary> Initializes a new instance of <see cref="RouteSectionTec"/>. </summary>
        /// <param name="effectCode"> The effect on the traffic flow. Contains a value in the tec001:EffectCode table, as defined in the [TPEG2-TEC](https://www.iso.org/standard/63116.html) standard. Can be used to color-code traffic events according to severity. </param>
        /// <param name="causes"> Causes array. </param>
        internal RouteSectionTec(int? effectCode, IReadOnlyList<RouteSectionTecCause> causes)
        {
            EffectCode = effectCode;
            Causes = causes;
        }

        /// <summary> The effect on the traffic flow. Contains a value in the tec001:EffectCode table, as defined in the [TPEG2-TEC](https://www.iso.org/standard/63116.html) standard. Can be used to color-code traffic events according to severity. </summary>
        public int? EffectCode { get; }
        /// <summary> Causes array. </summary>
        public IReadOnlyList<RouteSectionTecCause> Causes { get; }
    }
}
