// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Routing.Models
{
    public partial class RouteSectionTec
    {
        internal static RouteSectionTec DeserializeRouteSectionTec(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? effectCode = default;
            IReadOnlyList<RouteSectionTecCause> causes = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("effectCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    effectCode = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("causes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RouteSectionTecCause> array = new List<RouteSectionTecCause>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(RouteSectionTecCause.DeserializeRouteSectionTecCause(item));
                    }
                    causes = array;
                    continue;
                }
            }
            return new RouteSectionTec(effectCode, causes ?? new ChangeTrackingList<RouteSectionTecCause>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RouteSectionTec FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRouteSectionTec(document.RootElement);
        }
    }
}
