// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing
{
    /// <summary> The RouteRepresentationForBestOrder. </summary>
    public readonly partial struct RouteRepresentationForBestOrder : IEquatable<RouteRepresentationForBestOrder>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RouteRepresentationForBestOrder"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RouteRepresentationForBestOrder(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PolylineValue = "polyline";
        private const string SummaryOnlyValue = "summaryOnly";
        private const string NoneValue = "none";

        /// <summary> Includes route geometry in the response. </summary>
        public static RouteRepresentationForBestOrder Polyline { get; } = new RouteRepresentationForBestOrder(PolylineValue);
        /// <summary> Summary as per polyline but excluding the point geometry elements for the routes in the response. </summary>
        public static RouteRepresentationForBestOrder SummaryOnly { get; } = new RouteRepresentationForBestOrder(SummaryOnlyValue);
        /// <summary> Includes only the optimized waypoint indices but does not include the route geometry in the response. </summary>
        public static RouteRepresentationForBestOrder None { get; } = new RouteRepresentationForBestOrder(NoneValue);
        /// <summary> Determines if two <see cref="RouteRepresentationForBestOrder"/> values are the same. </summary>
        public static bool operator ==(RouteRepresentationForBestOrder left, RouteRepresentationForBestOrder right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RouteRepresentationForBestOrder"/> values are not the same. </summary>
        public static bool operator !=(RouteRepresentationForBestOrder left, RouteRepresentationForBestOrder right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RouteRepresentationForBestOrder"/>. </summary>
        public static implicit operator RouteRepresentationForBestOrder(string value) => new RouteRepresentationForBestOrder(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RouteRepresentationForBestOrder other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RouteRepresentationForBestOrder other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
