// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Routing.Models
{
    public partial class RouteReport
    {
        internal static RouteReport DeserializeRouteReport(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<EffectiveSetting> effectiveSettings = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("effectiveSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<EffectiveSetting> array = new List<EffectiveSetting>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(EffectiveSetting.DeserializeEffectiveSetting(item));
                    }
                    effectiveSettings = array;
                    continue;
                }
            }
            return new RouteReport(effectiveSettings ?? new ChangeTrackingList<EffectiveSetting>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RouteReport FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRouteReport(document.RootElement);
        }
    }
}
