// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Maps.Routing.Models
{
    /// <summary> This object is returned from a successful Route Reachable Range call. </summary>
    public partial class RouteRangeResult
    {
        /// <summary> Initializes a new instance of <see cref="RouteRangeResult"/>. </summary>
        internal RouteRangeResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RouteRangeResult"/>. </summary>
        /// <param name="formatVersion"> Format Version property. </param>
        /// <param name="reachableRange"> Reachable Range. </param>
        /// <param name="report"> Reports the effective settings used in the current call. </param>
        internal RouteRangeResult(string formatVersion, RouteRange reachableRange, RouteReport report)
        {
            FormatVersion = formatVersion;
            ReachableRange = reachableRange;
            Report = report;
        }

        /// <summary> Format Version property. </summary>
        public string FormatVersion { get; }
        /// <summary> Reachable Range. </summary>
        public RouteRange ReachableRange { get; }
        /// <summary> Reports the effective settings used in the current call. </summary>
        public RouteReport Report { get; }
    }
}
