// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Routing.Models
{
    public partial class RouteOptimizedWaypoint
    {
        internal static RouteOptimizedWaypoint DeserializeRouteOptimizedWaypoint(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? providedIndex = default;
            int? optimizedIndex = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("providedIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    providedIndex = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("optimizedIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    optimizedIndex = property.Value.GetInt32();
                    continue;
                }
            }
            return new RouteOptimizedWaypoint(providedIndex, optimizedIndex);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RouteOptimizedWaypoint FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRouteOptimizedWaypoint(document.RootElement);
        }
    }
}
