// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Routing.Models
{
    public partial class RouteMatrixSummary
    {
        internal static RouteMatrixSummary DeserializeRouteMatrixSummary(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? successfulRoutes = default;
            int? totalRoutes = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("successfulRoutes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    successfulRoutes = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalRoutes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalRoutes = property.Value.GetInt32();
                    continue;
                }
            }
            return new RouteMatrixSummary(successfulRoutes, totalRoutes);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RouteMatrixSummary FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRouteMatrixSummary(document.RootElement);
        }
    }
}
