// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;
using Azure.Maps.Common;
using Azure.Maps.Routing.Models;

namespace Azure.Maps.Routing
{
    public partial class RouteMatrixQuery : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Common.Optional.IsDefined(GeoJsonMultiPointOrigins))
            {
                writer.WritePropertyName("origins"u8);
                writer.WriteObjectValue<GeoJsonMultiPoint>(GeoJsonMultiPointOrigins);
            }
            if (Common.Optional.IsDefined(GeoJsonMultiPointDestinations))
            {
                writer.WritePropertyName("destinations"u8);
                writer.WriteObjectValue<GeoJsonMultiPoint>(GeoJsonMultiPointDestinations);
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
