// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Routing.Models
{
    public partial class RouteLegSummary
    {
        internal static RouteLegSummary DeserializeRouteLegSummary(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? lengthInMeters = default;
            int? travelTimeInSeconds = default;
            int? trafficDelayInSeconds = default;
            DateTimeOffset? departureTime = default;
            DateTimeOffset? arrivalTime = default;
            int? noTrafficTravelTimeInSeconds = default;
            int? historicTrafficTravelTimeInSeconds = default;
            int? liveTrafficIncidentsTravelTimeInSeconds = default;
            double? fuelConsumptionInLiters = default;
            double? batteryConsumptionInkWh = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("lengthInMeters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lengthInMeters = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("travelTimeInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    travelTimeInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("trafficDelayInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    trafficDelayInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("departureTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    departureTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("arrivalTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    arrivalTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("noTrafficTravelTimeInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    noTrafficTravelTimeInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("historicTrafficTravelTimeInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    historicTrafficTravelTimeInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("liveTrafficIncidentsTravelTimeInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    liveTrafficIncidentsTravelTimeInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("fuelConsumptionInLiters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fuelConsumptionInLiters = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("batteryConsumptionInkWh"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    batteryConsumptionInkWh = property.Value.GetDouble();
                    continue;
                }
            }
            return new RouteLegSummary(
                lengthInMeters,
                travelTimeInSeconds,
                trafficDelayInSeconds,
                departureTime,
                arrivalTime,
                noTrafficTravelTimeInSeconds,
                historicTrafficTravelTimeInSeconds,
                liveTrafficIncidentsTravelTimeInSeconds,
                fuelConsumptionInLiters,
                batteryConsumptionInkWh);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RouteLegSummary FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRouteLegSummary(document.RootElement);
        }
    }
}
