// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Routing.Models
{
    public partial class RouteLeg
    {
        internal static RouteLeg DeserializeRouteLeg(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            RouteLegSummary summary = default;
            IReadOnlyList<LatLongPair> points = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("summary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    summary = RouteLegSummary.DeserializeRouteLegSummary(property.Value);
                    continue;
                }
                if (property.NameEquals("points"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<LatLongPair> array = new List<LatLongPair>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(LatLongPair.DeserializeLatLongPair(item));
                    }
                    points = array;
                    continue;
                }
            }
            return new RouteLeg(summary, points ?? new ChangeTrackingList<LatLongPair>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RouteLeg FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRouteLeg(document.RootElement);
        }
    }
}
