// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing
{
    /// <summary> The RouteInstructionsType. </summary>
    public readonly partial struct RouteInstructionsType : IEquatable<RouteInstructionsType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RouteInstructionsType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RouteInstructionsType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CodedValue = "coded";
        private const string TextValue = "text";
        private const string TaggedValue = "tagged";

        /// <summary> Returns raw instruction data without human-readable messages. </summary>
        public static RouteInstructionsType Coded { get; } = new RouteInstructionsType(CodedValue);
        /// <summary> Returns raw instructions data with human-readable messages in plain text. </summary>
        public static RouteInstructionsType Text { get; } = new RouteInstructionsType(TextValue);
        /// <summary>
        /// Returns raw instruction data with tagged human-readable messages to permit formatting. A human-readable message is built up from repeatable identified elements. These are tagged to allow client applications to format them correctly. The following message components are tagged when instructionsType=tagged: street, roadNumber, signpostText, exitNumber, roundaboutExitNumber.
        ///
        /// Example of tagged 'Turn left' message:​
        ///
        /// ```
        /// Turn left onto &lt;roadNumber&gt;A4&lt;/roadNumber&gt;/&lt;roadNumber&gt;E19&lt;/roadNumber&gt;
        /// towards &lt;signpostText&gt;Den Haag&lt;/signpostText&gt;
        /// ```
        /// </summary>
        public static RouteInstructionsType Tagged { get; } = new RouteInstructionsType(TaggedValue);
        /// <summary> Determines if two <see cref="RouteInstructionsType"/> values are the same. </summary>
        public static bool operator ==(RouteInstructionsType left, RouteInstructionsType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RouteInstructionsType"/> values are not the same. </summary>
        public static bool operator !=(RouteInstructionsType left, RouteInstructionsType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RouteInstructionsType"/>. </summary>
        public static implicit operator RouteInstructionsType(string value) => new RouteInstructionsType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RouteInstructionsType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RouteInstructionsType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
