// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Routing.Models
{
    public partial class RouteInstructionGroup
    {
        internal static RouteInstructionGroup DeserializeRouteInstructionGroup(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? firstInstructionIndex = default;
            int? lastInstructionIndex = default;
            int? groupLengthInMeters = default;
            string groupMessage = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("firstInstructionIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    firstInstructionIndex = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("lastInstructionIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastInstructionIndex = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("groupLengthInMeters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    groupLengthInMeters = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("groupMessage"u8))
                {
                    groupMessage = property.Value.GetString();
                    continue;
                }
            }
            return new RouteInstructionGroup(firstInstructionIndex, lastInstructionIndex, groupLengthInMeters, groupMessage);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RouteInstructionGroup FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRouteInstructionGroup(document.RootElement);
        }
    }
}
