// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Routing.Models
{
    public partial class RouteInstruction
    {
        internal static RouteInstruction DeserializeRouteInstruction(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? routeOffsetInMeters = default;
            int? travelTimeInSeconds = default;
            LatLongPair point = default;
            int? pointIndex = default;
            GuidanceInstructionType? instructionType = default;
            IReadOnlyList<string> roadNumbers = default;
            string exitNumber = default;
            string street = default;
            string signpostText = default;
            string countryCode = default;
            string stateCode = default;
            JunctionType? junctionType = default;
            int? turnAngleInDecimalDegrees = default;
            long? roundaboutExitNumber = default;
            bool? possibleCombineWithNext = default;
            DrivingSide? drivingSide = default;
            GuidanceManeuver? maneuver = default;
            string message = default;
            string combinedMessage = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("routeOffsetInMeters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    routeOffsetInMeters = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("travelTimeInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    travelTimeInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("point"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    point = LatLongPair.DeserializeLatLongPair(property.Value);
                    continue;
                }
                if (property.NameEquals("pointIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pointIndex = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("instructionType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    instructionType = new GuidanceInstructionType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("roadNumbers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    roadNumbers = array;
                    continue;
                }
                if (property.NameEquals("exitNumber"u8))
                {
                    exitNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("street"u8))
                {
                    street = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("signpostText"u8))
                {
                    signpostText = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("countryCode"u8))
                {
                    countryCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("stateCode"u8))
                {
                    stateCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("junctionType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    junctionType = new JunctionType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("turnAngleInDecimalDegrees"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    turnAngleInDecimalDegrees = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("roundaboutExitNumber"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    roundaboutExitNumber = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("possibleCombineWithNext"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    possibleCombineWithNext = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("drivingSide"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    drivingSide = new DrivingSide(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("maneuver"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maneuver = new GuidanceManeuver(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("message"u8))
                {
                    message = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("combinedMessage"u8))
                {
                    combinedMessage = property.Value.GetString();
                    continue;
                }
            }
            return new RouteInstruction(
                routeOffsetInMeters,
                travelTimeInSeconds,
                point,
                pointIndex,
                instructionType,
                roadNumbers ?? new ChangeTrackingList<string>(),
                exitNumber,
                street,
                signpostText,
                countryCode,
                stateCode,
                junctionType,
                turnAngleInDecimalDegrees,
                roundaboutExitNumber,
                possibleCombineWithNext,
                drivingSide,
                maneuver,
                message,
                combinedMessage);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RouteInstruction FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRouteInstruction(document.RootElement);
        }
    }
}
