// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Routing.Models
{
    /// <summary> This object is returned from a successful Route Directions call. </summary>
    public partial class RouteDirections
    {
        /// <summary> Initializes a new instance of <see cref="RouteDirections"/>. </summary>
        internal RouteDirections()
        {
            Routes = new ChangeTrackingList<RouteData>();
            OptimizedWaypoints = new ChangeTrackingList<RouteOptimizedWaypoint>();
        }

        /// <summary> Initializes a new instance of <see cref="RouteDirections"/>. </summary>
        /// <param name="formatVersion"> Format Version property. </param>
        /// <param name="routes"> Routes array. </param>
        /// <param name="optimizedWaypoints">
        /// Optimized sequence of waypoints. It shows the index from the user provided waypoint sequence for the original and optimized list. For instance, a response:
        ///
        /// ```
        /// &lt;optimizedWaypoints&gt;
        /// &lt;waypoint providedIndex="0" optimizedIndex="1"/&gt;
        /// &lt;waypoint providedIndex="1" optimizedIndex="2"/&gt;
        /// &lt;waypoint providedIndex="2" optimizedIndex="0"/&gt;
        /// &lt;/optimizedWaypoints&gt;
        /// ```
        ///
        /// means that the original sequence is [0, 1, 2] and optimized sequence is [1, 2, 0]. Since the index starts by 0 the original is "first, second, third" while the optimized is "second, third, first".
        /// </param>
        /// <param name="report"> Reports the effective settings used in the current call. </param>
        internal RouteDirections(string formatVersion, IReadOnlyList<RouteData> routes, IReadOnlyList<RouteOptimizedWaypoint> optimizedWaypoints, RouteReport report)
        {
            FormatVersion = formatVersion;
            Routes = routes;
            OptimizedWaypoints = optimizedWaypoints;
            Report = report;
        }

        /// <summary> Format Version property. </summary>
        public string FormatVersion { get; }
        /// <summary> Routes array. </summary>
        public IReadOnlyList<RouteData> Routes { get; }
        /// <summary>
        /// Optimized sequence of waypoints. It shows the index from the user provided waypoint sequence for the original and optimized list. For instance, a response:
        ///
        /// ```
        /// &lt;optimizedWaypoints&gt;
        /// &lt;waypoint providedIndex="0" optimizedIndex="1"/&gt;
        /// &lt;waypoint providedIndex="1" optimizedIndex="2"/&gt;
        /// &lt;waypoint providedIndex="2" optimizedIndex="0"/&gt;
        /// &lt;/optimizedWaypoints&gt;
        /// ```
        ///
        /// means that the original sequence is [0, 1, 2] and optimized sequence is [1, 2, 0]. Since the index starts by 0 the original is "first, second, third" while the optimized is "second, third, first".
        /// </summary>
        public IReadOnlyList<RouteOptimizedWaypoint> OptimizedWaypoints { get; }
        /// <summary> Reports the effective settings used in the current call. </summary>
        public RouteReport Report { get; }
    }
}
