// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;
using Azure.Maps.Routing.Models;

namespace Azure.Maps.Routing
{
    /// <summary> Post body parameters for Route directions. </summary>
    public partial class RouteDirectionParameters
    {
        /// <summary> Initializes a new instance of <see cref="RouteDirectionParameters"/>. </summary>
        /// <param name="geoJsonSupportingPoints">
        /// A GeoJSON Geometry collection representing sequence of coordinates used as input for route reconstruction and for calculating zero or more alternative routes to this reference route.
        ///   - The provided sequence of supporting points is used as input for route reconstruction.
        ///   - The alternative routes are calculated between the origin and destination points specified in the base path parameter locations.
        ///   - If both _minDeviationDistance_ and _minDeviationTime_ are set to zero, then these origin and destination points are
        ///   expected to be at (or very near) the beginning and end of the reference route, respectively.
        ///   - Intermediate locations (_waypoints_) are not supported when using &lt;_supportingPoints_&gt;.
        ///   - The reference route may contain traffic incidents of type _ROAD_CLOSURE_, which are
        ///   ignored for the calculation of the reference route's travel time and traffic delay.
        ///  Please refer to [Supporting Points](https://docs.microsoft.com/azure/azure-maps/how-to-use-best-practices-for-routing#calculate-and-bias-alternative-routes-using-supporting-points) for details.
        /// </param>
        /// <param name="avoidVignette"> This is a list of 3-character, ISO 3166-1, alpha-3 country codes of countries/regions in which all toll roads with vignettes are to be avoided, e.g. "AUS,CHE". Toll roads with vignettes in countries/regions not in the list are unaffected. Note: It is an error to specify both **avoidVignette** and **allowVignette**. </param>
        /// <param name="allowVignette"> This is a list of 3-character, ISO 3166-1, alpha-3 country codes of countries/regions in which toll roads with vignettes are allowed, e.g. "AUS,CHE". Specifying **allowVignette** with some countries/regions X is equivalent to specifying **avoidVignette** with all countries/regions but X. Specifying **allowVignette** with an empty list is the same as avoiding all toll roads with vignettes. Note: It is an error to specify both **avoidVignette** and **allowVignette**. </param>
        /// <param name="geoJsonAvoidAreas"> A GeoJSON MultiPolygon representing list of areas to avoid. Only rectangle polygons are supported. The maximum size of a rectangle is about 160x160 km. Maximum number of avoided areas is **10**. It cannot cross the 180th meridian. It must be between -80 and +80 degrees of latitude. </param>
        internal RouteDirectionParameters(GeoJsonGeometryCollection geoJsonSupportingPoints, IList<string> avoidVignette, IList<string> allowVignette, GeoJsonMultiPolygon geoJsonAvoidAreas)
        {
            _GeoJsonSupportingPoints = geoJsonSupportingPoints;
            AvoidVignette = avoidVignette;
            AllowVignette = allowVignette;
            _GeoJsonAvoidAreas = geoJsonAvoidAreas;
        }
        /// <summary> This is a list of 3-character, ISO 3166-1, alpha-3 country codes of countries/regions in which all toll roads with vignettes are to be avoided, e.g. "AUS,CHE". Toll roads with vignettes in countries/regions not in the list are unaffected. Note: It is an error to specify both **avoidVignette** and **allowVignette**. </summary>
        public IList<string> AvoidVignette { get; }
        /// <summary> This is a list of 3-character, ISO 3166-1, alpha-3 country codes of countries/regions in which toll roads with vignettes are allowed, e.g. "AUS,CHE". Specifying **allowVignette** with some countries/regions X is equivalent to specifying **avoidVignette** with all countries/regions but X. Specifying **allowVignette** with an empty list is the same as avoiding all toll roads with vignettes. Note: It is an error to specify both **avoidVignette** and **allowVignette**. </summary>
        public IList<string> AllowVignette { get; }
    }
}
