// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Routing.Models
{
    /// <summary> The Route. </summary>
    public partial class RouteData
    {
        /// <summary> Initializes a new instance of <see cref="RouteData"/>. </summary>
        internal RouteData()
        {
            Legs = new ChangeTrackingList<RouteLeg>();
            Sections = new ChangeTrackingList<RouteSection>();
        }

        /// <summary> Initializes a new instance of <see cref="RouteData"/>. </summary>
        /// <param name="summary"> Summary object. </param>
        /// <param name="legs"> Legs array. </param>
        /// <param name="sections"> Sections array. </param>
        /// <param name="guidance"> Contains guidance related elements. This field is present only when guidance was requested and is available. </param>
        internal RouteData(RouteSummary summary, IReadOnlyList<RouteLeg> legs, IReadOnlyList<RouteSection> sections, RouteGuidance guidance)
        {
            Summary = summary;
            Legs = legs;
            Sections = sections;
            Guidance = guidance;
        }

        /// <summary> Summary object. </summary>
        public RouteSummary Summary { get; }
        /// <summary> Legs array. </summary>
        public IReadOnlyList<RouteLeg> Legs { get; }
        /// <summary> Sections array. </summary>
        public IReadOnlyList<RouteSection> Sections { get; }
        /// <summary> Contains guidance related elements. This field is present only when guidance was requested and is available. </summary>
        public RouteGuidance Guidance { get; }
    }
}
