// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Routing.Models
{
    public partial class RouteData
    {
        internal static RouteData DeserializeRouteData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            RouteSummary summary = default;
            IReadOnlyList<RouteLeg> legs = default;
            IReadOnlyList<RouteSection> sections = default;
            RouteGuidance guidance = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("summary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    summary = RouteSummary.DeserializeRouteSummary(property.Value);
                    continue;
                }
                if (property.NameEquals("legs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RouteLeg> array = new List<RouteLeg>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(RouteLeg.DeserializeRouteLeg(item));
                    }
                    legs = array;
                    continue;
                }
                if (property.NameEquals("sections"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RouteSection> array = new List<RouteSection>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(RouteSection.DeserializeRouteSection(item));
                    }
                    sections = array;
                    continue;
                }
                if (property.NameEquals("guidance"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    guidance = RouteGuidance.DeserializeRouteGuidance(property.Value);
                    continue;
                }
            }
            return new RouteData(summary, legs ?? new ChangeTrackingList<RouteLeg>(), sections ?? new ChangeTrackingList<RouteSection>(), guidance);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RouteData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRouteData(document.RootElement);
        }
    }
}
