// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing
{
    /// <summary> The RouteAvoidType. </summary>
    public readonly partial struct RouteAvoidType : IEquatable<RouteAvoidType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RouteAvoidType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RouteAvoidType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TollRoadsValue = "tollRoads";
        private const string MotorwaysValue = "motorways";
        private const string FerriesValue = "ferries";
        private const string UnpavedRoadsValue = "unpavedRoads";
        private const string CarpoolsValue = "carpools";
        private const string AlreadyUsedRoadsValue = "alreadyUsedRoads";
        private const string BorderCrossingsValue = "borderCrossings";

        /// <summary> Avoids toll roads. </summary>
        public static RouteAvoidType TollRoads { get; } = new RouteAvoidType(TollRoadsValue);
        /// <summary> Avoids motorways. </summary>
        public static RouteAvoidType Motorways { get; } = new RouteAvoidType(MotorwaysValue);
        /// <summary> Avoids ferries. </summary>
        public static RouteAvoidType Ferries { get; } = new RouteAvoidType(FerriesValue);
        /// <summary> Avoids unpaved roads. </summary>
        public static RouteAvoidType UnpavedRoads { get; } = new RouteAvoidType(UnpavedRoadsValue);
        /// <summary> Avoids routes that require the use of carpool (HOV/High Occupancy Vehicle) lanes. </summary>
        public static RouteAvoidType Carpools { get; } = new RouteAvoidType(CarpoolsValue);
        /// <summary> Avoids using the same road multiple times. Most useful in conjunction with `routeType`=thrilling. </summary>
        public static RouteAvoidType AlreadyUsedRoads { get; } = new RouteAvoidType(AlreadyUsedRoadsValue);
        /// <summary> Avoids border crossings in route calculation. </summary>
        public static RouteAvoidType BorderCrossings { get; } = new RouteAvoidType(BorderCrossingsValue);
        /// <summary> Determines if two <see cref="RouteAvoidType"/> values are the same. </summary>
        public static bool operator ==(RouteAvoidType left, RouteAvoidType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RouteAvoidType"/> values are not the same. </summary>
        public static bool operator !=(RouteAvoidType left, RouteAvoidType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RouteAvoidType"/>. </summary>
        public static implicit operator RouteAvoidType(string value) => new RouteAvoidType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RouteAvoidType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RouteAvoidType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
