// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing.Models
{
    /// <summary> Travel mode for the calculated route. The value will be set to `other` if the requested mode of transport is not possible in this section. </summary>
    public readonly partial struct ResponseTravelMode : IEquatable<ResponseTravelMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResponseTravelMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResponseTravelMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CarValue = "car";
        private const string TruckValue = "truck";
        private const string TaxiValue = "taxi";
        private const string BusValue = "bus";
        private const string VanValue = "van";
        private const string MotorcycleValue = "motorcycle";
        private const string BicycleValue = "bicycle";
        private const string PedestrianValue = "pedestrian";
        private const string OtherValue = "other";

        /// <summary> The returned routes are optimized for cars. </summary>
        public static ResponseTravelMode Car { get; } = new ResponseTravelMode(CarValue);
        /// <summary> The returned routes are optimized for commercial vehicles, like for trucks. </summary>
        public static ResponseTravelMode Truck { get; } = new ResponseTravelMode(TruckValue);
        /// <summary> The returned routes are optimized for taxis. BETA functionality. </summary>
        public static ResponseTravelMode Taxi { get; } = new ResponseTravelMode(TaxiValue);
        /// <summary> The returned routes are optimized for buses, including the use of bus only lanes. BETA functionality. </summary>
        public static ResponseTravelMode Bus { get; } = new ResponseTravelMode(BusValue);
        /// <summary> The returned routes are optimized for vans. BETA functionality. </summary>
        public static ResponseTravelMode Van { get; } = new ResponseTravelMode(VanValue);
        /// <summary> The returned routes are optimized for motorcycles. BETA functionality. </summary>
        public static ResponseTravelMode Motorcycle { get; } = new ResponseTravelMode(MotorcycleValue);
        /// <summary> The returned routes are optimized for bicycles, including use of bicycle lanes. </summary>
        public static ResponseTravelMode Bicycle { get; } = new ResponseTravelMode(BicycleValue);
        /// <summary> The returned routes are optimized for pedestrians, including the use of sidewalks. </summary>
        public static ResponseTravelMode Pedestrian { get; } = new ResponseTravelMode(PedestrianValue);
        /// <summary> The given mode of transport is not possible in this section. </summary>
        public static ResponseTravelMode Other { get; } = new ResponseTravelMode(OtherValue);
        /// <summary> Determines if two <see cref="ResponseTravelMode"/> values are the same. </summary>
        public static bool operator ==(ResponseTravelMode left, ResponseTravelMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResponseTravelMode"/> values are not the same. </summary>
        public static bool operator !=(ResponseTravelMode left, ResponseTravelMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResponseTravelMode"/>. </summary>
        public static implicit operator ResponseTravelMode(string value) => new ResponseTravelMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResponseTravelMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResponseTravelMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
