// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing.Models
{
    /// <summary> Section types of the reported route response. </summary>
    public readonly partial struct ResponseSectionType : IEquatable<ResponseSectionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResponseSectionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResponseSectionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CarOrTrainValue = "CAR_TRAIN";
        private const string CountryValue = "COUNTRY";
        private const string FerryValue = "FERRY";
        private const string MotorwayValue = "MOTORWAY";
        private const string PedestrianValue = "PEDESTRIAN";
        private const string TollRoadValue = "TOLL_ROAD";
        private const string TollVignetteValue = "TOLL_VIGNETTE";
        private const string TrafficValue = "TRAFFIC";
        private const string TravelModeValue = "TRAVEL_MODE";
        private const string TunnelValue = "TUNNEL";
        private const string CarpoolValue = "CARPOOL";
        private const string UrbanValue = "URBAN";

        /// <summary> Sections of the route that are cars or trains. </summary>
        public static ResponseSectionType CarOrTrain { get; } = new ResponseSectionType(CarOrTrainValue);
        /// <summary> Sections indicating which countries/regions the route is in. </summary>
        public static ResponseSectionType Country { get; } = new ResponseSectionType(CountryValue);
        /// <summary> Sections of the route that are ferries. </summary>
        public static ResponseSectionType Ferry { get; } = new ResponseSectionType(FerryValue);
        /// <summary> Sections of the route that are motorways. </summary>
        public static ResponseSectionType Motorway { get; } = new ResponseSectionType(MotorwayValue);
        /// <summary> Sections of the route that are only suited for pedestrians. </summary>
        public static ResponseSectionType Pedestrian { get; } = new ResponseSectionType(PedestrianValue);
        /// <summary> Sections of the route that require a toll to be payed. </summary>
        public static ResponseSectionType TollRoad { get; } = new ResponseSectionType(TollRoadValue);
        /// <summary> Sections of the route that require a toll vignette to be present. </summary>
        public static ResponseSectionType TollVignette { get; } = new ResponseSectionType(TollVignetteValue);
        /// <summary> Sections of the route that contain traffic information. </summary>
        public static ResponseSectionType Traffic { get; } = new ResponseSectionType(TrafficValue);
        /// <summary> Sections in relation to the request parameter `travelMode`. </summary>
        public static ResponseSectionType TravelMode { get; } = new ResponseSectionType(TravelModeValue);
        /// <summary> Sections of the route that are tunnels. </summary>
        public static ResponseSectionType Tunnel { get; } = new ResponseSectionType(TunnelValue);
        /// <summary> Sections of the route that require use of carpool (HOV/High Occupancy Vehicle) lanes. </summary>
        public static ResponseSectionType Carpool { get; } = new ResponseSectionType(CarpoolValue);
        /// <summary> Sections of the route that are located within urban areas. </summary>
        public static ResponseSectionType Urban { get; } = new ResponseSectionType(UrbanValue);
        /// <summary> Determines if two <see cref="ResponseSectionType"/> values are the same. </summary>
        public static bool operator ==(ResponseSectionType left, ResponseSectionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResponseSectionType"/> values are not the same. </summary>
        public static bool operator !=(ResponseSectionType left, ResponseSectionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResponseSectionType"/>. </summary>
        public static implicit operator ResponseSectionType(string value) => new ResponseSectionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResponseSectionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResponseSectionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
