// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing.Models
{
    /// <summary> The Report. </summary>
    internal readonly partial struct Report : IEquatable<Report>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="Report"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public Report(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EffectiveSettingsValue = "effectiveSettings";

        /// <summary> Reports the effective parameters or data used when calling the API. </summary>
        public static Report EffectiveSettings { get; } = new Report(EffectiveSettingsValue);
        /// <summary> Determines if two <see cref="Report"/> values are the same. </summary>
        public static bool operator ==(Report left, Report right) => left.Equals(right);
        /// <summary> Determines if two <see cref="Report"/> values are not the same. </summary>
        public static bool operator !=(Report left, Report right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="Report"/>. </summary>
        public static implicit operator Report(string value) => new Report(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is Report other && Equals(other);
        /// <inheritdoc />
        public bool Equals(Report other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
