// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing
{
    /// <summary> The InclineLevel. </summary>
    public readonly partial struct InclineLevel : IEquatable<InclineLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InclineLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InclineLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowValue = "low";
        private const string NormalValue = "normal";
        private const string HighValue = "high";

        /// <summary> low. </summary>
        public static InclineLevel Low { get; } = new InclineLevel(LowValue);
        /// <summary> normal. </summary>
        public static InclineLevel Normal { get; } = new InclineLevel(NormalValue);
        /// <summary> high. </summary>
        public static InclineLevel High { get; } = new InclineLevel(HighValue);
        /// <summary> Determines if two <see cref="InclineLevel"/> values are the same. </summary>
        public static bool operator ==(InclineLevel left, InclineLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InclineLevel"/> values are not the same. </summary>
        public static bool operator !=(InclineLevel left, InclineLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InclineLevel"/>. </summary>
        public static implicit operator InclineLevel(string value) => new InclineLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InclineLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InclineLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
