// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing.Models
{
    /// <summary> A code identifying the maneuver. </summary>
    public readonly partial struct GuidanceManeuver : IEquatable<GuidanceManeuver>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GuidanceManeuver"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GuidanceManeuver(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ArriveValue = "ARRIVE";
        private const string ArriveLeftValue = "ARRIVE_LEFT";
        private const string ArriveRightValue = "ARRIVE_RIGHT";
        private const string DepartValue = "DEPART";
        private const string StraightValue = "STRAIGHT";
        private const string KeepRightValue = "KEEP_RIGHT";
        private const string BearRightValue = "BEAR_RIGHT";
        private const string TurnRightValue = "TURN_RIGHT";
        private const string SharpRightValue = "SHARP_RIGHT";
        private const string KeepLeftValue = "KEEP_LEFT";
        private const string BearLeftValue = "BEAR_LEFT";
        private const string TurnLeftValue = "TURN_LEFT";
        private const string SharpLeftValue = "SHARP_LEFT";
        private const string MakeUTurnValue = "MAKE_UTURN";
        private const string EnterMotorwayValue = "ENTER_MOTORWAY";
        private const string EnterFreewayValue = "ENTER_FREEWAY";
        private const string EnterHighwayValue = "ENTER_HIGHWAY";
        private const string TakeExitValue = "TAKE_EXIT";
        private const string MotorwayExitLeftValue = "MOTORWAY_EXIT_LEFT";
        private const string MotorwayExitRightValue = "MOTORWAY_EXIT_RIGHT";
        private const string TakeFerryValue = "TAKE_FERRY";
        private const string RoundaboutCrossValue = "ROUNDABOUT_CROSS";
        private const string RoundaboutRightValue = "ROUNDABOUT_RIGHT";
        private const string RoundaboutLeftValue = "ROUNDABOUT_LEFT";
        private const string RoundaboutBackValue = "ROUNDABOUT_BACK";
        private const string TryMakeUTurnValue = "TRY_MAKE_UTURN";
        private const string FollowValue = "FOLLOW";
        private const string SwitchParallelRoadValue = "SWITCH_PARALLEL_ROAD";
        private const string SwitchMainRoadValue = "SWITCH_MAIN_ROAD";
        private const string EntranceRampValue = "ENTRANCE_RAMP";
        private const string WaypointLeftValue = "WAYPOINT_LEFT";
        private const string WaypointRightValue = "WAYPOINT_RIGHT";
        private const string WaypointReachedValue = "WAYPOINT_REACHED";

        /// <summary> You have arrived. </summary>
        public static GuidanceManeuver Arrive { get; } = new GuidanceManeuver(ArriveValue);
        /// <summary> You have arrived. Your destination is on the left. </summary>
        public static GuidanceManeuver ArriveLeft { get; } = new GuidanceManeuver(ArriveLeftValue);
        /// <summary> You have arrived. Your destination is on the right. </summary>
        public static GuidanceManeuver ArriveRight { get; } = new GuidanceManeuver(ArriveRightValue);
        /// <summary> Leave. </summary>
        public static GuidanceManeuver Depart { get; } = new GuidanceManeuver(DepartValue);
        /// <summary> Keep straight on. </summary>
        public static GuidanceManeuver Straight { get; } = new GuidanceManeuver(StraightValue);
        /// <summary> Keep right. </summary>
        public static GuidanceManeuver KeepRight { get; } = new GuidanceManeuver(KeepRightValue);
        /// <summary> Bear right. </summary>
        public static GuidanceManeuver BearRight { get; } = new GuidanceManeuver(BearRightValue);
        /// <summary> Turn right. </summary>
        public static GuidanceManeuver TurnRight { get; } = new GuidanceManeuver(TurnRightValue);
        /// <summary> Turn sharp right. </summary>
        public static GuidanceManeuver SharpRight { get; } = new GuidanceManeuver(SharpRightValue);
        /// <summary> Keep left. </summary>
        public static GuidanceManeuver KeepLeft { get; } = new GuidanceManeuver(KeepLeftValue);
        /// <summary> Bear left. </summary>
        public static GuidanceManeuver BearLeft { get; } = new GuidanceManeuver(BearLeftValue);
        /// <summary> Turn left. </summary>
        public static GuidanceManeuver TurnLeft { get; } = new GuidanceManeuver(TurnLeftValue);
        /// <summary> Turn sharp left. </summary>
        public static GuidanceManeuver SharpLeft { get; } = new GuidanceManeuver(SharpLeftValue);
        /// <summary> Make a U-turn. </summary>
        public static GuidanceManeuver MakeUTurn { get; } = new GuidanceManeuver(MakeUTurnValue);
        /// <summary> Take the motorway. </summary>
        public static GuidanceManeuver EnterMotorway { get; } = new GuidanceManeuver(EnterMotorwayValue);
        /// <summary> Take the freeway. </summary>
        public static GuidanceManeuver EnterFreeway { get; } = new GuidanceManeuver(EnterFreewayValue);
        /// <summary> Take the highway. </summary>
        public static GuidanceManeuver EnterHighway { get; } = new GuidanceManeuver(EnterHighwayValue);
        /// <summary> Take the exit. </summary>
        public static GuidanceManeuver TakeExit { get; } = new GuidanceManeuver(TakeExitValue);
        /// <summary> Take the left exit. </summary>
        public static GuidanceManeuver MotorwayExitLeft { get; } = new GuidanceManeuver(MotorwayExitLeftValue);
        /// <summary> Take the right exit. </summary>
        public static GuidanceManeuver MotorwayExitRight { get; } = new GuidanceManeuver(MotorwayExitRightValue);
        /// <summary> Take the ferry. </summary>
        public static GuidanceManeuver TakeFerry { get; } = new GuidanceManeuver(TakeFerryValue);
        /// <summary> Cross the roundabout. </summary>
        public static GuidanceManeuver RoundaboutCross { get; } = new GuidanceManeuver(RoundaboutCrossValue);
        /// <summary> At the roundabout take the exit on the right. </summary>
        public static GuidanceManeuver RoundaboutRight { get; } = new GuidanceManeuver(RoundaboutRightValue);
        /// <summary> At the roundabout take the exit on the left. </summary>
        public static GuidanceManeuver RoundaboutLeft { get; } = new GuidanceManeuver(RoundaboutLeftValue);
        /// <summary> Go around the roundabout. </summary>
        public static GuidanceManeuver RoundaboutBack { get; } = new GuidanceManeuver(RoundaboutBackValue);
        /// <summary> Try to make a U-turn. </summary>
        public static GuidanceManeuver TryMakeUTurn { get; } = new GuidanceManeuver(TryMakeUTurnValue);
        /// <summary> Follow. </summary>
        public static GuidanceManeuver Follow { get; } = new GuidanceManeuver(FollowValue);
        /// <summary> Switch to the parallel road. </summary>
        public static GuidanceManeuver SwitchParallelRoad { get; } = new GuidanceManeuver(SwitchParallelRoadValue);
        /// <summary> Switch to the main road. </summary>
        public static GuidanceManeuver SwitchMainRoad { get; } = new GuidanceManeuver(SwitchMainRoadValue);
        /// <summary> Take the ramp. </summary>
        public static GuidanceManeuver EntranceRamp { get; } = new GuidanceManeuver(EntranceRampValue);
        /// <summary> You have reached the waypoint. It is on the left. </summary>
        public static GuidanceManeuver WaypointLeft { get; } = new GuidanceManeuver(WaypointLeftValue);
        /// <summary> You have reached the waypoint. It is on the right. </summary>
        public static GuidanceManeuver WaypointRight { get; } = new GuidanceManeuver(WaypointRightValue);
        /// <summary> You have reached the waypoint. </summary>
        public static GuidanceManeuver WaypointReached { get; } = new GuidanceManeuver(WaypointReachedValue);
        /// <summary> Determines if two <see cref="GuidanceManeuver"/> values are the same. </summary>
        public static bool operator ==(GuidanceManeuver left, GuidanceManeuver right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GuidanceManeuver"/> values are not the same. </summary>
        public static bool operator !=(GuidanceManeuver left, GuidanceManeuver right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GuidanceManeuver"/>. </summary>
        public static implicit operator GuidanceManeuver(string value) => new GuidanceManeuver(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GuidanceManeuver other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GuidanceManeuver other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
