// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing.Models
{
    /// <summary> Type of the instruction, e.g., turn or change of road form. </summary>
    public readonly partial struct GuidanceInstructionType : IEquatable<GuidanceInstructionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GuidanceInstructionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GuidanceInstructionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TurnValue = "TURN";
        private const string RoadChangeValue = "ROAD_CHANGE";
        private const string LocationDepartureValue = "LOCATION_DEPARTURE";
        private const string LocationArrivalValue = "LOCATION_ARRIVAL";
        private const string DirectionInfoValue = "DIRECTION_INFO";
        private const string LocationWaypointValue = "LOCATION_WAYPOINT";

        /// <summary> Turn. </summary>
        public static GuidanceInstructionType Turn { get; } = new GuidanceInstructionType(TurnValue);
        /// <summary> Road Change. </summary>
        public static GuidanceInstructionType RoadChange { get; } = new GuidanceInstructionType(RoadChangeValue);
        /// <summary> Departure location. </summary>
        public static GuidanceInstructionType LocationDeparture { get; } = new GuidanceInstructionType(LocationDepartureValue);
        /// <summary> Arrival location. </summary>
        public static GuidanceInstructionType LocationArrival { get; } = new GuidanceInstructionType(LocationArrivalValue);
        /// <summary> Direction information. </summary>
        public static GuidanceInstructionType DirectionInfo { get; } = new GuidanceInstructionType(DirectionInfoValue);
        /// <summary> Way point location. </summary>
        public static GuidanceInstructionType LocationWaypoint { get; } = new GuidanceInstructionType(LocationWaypointValue);
        /// <summary> Determines if two <see cref="GuidanceInstructionType"/> values are the same. </summary>
        public static bool operator ==(GuidanceInstructionType left, GuidanceInstructionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GuidanceInstructionType"/> values are not the same. </summary>
        public static bool operator !=(GuidanceInstructionType left, GuidanceInstructionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GuidanceInstructionType"/>. </summary>
        public static implicit operator GuidanceInstructionType(string value) => new GuidanceInstructionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GuidanceInstructionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GuidanceInstructionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
