// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing.Models
{
    /// <summary> Indicates left-hand vs. right-hand side driving at the point of the maneuver. </summary>
    public readonly partial struct DrivingSide : IEquatable<DrivingSide>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DrivingSide"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DrivingSide(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LeftValue = "LEFT";
        private const string RightValue = "RIGHT";

        /// <summary> Left side. </summary>
        public static DrivingSide Left { get; } = new DrivingSide(LeftValue);
        /// <summary> Right side. </summary>
        public static DrivingSide Right { get; } = new DrivingSide(RightValue);
        /// <summary> Determines if two <see cref="DrivingSide"/> values are the same. </summary>
        public static bool operator ==(DrivingSide left, DrivingSide right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DrivingSide"/> values are not the same. </summary>
        public static bool operator !=(DrivingSide left, DrivingSide right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DrivingSide"/>. </summary>
        public static implicit operator DrivingSide(string value) => new DrivingSide(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DrivingSide other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DrivingSide other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
