// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Routing.Models
{
    /// <summary> The magnitude of delay caused by the incident. These values correspond to the values of the response field ty of the [Get Traffic Incident Detail API](https://docs.microsoft.com/rest/api/maps/traffic/gettrafficincidentdetail). </summary>
    public readonly partial struct DelayMagnitude : IEquatable<DelayMagnitude>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DelayMagnitude"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DelayMagnitude(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "0";
        private const string MinorValue = "1";
        private const string ModerateValue = "2";
        private const string MajorValue = "3";
        private const string UndefinedValue = "4";

        /// <summary> Unknown. </summary>
        public static DelayMagnitude Unknown { get; } = new DelayMagnitude(UnknownValue);
        /// <summary> Minor. </summary>
        public static DelayMagnitude Minor { get; } = new DelayMagnitude(MinorValue);
        /// <summary> Moderate. </summary>
        public static DelayMagnitude Moderate { get; } = new DelayMagnitude(ModerateValue);
        /// <summary> Major. </summary>
        public static DelayMagnitude Major { get; } = new DelayMagnitude(MajorValue);
        /// <summary> Undefined, used for road closures and other indefinite delays. </summary>
        public static DelayMagnitude Undefined { get; } = new DelayMagnitude(UndefinedValue);
        /// <summary> Determines if two <see cref="DelayMagnitude"/> values are the same. </summary>
        public static bool operator ==(DelayMagnitude left, DelayMagnitude right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DelayMagnitude"/> values are not the same. </summary>
        public static bool operator !=(DelayMagnitude left, DelayMagnitude right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DelayMagnitude"/>. </summary>
        public static implicit operator DelayMagnitude(string value) => new DelayMagnitude(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DelayMagnitude other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DelayMagnitude other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
